/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.ext;

import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlSelectOneRadio;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.AltProperty;
import org.apache.myfaces.component.DataProperties;
import org.apache.myfaces.component.DisplayValueOnlyAware;
import org.apache.myfaces.component.EscapeAware;
import org.apache.myfaces.component.ForceIdAware;
import org.apache.myfaces.component.UserRoleAware;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.component.html.util.HtmlComponentUtils;
import org.apache.myfaces.shared_tomahawk.component.DisplayValueOnlyCapable;
import org.apache.myfaces.shared_tomahawk.component.EscapeCapable;
import org.apache.myfaces.shared_tomahawk.util.MessageUtils;

public abstract class AbstractHtmlSelectOneRadio
extends HtmlSelectOneRadio
implements UserRoleAware,
DisplayValueOnlyCapable,
EscapeCapable,
EscapeAware,
DisplayValueOnlyAware,
ForceIdAware,
DataProperties,
AltProperty {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlSelectOneRadio";
    public static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.Radio";
    private static Log log = LogFactory.getLog(AbstractHtmlSelectOneRadio.class);

    public String getClientId(FacesContext context) {
        String clientId = HtmlComponentUtils.getClientId((UIComponent)this, this.getRenderer(context), context);
        if (clientId == null) {
            clientId = super.getClientId(context);
        }
        return clientId;
    }

    protected void validateValue(FacesContext context, Object value) {
        boolean dataTable;
        boolean forceId = AbstractHtmlSelectOneRadio.getBooleanValue("forceId", this.getAttributes().get("forceId"), false);
        boolean forceIdIndex = AbstractHtmlSelectOneRadio.getBooleanValue("forceIdIndex", this.getAttributes().get("forceIdIndex"), true);
        boolean bl = dataTable = forceId && !forceIdIndex;
        if (!dataTable) {
            super.validateValue(context, value);
        } else {
            boolean empty;
            boolean bl2 = empty = value == null || value instanceof String && ((String)value).length() == 0;
            if (this.isRequired() && empty) {
                String clientId = this.getClientId(context);
                Iterator messages = context.getMessages(clientId);
                boolean messageExists = messages.hasNext();
                if (!messageExists) {
                    FacesMessage message = MessageUtils.getMessage("javax.faces.component.UIInput.REQUIRED", new Object[]{clientId});
                    message.setSeverity(FacesMessage.SEVERITY_WARN);
                    context.addMessage(clientId, message);
                    this.setValid(false);
                }
                return;
            }
            if (!empty) {
                AbstractHtmlSelectOneRadio.callValidators(context, (UIComponent)this, value);
            }
        }
    }

    private static boolean getBooleanValue(String attribute, Object value, boolean defaultValue) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        if (value != null) {
            log.error((Object)("value for attribute " + attribute + " must be instanceof 'Boolean' or 'String', is of type : " + value.getClass()));
            return defaultValue;
        }
        return defaultValue;
    }

    private static void callValidators(FacesContext context, UIComponent input, Object convertedValue) {
        FacesMessage facesMessage;
        if (!(input instanceof EditableValueHolder)) {
            throw new FacesException("param input not of type EditableValueHolder, but of : " + input.getClass().getName());
        }
        EditableValueHolder holder = (EditableValueHolder)input;
        Validator[] validators = holder.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            Validator validator = validators[i];
            try {
                validator.validate(context, input, convertedValue);
                continue;
            }
            catch (ValidatorException e) {
                holder.setValid(false);
                facesMessage = e.getFacesMessage();
                if (facesMessage == null) continue;
                facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(input.getClientId(context), facesMessage);
            }
        }
        MethodBinding validatorBinding = holder.getValidator();
        if (validatorBinding != null) {
            try {
                validatorBinding.invoke(context, new Object[]{context, input, convertedValue});
            }
            catch (EvaluationException e) {
                holder.setValid(false);
                Throwable cause = e.getCause();
                if (cause instanceof ValidatorException) {
                    facesMessage = ((ValidatorException)cause).getFacesMessage();
                    if (facesMessage != null) {
                        facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
                        context.addMessage(input.getClientId(context), facesMessage);
                    }
                }
                throw e;
            }
        }
    }

    public boolean isSetDisplayValueOnly() {
        return this.getDisplayValueOnly() != null;
    }

    public boolean isDisplayValueOnly() {
        return this.getDisplayValueOnly() != null ? this.getDisplayValueOnly() : false;
    }

    public void setDisplayValueOnly(boolean displayValueOnly) {
        this.setDisplayValueOnly(displayValueOnly);
    }

    public boolean isRendered() {
        if (!UserRoleUtils.isVisibleOnUserRole((UIComponent)this)) {
            return false;
        }
        return super.isRendered();
    }
}

