/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.mygroup.example6;

import org.apache.commons.lang3.ArrayUtils;

/**
 * A simple greeter
 */
public class Greeting {

  /**
   * Default constructor for Greeting class.
   * This constructor does not take any parameters to initialize a Greeting.
   */
  public Greeting() {
    // Default constructor
  }

  /**
   * Using commons lang3 to convert an array to a string
   *
   * @param words a string array
   * @return a string representation of the array followed by an exclamation mark.
   */
  public String greet(String[] words) {
    return ArrayUtils.toString(words) + "!";
  }

  /**
   * Main method to demonstrate the Greeting functionality.
   * It creates an instance of Greeting and prints a greeting message.
   *
   * @param args command line arguments (not used)
   */
  public static void main(String[] args) {
    Greeting greeting = new Greeting();
    String[] words = {"Hello", "World"};
    System.out.println(greeting.greet(words));
  }
}
