/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.webservices;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.server.impl.webservices.AbstractCallContextInterceptor;
import org.apache.chemistry.opencmis.server.shared.CallContextHandler;
import org.apache.cxf.binding.soap.SoapMessage;

public class CallContextHandlerInterceptor
extends AbstractCallContextInterceptor {
    private final CallContextHandler callContextHandler;

    public CallContextHandlerInterceptor(CallContextHandler callContextHandler) {
        this.callContextHandler = callContextHandler;
    }

    public void handleMessage(SoapMessage message) {
        if (this.callContextHandler == null) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        if (request == null) {
            return;
        }
        Map<String, String> callContextMap = this.callContextHandler.getCallContextMap(request);
        if (callContextMap == null || callContextMap.isEmpty()) {
            return;
        }
        this.addToCurrentCallContextMap(message, callContextMap);
    }
}

