/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.ListExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.CatchAllMultiParameterFunction;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.utils.MathUtils;
import java.util.List;

class Extract
extends CatchAllMultiParameterFunction {
    Extract() {
    }

    @Override
    protected Expression evaluate(List<Expression> splitParameters, ProblemsHandler problemsHandler, FunctionExpression functionCall, HiddenTokenAwareTree token) {
        Expression firstParameter = splitParameters.get(0);
        NumberExpression index = (NumberExpression)splitParameters.get(1);
        if (this.isList(firstParameter)) {
            List<Expression> values = this.collect((ListExpression)firstParameter);
            return values.get(index.getValueAsDouble().intValue() - 1);
        }
        if (MathUtils.equals(index.getValueAsDouble(), 1.0)) {
            return firstParameter;
        }
        return functionCall;
    }

    private boolean isList(Expression value) {
        return value.getType() == ASTCssNodeType.LIST_EXPRESSION;
    }

    private List<Expression> collect(ListExpression values) {
        return values.getExpressions();
    }

    @Override
    protected int getMinParameters() {
        return 2;
    }

    @Override
    protected int getMaxParameters() {
        return 2;
    }

    @Override
    protected boolean validateParameter(Expression parameter, int position, ProblemsHandler problemsHandler) {
        switch (position) {
            case 0: {
                return true;
            }
            case 1: {
                return this.validateParameterTypeReportError(parameter, problemsHandler, ASTCssNodeType.NUMBER);
            }
        }
        return false;
    }

    @Override
    protected String getName() {
        return "extract";
    }
}

