﻿using Lucene.Net.Search;
using System.Collections.Generic;

namespace Lucene.Net.QueryParsers.Surround.Query
{
    /*
     * Licensed to the Apache Software Foundation (ASF) under one or more
     * contributor license agreements.  See the NOTICE file distributed with
     * this work for additional information regarding copyright ownership.
     * The ASF licenses this file to You under the Apache License, Version 2.0
     * (the "License"); you may not use this file except in compliance with
     * the License.  You may obtain a copy of the License at
     *
     *     http://www.apache.org/licenses/LICENSE-2.0
     *
     * Unless required by applicable law or agreed to in writing, software
     * distributed under the License is distributed on an "AS IS" BASIS,
     * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
     * See the License for the specific language governing permissions and
     * limitations under the License.
     */

    /// <summary>
    /// Factory for disjunctions
    /// </summary>
    public class OrQuery : ComposedQuery, IDistanceSubQuery
    {
        public OrQuery(IList<SrndQuery> queries, bool infix, string opName)
            : base(queries, infix, opName)
        {
        }

        public override Search.Query MakeLuceneQueryFieldNoBoost(string fieldName, BasicQueryFactory qf)
        {
            return SrndBooleanQuery.MakeBooleanQuery(
                /* subqueries can be individually boosted */
                MakeLuceneSubQueriesField(fieldName, qf), Occur.SHOULD);
        }

        public virtual string DistanceSubQueryNotAllowed()
        {
            var sqi = GetSubQueriesEnumerator();
            while (sqi.MoveNext())
            {
                SrndQuery leq = sqi.Current;
                if (leq is IDistanceSubQuery)
                {
                    string m = ((IDistanceSubQuery)leq).DistanceSubQueryNotAllowed();
                    if (m != null)
                    {
                        return m;
                    }
                }
                else
                {
                    return "subquery not allowed: " + leq.ToString();
                }
            }
            return null;
        }

        public virtual void AddSpanQueries(SpanNearClauseFactory sncf)
        {
            var sqi = GetSubQueriesEnumerator();
            while (sqi.MoveNext())
            {
                ((IDistanceSubQuery)sqi.Current).AddSpanQueries(sncf);
            }
        }
    }
}
