/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.apache.log4j.chainsaw.ApplicationPreferenceModel;
import org.apache.log4j.chainsaw.ChainsawConstants;
import org.apache.log4j.chainsaw.EventContainer;
import org.apache.log4j.chainsaw.LogPanelPreferenceModel;
import org.apache.log4j.chainsaw.LoggingEventWrapper;
import org.apache.log4j.chainsaw.color.RuleColorizer;
import org.apache.log4j.chainsaw.icons.LevelIconFactory;
import org.apache.log4j.rule.Rule;

public class TableColorizingRenderer
extends DefaultTableCellRenderer {
    private static final DateFormat DATE_FORMATTER = new SimpleDateFormat("HH:mm:ss");
    private static final Map iconMap = LevelIconFactory.getInstance().getLevelToIconMap();
    private RuleColorizer colorizer;
    private boolean levelUseIcons = false;
    private boolean wrap = false;
    private boolean highlightSearchMatchText;
    private DateFormat dateFormatInUse = DATE_FORMATTER;
    private int loggerPrecision = 0;
    private boolean toolTipsVisible;
    private String dateFormatTZ;
    private boolean useRelativeTimesToFixedTime = false;
    private long relativeTimestampBase;
    private static int borderWidth = 2;
    private final Color borderColor;
    private final JTextPane levelTextPane = new JTextPane();
    private JTextPane singleLineTextPane = new JTextPane();
    private final JPanel multiLinePanel = new JPanel(new BorderLayout());
    private final JPanel generalPanel = new JPanel(new BorderLayout());
    private final JPanel levelPanel = new JPanel(new BorderLayout());
    private ApplicationPreferenceModel applicationPreferenceModel;
    private JTextPane multiLineTextPane;
    private MutableAttributeSet boldAttributeSet;
    private TabSet tabs;
    private int maxHeight;
    private boolean useRelativeTimesToPrevious;
    private EventContainer eventContainer;
    private LogPanelPreferenceModel logPanelPreferenceModel;
    private SimpleAttributeSet insetAttributeSet;
    private boolean colorizeSearch;

    public TableColorizingRenderer(RuleColorizer colorizer, ApplicationPreferenceModel applicationPreferenceModel, EventContainer eventContainer, LogPanelPreferenceModel logPanelPreferenceModel, boolean colorizeSearch) {
        this.applicationPreferenceModel = applicationPreferenceModel;
        this.logPanelPreferenceModel = logPanelPreferenceModel;
        this.eventContainer = eventContainer;
        this.colorizeSearch = colorizeSearch;
        this.multiLinePanel.setLayout(new BoxLayout(this.multiLinePanel, 1));
        this.generalPanel.setLayout(new BoxLayout(this.generalPanel, 1));
        this.levelPanel.setLayout(new BoxLayout(this.levelPanel, 1));
        this.maxHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        this.borderColor = UIManager.get("Table.selectionBackground") != null ? (Color)UIManager.get("Table.selectionBackground") : Color.BLUE;
        this.boldAttributeSet = new SimpleAttributeSet();
        StyleConstants.setBold(this.boldAttributeSet, true);
        this.insetAttributeSet = new SimpleAttributeSet();
        StyleConstants.setLeftIndent(this.insetAttributeSet, 6.0f);
        boolean pos = false;
        int align = 0;
        int leader = 0;
        TabStop tabStop = new TabStop((float)pos, align, leader);
        this.tabs = new TabSet(new TabStop[]{tabStop});
        this.levelTextPane.setOpaque(true);
        this.levelTextPane.setText("");
        this.levelPanel.add(this.levelTextPane);
        this.colorizer = colorizer;
        this.multiLineTextPane = new JTextPane();
        this.multiLineTextPane.setEditorKit(new StyledEditorKit());
        this.singleLineTextPane.setEditorKit(new OneLineEditorKit());
        this.levelTextPane.setEditorKit(new OneLineEditorKit());
        this.multiLineTextPane.setEditable(false);
        this.multiLineTextPane.setFont(this.levelTextPane.getFont());
        this.multiLineTextPane.setParagraphAttributes(this.insetAttributeSet, false);
        this.singleLineTextPane.setParagraphAttributes(this.insetAttributeSet, false);
        this.levelTextPane.setParagraphAttributes(this.insetAttributeSet, false);
    }

    public void setToolTipsVisible(boolean toolTipsVisible) {
        this.toolTipsVisible = toolTipsVisible;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Color foreground;
        Color background;
        JPanel component;
        EventContainer container = (EventContainer)table.getModel();
        LoggingEventWrapper loggingEventWrapper = container.getRow(row);
        value = this.formatField(value, loggingEventWrapper);
        TableColumn tableColumn = table.getColumnModel().getColumn(col);
        int width = tableColumn.getWidth();
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        int colIndex = tableColumn.getModelIndex() + 1;
        if (loggingEventWrapper == null) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        }
        long delta = 0L;
        if (row > 0) {
            LoggingEventWrapper previous = this.eventContainer.getRow(row - 1);
            delta = Math.min(50L, Math.max(0L, (long)((float)(loggingEventWrapper.getLoggingEvent().getTimeStamp() - previous.getLoggingEvent().getTimeStamp()) * 0.002f)));
        }
        Map matches = loggingEventWrapper.getSearchMatches();
        switch (colIndex) {
            case 8: {
                if (value instanceof String[] && ((String[])value).length > 0) {
                    Style tabStyle = this.singleLineTextPane.getLogicalStyle();
                    StyleConstants.setTabSet(tabStyle, this.tabs);
                    this.singleLineTextPane.setLogicalStyle(tabStyle);
                    Set exceptionMatches = (Set)matches.get("EXCEPTION");
                    if (exceptionMatches != null && exceptionMatches.size() > 0) {
                        this.singleLineTextPane.setText(((String[])value)[0]);
                        this.boldAll((StyledDocument)this.singleLineTextPane.getDocument());
                    } else {
                        this.singleLineTextPane.setText(((String[])value)[0]);
                    }
                } else {
                    this.singleLineTextPane.setText("");
                }
                this.layoutRenderingPanel(this.generalPanel, this.singleLineTextPane, delta, isSelected, width, col, table);
                component = this.generalPanel;
                break;
            }
            case 1: {
                String logger = value.toString();
                int startPos = -1;
                for (int i = 0; i < this.loggerPrecision && (startPos = logger.indexOf(".", startPos + 1)) >= 0; ++i) {
                }
                this.singleLineTextPane.setText(logger.substring(startPos + 1));
                this.setHighlightAttributesInternal(matches.get("LOGGER"), (StyledDocument)this.singleLineTextPane.getDocument());
                this.layoutRenderingPanel(this.generalPanel, this.singleLineTextPane, delta, isSelected, width, col, table);
                component = this.generalPanel;
                break;
            }
            case 14: {
                this.singleLineTextPane.setText(value.toString());
                this.setHighlightAttributesInternal(matches.get("PROP.LOG4JID"), (StyledDocument)this.singleLineTextPane.getDocument());
                this.layoutRenderingPanel(this.generalPanel, this.singleLineTextPane, delta, isSelected, width, col, table);
                component = this.generalPanel;
                break;
            }
            case 9: {
                this.singleLineTextPane.setText(value.toString());
                this.setHighlightAttributesInternal(matches.get("CLASS"), (StyledDocument)this.singleLineTextPane.getDocument());
                this.layoutRenderingPanel(this.generalPanel, this.singleLineTextPane, delta, isSelected, width, col, table);
                component = this.generalPanel;
                break;
            }
            case 11: {
                this.singleLineTextPane.setText(value.toString());
                this.setHighlightAttributesInternal(matches.get("FILE"), (StyledDocument)this.singleLineTextPane.getDocument());
                this.layoutRenderingPanel(this.generalPanel, this.singleLineTextPane, delta, isSelected, width, col, table);
                component = this.generalPanel;
                break;
            }
            case 12: {
                this.singleLineTextPane.setText(value.toString());
                this.setHighlightAttributesInternal(matches.get("LINE"), (StyledDocument)this.singleLineTextPane.getDocument());
                this.layoutRenderingPanel(this.generalPanel, this.singleLineTextPane, delta, isSelected, width, col, table);
                component = this.generalPanel;
                break;
            }
            case 7: {
                this.singleLineTextPane.setText(value.toString());
                this.setHighlightAttributesInternal(matches.get("NDC"), (StyledDocument)this.singleLineTextPane.getDocument());
                this.layoutRenderingPanel(this.generalPanel, this.singleLineTextPane, delta, isSelected, width, col, table);
                component = this.generalPanel;
                break;
            }
            case 5: {
                this.singleLineTextPane.setText(value.toString());
                this.setHighlightAttributesInternal(matches.get("THREAD"), (StyledDocument)this.singleLineTextPane.getDocument());
                this.layoutRenderingPanel(this.generalPanel, this.singleLineTextPane, delta, isSelected, width, col, table);
                component = this.generalPanel;
                break;
            }
            case 3: {
                Set timestampMatches = (Set)matches.get("TIMESTAMP");
                if (timestampMatches != null && timestampMatches.size() > 0) {
                    this.singleLineTextPane.setText(value.toString());
                    this.boldAll((StyledDocument)this.singleLineTextPane.getDocument());
                } else {
                    this.singleLineTextPane.setText(value.toString());
                }
                this.layoutRenderingPanel(this.generalPanel, this.singleLineTextPane, delta, isSelected, width, col, table);
                component = this.generalPanel;
                break;
            }
            case 10: {
                this.singleLineTextPane.setText(value.toString());
                this.setHighlightAttributesInternal(matches.get("METHOD"), (StyledDocument)this.singleLineTextPane.getDocument());
                this.layoutRenderingPanel(this.generalPanel, this.singleLineTextPane, delta, isSelected, width, col, table);
                component = this.generalPanel;
                break;
            }
            case 2: 
            case 6: {
                String thisString = value.toString().trim();
                JTextPane textPane = this.wrap ? this.multiLineTextPane : this.singleLineTextPane;
                JPanel textPaneContainer = this.wrap ? this.multiLinePanel : this.generalPanel;
                textPane.setText(thisString);
                if (colIndex == 2) {
                    this.setHighlightAttributesInternal(matches.get("PROP." + "marker".toUpperCase()), (StyledDocument)textPane.getDocument());
                } else {
                    this.setHighlightAttributesInternal(matches.get("MSG"), (StyledDocument)textPane.getDocument());
                }
                textPaneContainer.removeAll();
                if (delta > 0L && this.logPanelPreferenceModel.isShowMillisDeltaAsGap()) {
                    JPanel newPanel = new JPanel();
                    newPanel.setOpaque(true);
                    newPanel.setBackground(this.applicationPreferenceModel.getDeltaColor());
                    newPanel.setPreferredSize(new Dimension(width, (int)delta));
                    textPaneContainer.add((Component)newPanel, "North");
                }
                textPaneContainer.add((Component)textPane, "South");
                if (delta == 0L || !this.logPanelPreferenceModel.isShowMillisDeltaAsGap()) {
                    if (col == 0) {
                        textPane.setBorder(this.getLeftBorder(isSelected, delta));
                    } else if (col == table.getColumnCount() - 1) {
                        textPane.setBorder(this.getRightBorder(isSelected, delta));
                    } else {
                        textPane.setBorder(this.getMiddleBorder(isSelected, delta));
                    }
                } else if (col == 0) {
                    textPane.setBorder(this.getLeftBorder(isSelected, 0L));
                } else if (col == table.getColumnCount() - 1) {
                    textPane.setBorder(this.getRightBorder(isSelected, 0L));
                } else {
                    textPane.setBorder(this.getMiddleBorder(isSelected, 0L));
                }
                int currentMarkerHeight = loggingEventWrapper.getMarkerHeight();
                int currentMsgHeight = loggingEventWrapper.getMsgHeight();
                int newRowHeight = 20;
                boolean setHeight = false;
                if (this.wrap) {
                    textPane.setSize(new Dimension(width, this.maxHeight));
                    int multiLinePanelPrefHeight = textPaneContainer.getPreferredSize().height;
                    newRowHeight = Math.max(20, multiLinePanelPrefHeight);
                }
                if (!this.wrap && this.logPanelPreferenceModel.isShowMillisDeltaAsGap()) {
                    textPane.setSize(new Dimension(Integer.MAX_VALUE, 20));
                    newRowHeight = (int)(20L + delta);
                }
                if (colIndex == 2) {
                    loggingEventWrapper.setMarkerHeight(newRowHeight);
                    if (newRowHeight != currentMarkerHeight && newRowHeight >= loggingEventWrapper.getMsgHeight()) {
                        setHeight = true;
                    }
                }
                if (colIndex == 6) {
                    loggingEventWrapper.setMsgHeight(newRowHeight);
                    if (newRowHeight != currentMsgHeight && newRowHeight >= loggingEventWrapper.getMarkerHeight()) {
                        setHeight = true;
                    }
                }
                if (setHeight) {
                    table.setRowHeight(row, newRowHeight);
                }
                component = textPaneContainer;
                break;
            }
            case 4: {
                if (this.levelUseIcons) {
                    this.levelTextPane.setText("");
                    this.levelTextPane.insertIcon((Icon)iconMap.get(value.toString()));
                    if (!this.toolTipsVisible) {
                        this.levelTextPane.setToolTipText(value.toString());
                    }
                } else {
                    this.levelTextPane.setText(value.toString());
                    this.setHighlightAttributesInternal(matches.get("LEVEL"), (StyledDocument)this.levelTextPane.getDocument());
                    if (!this.toolTipsVisible) {
                        this.levelTextPane.setToolTipText(null);
                    }
                }
                if (this.toolTipsVisible) {
                    this.levelTextPane.setToolTipText(label.getToolTipText());
                }
                this.levelTextPane.setForeground(label.getForeground());
                this.levelTextPane.setBackground(label.getBackground());
                this.layoutRenderingPanel(this.levelPanel, this.levelTextPane, delta, isSelected, width, col, table);
                component = this.levelPanel;
                break;
            }
            default: {
                Set propertySet = loggingEventWrapper.getPropertyKeySet();
                String headerName = tableColumn.getHeaderValue().toString().toLowerCase();
                String thisProp = null;
                Iterator iter = propertySet.iterator();
                while (iter.hasNext()) {
                    String entry = iter.next().toString();
                    if (!entry.equalsIgnoreCase(headerName)) continue;
                    thisProp = entry;
                    break;
                }
                if (thisProp != null) {
                    String propKey = "PROP." + thisProp.toUpperCase();
                    Set propKeyMatches = (Set)matches.get(propKey);
                    this.singleLineTextPane.setText(loggingEventWrapper.getLoggingEvent().getProperty(thisProp));
                    this.setHighlightAttributesInternal(propKeyMatches, (StyledDocument)this.singleLineTextPane.getDocument());
                } else {
                    this.singleLineTextPane.setText("");
                }
                this.layoutRenderingPanel(this.generalPanel, this.singleLineTextPane, delta, isSelected, width, col, table);
                component = this.generalPanel;
            }
        }
        Rule loggerRule = this.colorizer.getLoggerRule();
        if (loggerRule != null && loggerRule.evaluate(loggingEventWrapper.getLoggingEvent(), null)) {
            background = this.applicationPreferenceModel.getSearchBackgroundColor();
            foreground = this.applicationPreferenceModel.getSearchForegroundColor();
        } else if (this.colorizeSearch && !this.applicationPreferenceModel.isBypassSearchColors()) {
            background = loggingEventWrapper.isSearchMatch() ? this.applicationPreferenceModel.getSearchBackgroundColor() : loggingEventWrapper.getBackground();
            foreground = loggingEventWrapper.isSearchMatch() ? this.applicationPreferenceModel.getSearchForegroundColor() : loggingEventWrapper.getForeground();
        } else {
            background = loggingEventWrapper.getBackground();
            foreground = loggingEventWrapper.getForeground();
        }
        if (background.equals(ChainsawConstants.COLOR_DEFAULT_BACKGROUND) && foreground.equals(ChainsawConstants.COLOR_DEFAULT_FOREGROUND) && row % 2 != 0) {
            background = this.applicationPreferenceModel.getAlternatingColorBackgroundColor();
            foreground = this.applicationPreferenceModel.getAlternatingColorForegroundColor();
        }
        component.setBackground(background);
        component.setForeground(foreground);
        if (this.multiLineTextPane != null) {
            this.updateColors(this.multiLineTextPane, background, foreground);
        }
        this.updateColors(this.levelTextPane, background, foreground);
        this.updateColors(this.singleLineTextPane, background, foreground);
        return component;
    }

    private void layoutRenderingPanel(JComponent container, JComponent bottomComponent, long delta, boolean isSelected, int width, int col, JTable table) {
        container.removeAll();
        if (delta == 0L || !this.logPanelPreferenceModel.isShowMillisDeltaAsGap()) {
            if (col == 0) {
                bottomComponent.setBorder(this.getLeftBorder(isSelected, delta));
            } else if (col == table.getColumnCount() - 1) {
                bottomComponent.setBorder(this.getRightBorder(isSelected, delta));
            } else {
                bottomComponent.setBorder(this.getMiddleBorder(isSelected, delta));
            }
        } else {
            JPanel newPanel = new JPanel();
            newPanel.setOpaque(true);
            newPanel.setBackground(this.applicationPreferenceModel.getDeltaColor());
            newPanel.setPreferredSize(new Dimension(width, (int)delta));
            container.add((Component)newPanel, "North");
            if (col == 0) {
                bottomComponent.setBorder(this.getLeftBorder(isSelected, 0L));
            } else if (col == table.getColumnCount() - 1) {
                bottomComponent.setBorder(this.getRightBorder(isSelected, 0L));
            } else {
                bottomComponent.setBorder(this.getMiddleBorder(isSelected, 0L));
            }
        }
        container.add((Component)bottomComponent, "South");
    }

    private Border getLeftBorder(boolean isSelected, long delta) {
        Border innerBorder;
        MatteBorder LEFT_BORDER = BorderFactory.createMatteBorder(borderWidth, borderWidth, borderWidth, 0, this.borderColor);
        Border LEFT_EMPTY_BORDER = BorderFactory.createEmptyBorder(borderWidth, borderWidth, borderWidth, 0);
        Border border = innerBorder = isSelected ? LEFT_BORDER : LEFT_EMPTY_BORDER;
        if (delta == 0L || !this.wrap || !this.logPanelPreferenceModel.isShowMillisDeltaAsGap()) {
            return innerBorder;
        }
        MatteBorder outerBorder = BorderFactory.createMatteBorder((int)Math.max((long)borderWidth, delta), 0, 0, 0, this.applicationPreferenceModel.getDeltaColor());
        return BorderFactory.createCompoundBorder(outerBorder, innerBorder);
    }

    private Border getRightBorder(boolean isSelected, long delta) {
        Border innerBorder;
        MatteBorder RIGHT_BORDER = BorderFactory.createMatteBorder(borderWidth, 0, borderWidth, borderWidth, this.borderColor);
        Border RIGHT_EMPTY_BORDER = BorderFactory.createEmptyBorder(borderWidth, 0, borderWidth, borderWidth);
        Border border = innerBorder = isSelected ? RIGHT_BORDER : RIGHT_EMPTY_BORDER;
        if (delta == 0L || !this.wrap || !this.logPanelPreferenceModel.isShowMillisDeltaAsGap()) {
            return innerBorder;
        }
        MatteBorder outerBorder = BorderFactory.createMatteBorder((int)Math.max((long)borderWidth, delta), 0, 0, 0, this.applicationPreferenceModel.getDeltaColor());
        return BorderFactory.createCompoundBorder(outerBorder, innerBorder);
    }

    private Border getMiddleBorder(boolean isSelected, long delta) {
        Border innerBorder;
        MatteBorder MIDDLE_BORDER = BorderFactory.createMatteBorder(borderWidth, 0, borderWidth, 0, this.borderColor);
        Border MIDDLE_EMPTY_BORDER = BorderFactory.createEmptyBorder(borderWidth, 0, borderWidth, 0);
        Border border = innerBorder = isSelected ? MIDDLE_BORDER : MIDDLE_EMPTY_BORDER;
        if (delta == 0L || !this.wrap || !this.logPanelPreferenceModel.isShowMillisDeltaAsGap()) {
            return innerBorder;
        }
        MatteBorder outerBorder = BorderFactory.createMatteBorder((int)Math.max((long)borderWidth, delta), 0, 0, 0, this.applicationPreferenceModel.getDeltaColor());
        return BorderFactory.createCompoundBorder(outerBorder, innerBorder);
    }

    private void updateColors(JTextPane textPane, Color background, Color foreground) {
        StyledDocument styledDocument = textPane.getStyledDocument();
        MutableAttributeSet attributes = textPane.getInputAttributes();
        StyleConstants.setForeground(attributes, foreground);
        styledDocument.setCharacterAttributes(0, styledDocument.getLength() + 1, attributes, false);
        textPane.setBackground(background);
    }

    void setDateFormatter(DateFormat formatter) {
        this.dateFormatInUse = formatter;
        if (this.dateFormatInUse != null && this.dateFormatTZ != null && !"".equals(this.dateFormatTZ)) {
            this.dateFormatInUse.setTimeZone(TimeZone.getTimeZone(this.dateFormatTZ));
        } else {
            this.dateFormatInUse.setTimeZone(TimeZone.getDefault());
        }
    }

    void setLoggerPrecision(String loggerPrecisionText) {
        try {
            this.loggerPrecision = Integer.parseInt(loggerPrecisionText);
        }
        catch (NumberFormatException nfe) {
            this.loggerPrecision = 0;
        }
    }

    private Object formatField(Object field, LoggingEventWrapper loggingEventWrapper) {
        if (!(field instanceof Date)) {
            return field == null ? "" : field;
        }
        if (this.useRelativeTimesToFixedTime) {
            return "" + (((Date)field).getTime() - this.relativeTimestampBase);
        }
        if (this.useRelativeTimesToPrevious) {
            return loggingEventWrapper.getLoggingEvent().getProperty("millisdelta");
        }
        return this.dateFormatInUse.format((Date)field);
    }

    public void setWrapMessage(boolean wrapMsg) {
        this.wrap = wrapMsg;
    }

    public void setLevelUseIcons(boolean levelUseIcons) {
        this.levelUseIcons = levelUseIcons;
    }

    public void setTimeZone(String dateFormatTZ) {
        this.dateFormatTZ = dateFormatTZ;
        if (this.dateFormatInUse != null && dateFormatTZ != null && !"".equals(dateFormatTZ)) {
            this.dateFormatInUse.setTimeZone(TimeZone.getTimeZone(dateFormatTZ));
        } else {
            this.dateFormatInUse.setTimeZone(TimeZone.getDefault());
        }
    }

    public void setUseRelativeTimes(long timeStamp) {
        this.useRelativeTimesToFixedTime = true;
        this.useRelativeTimesToPrevious = false;
        this.relativeTimestampBase = timeStamp;
    }

    public void setUseRelativeTimesToPreviousRow() {
        this.useRelativeTimesToFixedTime = false;
        this.useRelativeTimesToPrevious = true;
    }

    public void setUseNormalTimes() {
        this.useRelativeTimesToFixedTime = false;
        this.useRelativeTimesToPrevious = false;
    }

    private void setHighlightAttributesInternal(Object matchSet, StyledDocument styledDocument) {
        if (!this.highlightSearchMatchText) {
            return;
        }
        this.setHighlightAttributes(matchSet, styledDocument);
    }

    public void setHighlightAttributes(Object matchSet, StyledDocument styledDocument) {
        if (matchSet instanceof Set) {
            Set thisSet = (Set)matchSet;
            Iterator iter = thisSet.iterator();
            while (iter.hasNext()) {
                String thisEntry = iter.next().toString();
                this.bold(thisEntry, styledDocument);
            }
        }
    }

    private void boldAll(StyledDocument styledDocument) {
        if (!this.highlightSearchMatchText) {
            return;
        }
        styledDocument.setCharacterAttributes(0, styledDocument.getLength(), this.boldAttributeSet, false);
    }

    private void bold(String textToBold, StyledDocument styledDocument) {
        try {
            int currentIndex;
            String lowerInput = styledDocument.getText(0, styledDocument.getLength()).toLowerCase();
            String lowerTextToBold = textToBold.toLowerCase();
            int textToBoldLength = textToBold.length();
            int firstIndex = 0;
            while ((currentIndex = lowerInput.indexOf(lowerTextToBold, firstIndex)) > -1) {
                styledDocument.setCharacterAttributes(currentIndex, textToBoldLength, this.boldAttributeSet, false);
                firstIndex = currentIndex + textToBoldLength;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setHighlightSearchMatchText(boolean highlightSearchMatchText) {
        this.highlightSearchMatchText = highlightSearchMatchText;
    }

    private class OneLineParagraphView
    extends ParagraphView {
        public OneLineParagraphView(Element elem) {
            super(elem);
        }

        @Override
        public int getFlowSpan(int index) {
            return Integer.MAX_VALUE;
        }
    }

    private class ViewFactoryImpl
    implements ViewFactory {
        private ViewFactoryImpl() {
        }

        @Override
        public View create(Element elem) {
            String elementName = elem.getName();
            if (elementName != null) {
                if (elementName.equals("paragraph")) {
                    return new OneLineParagraphView(elem);
                }
                if (elementName.equals("content")) {
                    return new LabelView(elem);
                }
                if (elementName.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (elementName.equals("component")) {
                    return new ComponentView(elem);
                }
                if (elementName.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }

    private class OneLineEditorKit
    extends StyledEditorKit {
        private ViewFactory viewFactoryImpl;

        private OneLineEditorKit() {
            this.viewFactoryImpl = new ViewFactoryImpl();
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.viewFactoryImpl;
        }
    }
}

