/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics.extended;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.ValueStatistic;
import org.terracotta.statistics.archive.Timestamped;
import org.terracotta.statistics.derived.EventRateSimpleMovingAverage;
import org.terracotta.statistics.derived.OperationResultFilter;
import org.terracotta.statistics.extended.ExpiringSampledStatistic;
import org.terracotta.statistics.extended.SampledStatistic;
import org.terracotta.statistics.extended.StatisticType;
import org.terracotta.statistics.observer.ChainedOperationObserver;

public class RateImpl<T extends Enum<T>>
implements SampledStatistic<Double> {
    private final ExpiringSampledStatistic<Double> delegate;
    private final EventRateSimpleMovingAverage rate;

    public RateImpl(final OperationStatistic<T> source, final Set<T> targets, long averagePeriod, TimeUnit averageTimeUnit, ScheduledExecutorService executor, int historySize, long historyPeriod, TimeUnit historyTimeUnit) {
        this.rate = new EventRateSimpleMovingAverage(averagePeriod, averageTimeUnit);
        this.delegate = new ExpiringSampledStatistic<Double>((ValueStatistic)this.rate, executor, historySize, historyPeriod, historyTimeUnit, StatisticType.RATE){
            private final ChainedOperationObserver<T> observer;
            {
                super(x0, x1, x2, x3, x4, x5);
                this.observer = new OperationResultFilter(targets, RateImpl.this.rate);
            }

            @Override
            protected void stopStatistic() {
                super.stopStatistic();
                source.removeDerivedStatistic(this.observer);
            }

            @Override
            protected void startStatistic() {
                super.startStatistic();
                source.addDerivedStatistic(this.observer);
            }
        };
    }

    @Override
    public boolean active() {
        return this.delegate.active();
    }

    @Override
    public Double value() {
        return this.delegate.value();
    }

    @Override
    public List<Timestamped<Double>> history() {
        return this.delegate.history();
    }

    @Override
    public List<Timestamped<Double>> history(long since) {
        return this.delegate.history(since);
    }

    @Override
    public StatisticType type() {
        return StatisticType.RATE;
    }

    protected void start() {
        this.delegate.start();
    }

    protected void setWindow(long averagePeriod, TimeUnit averageTimeUnit) {
        this.rate.setWindow(averagePeriod, averageTimeUnit);
    }

    protected void setHistory(int historySize, long historyPeriod, TimeUnit historyTimeUnit) {
        this.delegate.setHistory(historySize, historyPeriod, historyTimeUnit);
    }

    protected boolean expire(long expiry) {
        return this.delegate.expire(expiry);
    }
}

