/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.client;

import com.nimbusds.oauth2.sdk.token.RefreshToken;
import java.util.Optional;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.pac4j.oidc.credentials.authenticator.OidcAuthenticator;
import org.pac4j.oidc.credentials.extractor.OidcExtractor;
import org.pac4j.oidc.logout.OidcLogoutActionBuilder;
import org.pac4j.oidc.profile.OidcProfile;
import org.pac4j.oidc.profile.creator.OidcProfileCreator;
import org.pac4j.oidc.redirect.OidcRedirectionActionBuilder;

public class OidcClient<V extends OidcConfiguration>
extends IndirectClient<OidcCredentials> {
    private V configuration = null;

    public OidcClient() {
    }

    public OidcClient(V configuration) {
        this.setConfiguration(configuration);
    }

    public V getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(V configuration) {
        this.configuration = configuration;
    }

    protected void clientInit() {
        CommonHelper.assertNotNull((String)"configuration", this.configuration);
        this.configuration.init();
        this.defaultRedirectionActionBuilder(new OidcRedirectionActionBuilder((OidcConfiguration)((Object)this.configuration), this));
        this.defaultCredentialsExtractor(new OidcExtractor((OidcConfiguration)((Object)this.configuration), this));
        this.defaultAuthenticator(new OidcAuthenticator((OidcConfiguration)((Object)this.configuration), this));
        this.defaultProfileCreator(new OidcProfileCreator((OidcConfiguration)((Object)this.configuration), this));
        this.defaultLogoutActionBuilder(new OidcLogoutActionBuilder((OidcConfiguration)((Object)this.configuration)));
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "callbackUrl", this.callbackUrl, "callbackUrlResolver", this.callbackUrlResolver, "ajaxRequestResolver", this.getAjaxRequestResolver(), "redirectionActionBuilder", this.getRedirectionActionBuilder(), "credentialsExtractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator(), "logoutActionBuilder", this.getLogoutActionBuilder(), "authorizationGenerators", this.getAuthorizationGenerators(), "configuration", this.configuration});
    }

    public Optional<UserProfile> renewUserProfile(UserProfile profile, WebContext context) {
        OidcProfile oidcProfile = (OidcProfile)profile;
        RefreshToken refreshToken = oidcProfile.getRefreshToken();
        if (refreshToken != null) {
            OidcCredentials credentials = new OidcCredentials();
            credentials.setRefreshToken(refreshToken);
            OidcAuthenticator authenticator = new OidcAuthenticator((OidcConfiguration)((Object)this.getConfiguration()), this);
            authenticator.refresh(credentials);
            if (credentials.getAccessToken() != null) {
                return this.getUserProfile(credentials, context);
            }
        }
        return Optional.empty();
    }

    public void notifySessionRenewal(String oldSessionId, WebContext context) {
        ((OidcConfiguration)((Object)this.configuration)).findLogoutHandler().renewSession(oldSessionId, context);
    }
}

