/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="This API class represents a request to retrieve Auto-TLS certificates for a given host. The request contains the host requesting the certificate, a valid token generated by the certmanager utility, and optionally a certificate signing request.  Currently, the certificate signing request argument is not supported.")
public class ApiCertificateRequest {
    @SerializedName(value="hostname")
    private String hostname = null;
    @SerializedName(value="csr")
    private String csr = null;
    @SerializedName(value="token")
    private String token = null;
    @SerializedName(value="subjectAltNames")
    private List<String> subjectAltNames = null;

    public ApiCertificateRequest hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Schema(description="Get the hostname of the host requesting certificates")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public ApiCertificateRequest csr(String csr) {
        this.csr = csr;
        return this;
    }

    @Schema(description="Get the certificate signing request in PEM format")
    public String getCsr() {
        return this.csr;
    }

    public void setCsr(String csr) {
        this.csr = csr;
    }

    public ApiCertificateRequest token(String token) {
        this.token = token;
        return this;
    }

    @Schema(description="Get the certificate request token")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public ApiCertificateRequest subjectAltNames(List<String> subjectAltNames) {
        this.subjectAltNames = subjectAltNames;
        return this;
    }

    public ApiCertificateRequest addSubjectAltNamesItem(String subjectAltNamesItem) {
        if (this.subjectAltNames == null) {
            this.subjectAltNames = new ArrayList<String>();
        }
        this.subjectAltNames.add(subjectAltNamesItem);
        return this;
    }

    @Schema(description="")
    public List<String> getSubjectAltNames() {
        return this.subjectAltNames;
    }

    public void setSubjectAltNames(List<String> subjectAltNames) {
        this.subjectAltNames = subjectAltNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiCertificateRequest apiCertificateRequest = (ApiCertificateRequest)o;
        return Objects.equals(this.hostname, apiCertificateRequest.hostname) && Objects.equals(this.csr, apiCertificateRequest.csr) && Objects.equals(this.token, apiCertificateRequest.token) && Objects.equals(this.subjectAltNames, apiCertificateRequest.subjectAltNames);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.csr, this.token, this.subjectAltNames);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiCertificateRequest {\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    csr: ").append(this.toIndentedString(this.csr)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    subjectAltNames: ").append(this.toIndentedString(this.subjectAltNames)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

