/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.pool;

import java.util.NoSuchElementException;
import org.ldaptive.Connection;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.pool.BlockingConnectionPool;
import org.ldaptive.pool.PoolConfig;
import org.ldaptive.pool.PoolException;
import org.ldaptive.pool.PoolExhaustedException;
import org.ldaptive.pool.PooledConnectionProxy;

public class SoftLimitConnectionPool
extends BlockingConnectionPool {
    public SoftLimitConnectionPool() {
    }

    public SoftLimitConnectionPool(DefaultConnectionFactory cf) {
        super(new PoolConfig(), cf);
    }

    public SoftLimitConnectionPool(PoolConfig pc, DefaultConnectionFactory cf) {
        super(pc, cf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws PoolException {
        PooledConnectionProxy pc;
        block10: {
            this.isInitialized();
            pc = null;
            this.logger.trace("waiting on pool lock for check out {}", (Object)this.poolLock.getQueueLength());
            this.poolLock.lock();
            try {
                if (this.available.isEmpty()) break block10;
                try {
                    this.logger.trace("retrieve available connection");
                    pc = this.retrieveAvailableConnection();
                }
                catch (NoSuchElementException e) {
                    this.logger.error("could not remove connection from list", (Throwable)e);
                    throw new IllegalStateException("Pool is empty", e);
                }
            }
            finally {
                this.poolLock.unlock();
            }
        }
        if (pc == null) {
            pc = this.createActiveConnection();
            if (pc == null) {
                if (this.available.isEmpty() && this.active.isEmpty()) {
                    this.logger.error("Could not service check out request");
                    throw new PoolExhaustedException("Pool is empty and connection creation failed");
                }
                this.logger.debug("create failed, block until a connection is available");
                pc = this.blockAvailableConnection();
            } else {
                this.logger.trace("created new active connection: {}", (Object)pc);
            }
        }
        if (pc == null) {
            this.logger.error("Could not service check out request");
            throw new PoolExhaustedException("Pool is empty and connection creation failed");
        }
        this.activateAndValidateConnection(pc);
        return this.createConnectionProxy(pc);
    }
}

