/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.token.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.token.UnknownTokenException;
import org.apache.knox.gateway.services.token.impl.DefaultTokenStateService;
import org.apache.knox.gateway.services.token.impl.state.TokenStateJournalFactory;
import org.apache.knox.gateway.services.token.state.JournalEntry;
import org.apache.knox.gateway.services.token.state.TokenStateJournal;

public class JournalBasedTokenStateService
extends DefaultTokenStateService {
    private TokenStateJournal journal;

    @Override
    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        super.init(config, options);
        try {
            this.journal = TokenStateJournalFactory.create(config);
            List<JournalEntry> entries = this.journal.get();
            for (JournalEntry entry : entries) {
                String id = entry.getTokenId();
                try {
                    long issueTime = Long.parseLong(entry.getIssueTime());
                    long expiration = Long.parseLong(entry.getExpiration());
                    long maxLifetime = Long.parseLong(entry.getMaxLifetime());
                    super.addToken(id, issueTime, expiration, maxLifetime);
                }
                catch (Exception e) {
                    log.failedToLoadJournalEntry(id, e);
                }
            }
        }
        catch (IOException e) {
            throw new ServiceLifecycleException("Failed to load persisted state from the token state journal", (Exception)e);
        }
    }

    @Override
    public void addToken(String tokenId, long issueTime, long expiration, long maxLifetimeDuration) {
        super.addToken(tokenId, issueTime, expiration, maxLifetimeDuration);
        try {
            this.journal.add(tokenId, issueTime, expiration, maxLifetimeDuration);
        }
        catch (IOException e) {
            log.failedToAddJournalEntry(tokenId, e);
        }
    }

    @Override
    public long getTokenExpiration(String tokenId, boolean validate) throws UnknownTokenException {
        try {
            return super.getTokenExpiration(tokenId, validate);
        }
        catch (UnknownTokenException unknownTokenException) {
            if (validate) {
                this.validateToken(tokenId);
            }
            long expiration = 0L;
            try {
                JournalEntry entry = this.journal.get(tokenId);
                if (entry == null) {
                    throw new UnknownTokenException(tokenId);
                }
                expiration = Long.parseLong(entry.getExpiration());
                super.addToken(tokenId, Long.parseLong(entry.getIssueTime()), expiration, Long.parseLong(entry.getMaxLifetime()));
            }
            catch (IOException e) {
                log.failedToLoadJournalEntry(e);
            }
            return expiration;
        }
    }

    @Override
    protected long getMaxLifetime(String tokenId) {
        long result = super.getMaxLifetime(tokenId);
        if (result < 1L) {
            try {
                JournalEntry entry = this.journal.get(tokenId);
                if (entry == null) {
                    throw new UnknownTokenException(tokenId);
                }
                result = Long.parseLong(entry.getMaxLifetime());
                super.setMaxLifetime(tokenId, Long.parseLong(entry.getIssueTime()), result);
            }
            catch (Exception e) {
                log.failedToLoadJournalEntry(e);
            }
        }
        return result;
    }

    @Override
    protected void removeTokens(Set<String> tokenIds) throws UnknownTokenException {
        super.removeTokens(tokenIds);
        try {
            this.journal.remove(tokenIds);
        }
        catch (IOException e) {
            log.failedToRemoveJournalEntries(e);
        }
    }

    @Override
    protected void updateExpiration(String tokenId, long expiration) {
        super.updateExpiration(tokenId, expiration);
        try {
            JournalEntry entry = this.journal.get(tokenId);
            if (entry == null) {
                log.journalEntryNotFound(tokenId);
            } else {
                this.journal.add(entry.getTokenId(), Long.parseLong(entry.getIssueTime()), expiration, Long.parseLong(entry.getMaxLifetime()));
            }
        }
        catch (IOException e) {
            log.errorAccessingTokenState(e);
        }
    }

    @Override
    protected boolean isUnknown(String tokenId) {
        JournalEntry entry = null;
        try {
            entry = this.journal.get(tokenId);
        }
        catch (IOException e) {
            log.errorAccessingTokenState(e);
        }
        return entry == null;
    }
}

