/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.jndi;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import javax.naming.ldap.Control;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.ldaptive.ResultCode;
import org.ldaptive.provider.ControlProcessor;
import org.ldaptive.provider.ProviderConfig;
import org.ldaptive.provider.jndi.JndiControlHandler;
import org.ldaptive.ssl.AllowAnyHostnameVerifier;

public class JndiProviderConfig
extends ProviderConfig<Control> {
    protected static final String ALLOW_ANY_HOSTNAME = "jndi.starttls.allowAnyHostname";
    private Map<String, Object> environment;
    private OutputStream tracePackets;
    private boolean removeDnUrls = true;
    private ResultCode[] searchIgnoreResultCodes;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;

    public JndiProviderConfig() {
        this.setOperationExceptionResultCodes(ResultCode.PROTOCOL_ERROR, ResultCode.SERVER_DOWN);
        this.searchIgnoreResultCodes = new ResultCode[]{ResultCode.TIME_LIMIT_EXCEEDED, ResultCode.SIZE_LIMIT_EXCEEDED, ResultCode.PARTIAL_RESULTS};
        this.setControlProcessor(new ControlProcessor<Control>(new JndiControlHandler()));
    }

    public Map<String, Object> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, Object> env) {
        this.checkImmutable();
        this.logger.trace("setting environment: {}", env);
        this.environment = env;
    }

    public OutputStream getTracePackets() {
        return this.tracePackets;
    }

    public void setTracePackets(OutputStream stream) {
        this.checkImmutable();
        this.logger.trace("setting tracePackets: {}", (Object)stream);
        this.tracePackets = stream;
    }

    public boolean getRemoveDnUrls() {
        return this.removeDnUrls;
    }

    public void setRemoveDnUrls(boolean b) {
        this.checkImmutable();
        this.logger.trace("setting removeDnUrls: {}", (Object)b);
        this.removeDnUrls = b;
    }

    public ResultCode[] getSearchIgnoreResultCodes() {
        return this.searchIgnoreResultCodes;
    }

    public void setSearchIgnoreResultCodes(ResultCode ... codes) {
        this.checkImmutable();
        this.logger.trace("setting searchIgnoreResultCodes: {}", (Object)Arrays.toString((Object[])codes));
        this.searchIgnoreResultCodes = codes;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(SSLSocketFactory sf) {
        this.checkImmutable();
        this.logger.trace("setting sslSocketFactory: {}", (Object)sf);
        this.sslSocketFactory = sf;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier verifier) {
        this.checkImmutable();
        this.logger.trace("setting hostnameVerifier: {}", (Object)verifier);
        this.hostnameVerifier = verifier;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        this.checkImmutable();
        boolean allowAnyHostname = Boolean.valueOf((String)props.get(ALLOW_ANY_HOSTNAME));
        if (allowAnyHostname) {
            this.setHostnameVerifier(new AllowAnyHostnameVerifier());
        }
        super.setProperties(props);
    }

    @Override
    public String toString() {
        return String.format("[%s@%d::operationExceptionResultCodes=%s, properties=%s, connectionStrategy=%s, controlProcessor=%s, environment=%s, tracePackets=%s, removeDnUrls=%s, searchIgnoreResultCodes=%s, sslSocketFactory=%s, hostnameVerifier=%s]", this.getClass().getName(), this.hashCode(), Arrays.toString((Object[])this.getOperationExceptionResultCodes()), this.getProperties(), this.getConnectionStrategy(), this.getControlProcessor(), this.environment, this.tracePackets, this.removeDnUrls, Arrays.toString((Object[])this.searchIgnoreResultCodes), this.sslSocketFactory, this.hostnameVerifier);
    }
}

