/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.Arrays;
import java.util.Iterator;
import org.ldaptive.Connection;
import org.ldaptive.DerefAliases;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.SearchScope;
import org.ldaptive.auth.AbstractSearchOperationFactory;
import org.ldaptive.auth.AuthenticationCriteria;
import org.ldaptive.auth.EntryResolver;
import org.ldaptive.handler.SearchEntryHandler;

public abstract class AbstractSearchEntryResolver
extends AbstractSearchOperationFactory
implements EntryResolver {
    private String baseDn = "";
    private String userFilter;
    private Object[] userFilterParameters;
    private boolean allowMultipleEntries;
    private boolean subtreeSearch;
    private DerefAliases derefAliases;
    private boolean followReferrals;
    @Deprecated
    private String[] retAttrs;
    private SearchEntryHandler[] entryHandlers;

    public String getBaseDn() {
        return this.baseDn;
    }

    public void setBaseDn(String dn) {
        this.logger.trace("setting baseDn: {}", (Object)dn);
        this.baseDn = dn;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public void setUserFilter(String filter) {
        this.logger.trace("setting userFilter: {}", (Object)filter);
        this.userFilter = filter;
    }

    public Object[] getUserFilterParameters() {
        return this.userFilterParameters;
    }

    public void setUserFilterParameters(Object[] filterParams) {
        this.logger.trace("setting userFilterParameters: {}", (Object)Arrays.toString(filterParams));
        this.userFilterParameters = filterParams;
    }

    public boolean getAllowMultipleEntries() {
        return this.allowMultipleEntries;
    }

    public void setAllowMultipleEntries(boolean b) {
        this.logger.trace("setting allowMultipleEntries: {}", (Object)b);
        this.allowMultipleEntries = b;
    }

    public boolean getSubtreeSearch() {
        return this.subtreeSearch;
    }

    public void setSubtreeSearch(boolean b) {
        this.logger.trace("setting subtreeSearch: {}", (Object)b);
        this.subtreeSearch = b;
    }

    public DerefAliases getDerefAliases() {
        return this.derefAliases;
    }

    public void setDerefAliases(DerefAliases da) {
        this.logger.trace("setting derefAliases: {}", (Object)da);
        this.derefAliases = da;
    }

    public boolean getFollowReferrals() {
        return this.followReferrals;
    }

    public void setFollowReferrals(boolean b) {
        this.logger.trace("setting followReferrals: {}", (Object)b);
        this.followReferrals = b;
    }

    @Deprecated
    public String[] getReturnAttributes() {
        return this.retAttrs;
    }

    @Deprecated
    public void setReturnAttributes(String ... attrs) {
        this.retAttrs = attrs;
    }

    public SearchEntryHandler[] getSearchEntryHandlers() {
        return this.entryHandlers;
    }

    public void setSearchEntryHandlers(SearchEntryHandler ... handlers) {
        this.entryHandlers = handlers;
    }

    protected abstract SearchResult performLdapSearch(Connection var1, AuthenticationCriteria var2) throws LdapException;

    protected SearchFilter createSearchFilter(AuthenticationCriteria ac) {
        SearchFilter filter = new SearchFilter();
        if (this.userFilter != null) {
            this.logger.debug("searching for entry using userFilter");
            filter.setFilter(this.userFilter);
            if (this.userFilterParameters != null) {
                filter.setParameters(this.userFilterParameters);
            }
            filter.setParameter("user", (Object)ac.getAuthenticationRequest().getUser());
            filter.setParameter("dn", (Object)ac.getDn());
        } else {
            this.logger.error("Invalid userFilter, cannot be null or empty.");
        }
        return filter;
    }

    @Deprecated
    protected SearchRequest createSearchRequest(AuthenticationCriteria ac, String[] returnAttributes) {
        SearchRequest request;
        if (this.userFilter != null) {
            request = new SearchRequest(this.baseDn, this.createSearchFilter(ac));
            request.setReturnAttributes(returnAttributes);
            if (this.subtreeSearch) {
                request.setSearchScope(SearchScope.SUBTREE);
            } else {
                request.setSearchScope(SearchScope.ONELEVEL);
            }
        } else {
            request = SearchRequest.newObjectScopeSearchRequest(ac.getDn(), returnAttributes);
        }
        request.setDerefAliases(this.derefAliases);
        request.setFollowReferrals(this.followReferrals);
        request.setSearchEntryHandlers(this.entryHandlers);
        return request;
    }

    protected SearchRequest createSearchRequest(AuthenticationCriteria ac) {
        SearchRequest request;
        if (this.userFilter != null) {
            request = new SearchRequest(this.baseDn, this.createSearchFilter(ac));
            request.setReturnAttributes(ac.getAuthenticationRequest().getReturnAttributes());
            if (this.subtreeSearch) {
                request.setSearchScope(SearchScope.SUBTREE);
            } else {
                request.setSearchScope(SearchScope.ONELEVEL);
            }
        } else {
            request = SearchRequest.newObjectScopeSearchRequest(ac.getDn(), ac.getAuthenticationRequest().getReturnAttributes());
        }
        request.setDerefAliases(this.derefAliases);
        request.setFollowReferrals(this.followReferrals);
        request.setSearchEntryHandlers(this.entryHandlers);
        return request;
    }

    @Override
    public LdapEntry resolve(Connection conn, AuthenticationCriteria ac) throws LdapException {
        this.logger.debug("resolve criteria={}", (Object)ac);
        SearchResult result = this.performLdapSearch(conn, ac);
        this.logger.debug("resolved result={} for criteria={}", (Object)result, (Object)ac);
        LdapEntry entry = null;
        Iterator<LdapEntry> answer = result.getEntries().iterator();
        if (answer != null && answer.hasNext()) {
            entry = answer.next();
            if (answer.hasNext()) {
                this.logger.debug("multiple results found for user={}", (Object)ac.getDn());
                if (!this.allowMultipleEntries) {
                    throw new LdapException("Found more than (1) entry for: " + ac.getDn());
                }
            }
        }
        return entry;
    }
}

