/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiRolesToInclude;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Arguments used for Rolling Restart Cluster command.")
public class ApiRollingRestartClusterArgs {
    @SerializedName(value="slaveBatchSize")
    private BigDecimal slaveBatchSize = null;
    @SerializedName(value="sleepSeconds")
    private BigDecimal sleepSeconds = null;
    @SerializedName(value="slaveFailCountThreshold")
    private BigDecimal slaveFailCountThreshold = null;
    @SerializedName(value="staleConfigsOnly")
    private Boolean staleConfigsOnly = null;
    @SerializedName(value="unUpgradedOnly")
    private Boolean unUpgradedOnly = null;
    @SerializedName(value="redeployClientConfiguration")
    private Boolean redeployClientConfiguration = null;
    @SerializedName(value="rolesToInclude")
    private ApiRolesToInclude rolesToInclude = null;
    @SerializedName(value="restartServiceNames")
    private List<String> restartServiceNames = null;

    public ApiRollingRestartClusterArgs slaveBatchSize(BigDecimal slaveBatchSize) {
        this.slaveBatchSize = slaveBatchSize;
        return this;
    }

    @ApiModelProperty(value="Number of hosts with slave roles to restart at a time. Must be greater than zero. Default is 1.")
    public BigDecimal getSlaveBatchSize() {
        return this.slaveBatchSize;
    }

    public void setSlaveBatchSize(BigDecimal slaveBatchSize) {
        this.slaveBatchSize = slaveBatchSize;
    }

    public ApiRollingRestartClusterArgs sleepSeconds(BigDecimal sleepSeconds) {
        this.sleepSeconds = sleepSeconds;
        return this;
    }

    @ApiModelProperty(value="Number of seconds to sleep between restarts of slave host batches. <p> Must be greater than or equal to 0. Default is 0.")
    public BigDecimal getSleepSeconds() {
        return this.sleepSeconds;
    }

    public void setSleepSeconds(BigDecimal sleepSeconds) {
        this.sleepSeconds = sleepSeconds;
    }

    public ApiRollingRestartClusterArgs slaveFailCountThreshold(BigDecimal slaveFailCountThreshold) {
        this.slaveFailCountThreshold = slaveFailCountThreshold;
        return this;
    }

    @ApiModelProperty(value="The threshold for number of slave host batches that are allowed to fail to restart before the entire command is considered failed. <p> Must be greater than or equal to 0. Default is 0. <p> This argument is for ADVANCED users only. </p>")
    public BigDecimal getSlaveFailCountThreshold() {
        return this.slaveFailCountThreshold;
    }

    public void setSlaveFailCountThreshold(BigDecimal slaveFailCountThreshold) {
        this.slaveFailCountThreshold = slaveFailCountThreshold;
    }

    public ApiRollingRestartClusterArgs staleConfigsOnly(Boolean staleConfigsOnly) {
        this.staleConfigsOnly = staleConfigsOnly;
        return this;
    }

    @ApiModelProperty(value="Restart roles with stale configs only.")
    public Boolean getStaleConfigsOnly() {
        return this.staleConfigsOnly;
    }

    public void setStaleConfigsOnly(Boolean staleConfigsOnly) {
        this.staleConfigsOnly = staleConfigsOnly;
    }

    public ApiRollingRestartClusterArgs unUpgradedOnly(Boolean unUpgradedOnly) {
        this.unUpgradedOnly = unUpgradedOnly;
        return this;
    }

    @ApiModelProperty(value="Restart roles that haven't been upgraded yet.")
    public Boolean getUnUpgradedOnly() {
        return this.unUpgradedOnly;
    }

    public void setUnUpgradedOnly(Boolean unUpgradedOnly) {
        this.unUpgradedOnly = unUpgradedOnly;
    }

    public ApiRollingRestartClusterArgs redeployClientConfiguration(Boolean redeployClientConfiguration) {
        this.redeployClientConfiguration = redeployClientConfiguration;
        return this;
    }

    @ApiModelProperty(value="Re-deploy client configuration. Available since API v6.")
    public Boolean getRedeployClientConfiguration() {
        return this.redeployClientConfiguration;
    }

    public void setRedeployClientConfiguration(Boolean redeployClientConfiguration) {
        this.redeployClientConfiguration = redeployClientConfiguration;
    }

    public ApiRollingRestartClusterArgs rolesToInclude(ApiRolesToInclude rolesToInclude) {
        this.rolesToInclude = rolesToInclude;
        return this;
    }

    @ApiModelProperty(value="Role types to restart. Default is slave roles only.")
    public ApiRolesToInclude getRolesToInclude() {
        return this.rolesToInclude;
    }

    public void setRolesToInclude(ApiRolesToInclude rolesToInclude) {
        this.rolesToInclude = rolesToInclude;
    }

    public ApiRollingRestartClusterArgs restartServiceNames(List<String> restartServiceNames) {
        this.restartServiceNames = restartServiceNames;
        return this;
    }

    public ApiRollingRestartClusterArgs addRestartServiceNamesItem(String restartServiceNamesItem) {
        if (this.restartServiceNames == null) {
            this.restartServiceNames = new ArrayList<String>();
        }
        this.restartServiceNames.add(restartServiceNamesItem);
        return this;
    }

    @ApiModelProperty(example="\"null\"", value="List of services to restart.")
    public List<String> getRestartServiceNames() {
        return this.restartServiceNames;
    }

    public void setRestartServiceNames(List<String> restartServiceNames) {
        this.restartServiceNames = restartServiceNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiRollingRestartClusterArgs apiRollingRestartClusterArgs = (ApiRollingRestartClusterArgs)o;
        return Objects.equals(this.slaveBatchSize, apiRollingRestartClusterArgs.slaveBatchSize) && Objects.equals(this.sleepSeconds, apiRollingRestartClusterArgs.sleepSeconds) && Objects.equals(this.slaveFailCountThreshold, apiRollingRestartClusterArgs.slaveFailCountThreshold) && Objects.equals(this.staleConfigsOnly, apiRollingRestartClusterArgs.staleConfigsOnly) && Objects.equals(this.unUpgradedOnly, apiRollingRestartClusterArgs.unUpgradedOnly) && Objects.equals(this.redeployClientConfiguration, apiRollingRestartClusterArgs.redeployClientConfiguration) && Objects.equals((Object)this.rolesToInclude, (Object)apiRollingRestartClusterArgs.rolesToInclude) && Objects.equals(this.restartServiceNames, apiRollingRestartClusterArgs.restartServiceNames);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.slaveBatchSize, this.sleepSeconds, this.slaveFailCountThreshold, this.staleConfigsOnly, this.unUpgradedOnly, this.redeployClientConfiguration, this.rolesToInclude, this.restartServiceNames});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiRollingRestartClusterArgs {\n");
        sb.append("    slaveBatchSize: ").append(this.toIndentedString(this.slaveBatchSize)).append("\n");
        sb.append("    sleepSeconds: ").append(this.toIndentedString(this.sleepSeconds)).append("\n");
        sb.append("    slaveFailCountThreshold: ").append(this.toIndentedString(this.slaveFailCountThreshold)).append("\n");
        sb.append("    staleConfigsOnly: ").append(this.toIndentedString(this.staleConfigsOnly)).append("\n");
        sb.append("    unUpgradedOnly: ").append(this.toIndentedString(this.unUpgradedOnly)).append("\n");
        sb.append("    redeployClientConfiguration: ").append(this.toIndentedString(this.redeployClientConfiguration)).append("\n");
        sb.append("    rolesToInclude: ").append(this.toIndentedString((Object)this.rolesToInclude)).append("\n");
        sb.append("    restartServiceNames: ").append(this.toIndentedString(this.restartServiceNames)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

