/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.MapKey;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import org.hibernate.AnnotationException;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.CollectionType;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterJoinTable;
import org.hibernate.annotations.FilterJoinTables;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.annotations.Loader;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLDeleteAll;
import org.hibernate.annotations.SQLInsert;
import org.hibernate.annotations.SQLUpdate;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.SortComparator;
import org.hibernate.annotations.SortNatural;
import org.hibernate.annotations.SortType;
import org.hibernate.annotations.Where;
import org.hibernate.annotations.WhereJoinTable;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.AccessType;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.CollectionPropertyHolder;
import org.hibernate.cfg.CollectionSecondPass;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.IndexColumn;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.PropertyInferredData;
import org.hibernate.cfg.PropertyPreloadedData;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.annotations.ArrayBinder;
import org.hibernate.cfg.annotations.BagBinder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.IdBagBinder;
import org.hibernate.cfg.annotations.ListBinder;
import org.hibernate.cfg.annotations.MapBinder;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.cfg.annotations.PrimitiveArrayBinder;
import org.hibernate.cfg.annotations.PropertyBinder;
import org.hibernate.cfg.annotations.SetBinder;
import org.hibernate.cfg.annotations.SimpleValueBinder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TypeDef;
import org.hibernate.mapping.Value;
import org.jboss.logging.Logger;

public abstract class CollectionBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)CollectionBinder.class.getName());
    protected org.hibernate.mapping.Collection collection;
    protected String propertyName;
    PropertyHolder propertyHolder;
    int batchSize;
    private String mappedBy;
    private XClass collectionType;
    private XClass targetEntity;
    private Mappings mappings;
    private Ejb3JoinColumn[] inverseJoinColumns;
    private String cascadeStrategy;
    String cacheConcurrencyStrategy;
    String cacheRegionName;
    private boolean oneToMany;
    protected IndexColumn indexColumn;
    protected boolean cascadeDeleteEnabled;
    protected String mapKeyPropertyName;
    private boolean insertable = true;
    private boolean updatable = true;
    private Ejb3JoinColumn[] fkJoinColumns;
    private boolean isExplicitAssociationTable;
    private Ejb3Column[] elementColumns;
    private boolean isEmbedded;
    private XProperty property;
    private boolean ignoreNotFound;
    private TableBinder tableBinder;
    private Ejb3Column[] mapKeyColumns;
    private Ejb3JoinColumn[] mapKeyManyToManyColumns;
    protected HashMap<String, IdGenerator> localGenerators;
    protected Map<XClass, InheritanceState> inheritanceStatePerClass;
    private XClass declaringClass;
    private boolean declaringClassSet;
    private AccessType accessType;
    private boolean hibernateExtensionMapping;
    private boolean isSortedCollection;
    private OrderBy jpaOrderBy;
    private org.hibernate.annotations.OrderBy sqlOrderBy;
    private Sort deprecatedSort;
    private SortNatural naturalSort;
    private SortComparator comparatorSort;
    private String explicitType;
    private Properties explicitTypeParameters = new Properties();
    private Ejb3JoinColumn[] joinColumns;

    protected Mappings getMappings() {
        return this.mappings;
    }

    public boolean isMap() {
        return false;
    }

    public void setIsHibernateExtensionMapping(boolean hibernateExtensionMapping) {
        this.hibernateExtensionMapping = hibernateExtensionMapping;
    }

    protected boolean isHibernateExtensionMapping() {
        return this.hibernateExtensionMapping;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public void setInheritanceStatePerClass(Map<XClass, InheritanceState> inheritanceStatePerClass) {
        this.inheritanceStatePerClass = inheritanceStatePerClass;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public void setCascadeStrategy(String cascadeStrategy) {
        this.cascadeStrategy = cascadeStrategy;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public void setInverseJoinColumns(Ejb3JoinColumn[] inverseJoinColumns) {
        this.inverseJoinColumns = inverseJoinColumns;
    }

    public void setJoinColumns(Ejb3JoinColumn[] joinColumns) {
        this.joinColumns = joinColumns;
    }

    public void setPropertyHolder(PropertyHolder propertyHolder) {
        this.propertyHolder = propertyHolder;
    }

    public void setBatchSize(BatchSize batchSize) {
        this.batchSize = batchSize == null ? -1 : batchSize.size();
    }

    public void setJpaOrderBy(OrderBy jpaOrderBy) {
        this.jpaOrderBy = jpaOrderBy;
    }

    public void setSqlOrderBy(org.hibernate.annotations.OrderBy sqlOrderBy) {
        this.sqlOrderBy = sqlOrderBy;
    }

    public void setSort(Sort deprecatedSort) {
        this.deprecatedSort = deprecatedSort;
    }

    public void setNaturalSort(SortNatural naturalSort) {
        this.naturalSort = naturalSort;
    }

    public void setComparatorSort(SortComparator comparatorSort) {
        this.comparatorSort = comparatorSort;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CollectionBinder getCollectionBinder(String entityName, XProperty property, boolean isIndexed, boolean isHibernateExtensionMapping, Mappings mappings) {
        void var5_17;
        if (property.isArray()) {
            if (property.getElementClass().isPrimitive()) {
                PrimitiveArrayBinder primitiveArrayBinder = new PrimitiveArrayBinder();
            } else {
                ArrayBinder arrayBinder = new ArrayBinder();
            }
        } else {
            if (!property.isCollection()) throw new AnnotationException("Illegal attempt to map a non collection as a @OneToMany, @ManyToMany or @CollectionOfElements: " + StringHelper.qualify(entityName, property.getName()));
            Class returnedClass = property.getCollectionClass();
            if (Set.class.equals((Object)returnedClass)) {
                if (property.isAnnotationPresent(CollectionId.class)) {
                    throw new AnnotationException("Set do not support @CollectionId: " + StringHelper.qualify(entityName, property.getName()));
                }
                SetBinder setBinder = new SetBinder(false);
            } else if (SortedSet.class.equals((Object)returnedClass)) {
                if (property.isAnnotationPresent(CollectionId.class)) {
                    throw new AnnotationException("Set do not support @CollectionId: " + StringHelper.qualify(entityName, property.getName()));
                }
                SetBinder setBinder = new SetBinder(true);
            } else if (Map.class.equals((Object)returnedClass)) {
                if (property.isAnnotationPresent(CollectionId.class)) {
                    throw new AnnotationException("Map do not support @CollectionId: " + StringHelper.qualify(entityName, property.getName()));
                }
                MapBinder mapBinder = new MapBinder(false);
            } else if (SortedMap.class.equals((Object)returnedClass)) {
                if (property.isAnnotationPresent(CollectionId.class)) {
                    throw new AnnotationException("Map do not support @CollectionId: " + StringHelper.qualify(entityName, property.getName()));
                }
                MapBinder mapBinder = new MapBinder(true);
            } else if (Collection.class.equals((Object)returnedClass)) {
                if (property.isAnnotationPresent(CollectionId.class)) {
                    IdBagBinder idBagBinder = new IdBagBinder();
                } else {
                    BagBinder bagBinder = new BagBinder();
                }
            } else {
                if (!List.class.equals((Object)returnedClass)) throw new AnnotationException(returnedClass.getName() + " collection not yet supported: " + StringHelper.qualify(entityName, property.getName()));
                if (isIndexed) {
                    if (property.isAnnotationPresent(CollectionId.class)) {
                        throw new AnnotationException("List do not support @CollectionId and @OrderColumn (or @IndexColumn) at the same time: " + StringHelper.qualify(entityName, property.getName()));
                    }
                    ListBinder listBinder = new ListBinder();
                } else if (property.isAnnotationPresent(CollectionId.class)) {
                    IdBagBinder idBagBinder = new IdBagBinder();
                } else {
                    BagBinder bagBinder = new BagBinder();
                }
            }
        }
        var5_17.setIsHibernateExtensionMapping(isHibernateExtensionMapping);
        CollectionType typeAnnotation = (CollectionType)property.getAnnotation(CollectionType.class);
        if (typeAnnotation == null) return var5_17;
        String typeName = typeAnnotation.type();
        TypeDef typeDef = mappings.getTypeDef(typeName);
        if (typeDef != null) {
            var5_17.explicitType = typeDef.getTypeClass();
            var5_17.explicitTypeParameters.putAll((Map<?, ?>)typeDef.getParameters());
            return var5_17;
        } else {
            var5_17.explicitType = typeName;
            for (Parameter param : typeAnnotation.parameters()) {
                var5_17.explicitTypeParameters.setProperty(param.name(), param.value());
            }
        }
        return var5_17;
    }

    protected CollectionBinder(boolean isSortedCollection) {
        this.isSortedCollection = isSortedCollection;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = mappedBy;
    }

    public void setTableBinder(TableBinder tableBinder) {
        this.tableBinder = tableBinder;
    }

    public void setCollectionType(XClass collectionType) {
        this.collectionType = collectionType;
    }

    public void setTargetEntity(XClass targetEntity) {
        this.targetEntity = targetEntity;
    }

    public void setMappings(Mappings mappings) {
        this.mappings = mappings;
    }

    protected abstract org.hibernate.mapping.Collection createCollection(PersistentClass var1);

    public org.hibernate.mapping.Collection getCollection() {
        return this.collection;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setDeclaringClass(XClass declaringClass) {
        this.declaringClass = declaringClass;
        this.declaringClassSet = true;
    }

    public void bind() {
        this.collection = this.createCollection(this.propertyHolder.getPersistentClass());
        String role = StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName);
        LOG.debugf("Collection role: %s", role);
        this.collection.setRole(role);
        this.collection.setNodeName(this.propertyName);
        this.collection.setMappedByProperty(this.mappedBy);
        if (this.property.isAnnotationPresent(MapKeyColumn.class) && this.mapKeyPropertyName != null) {
            throw new AnnotationException("Cannot mix @javax.persistence.MapKey and @MapKeyColumn or @org.hibernate.annotations.MapKey on the same collection: " + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName));
        }
        if (this.explicitType != null) {
            TypeDef typeDef = this.mappings.getTypeDef(this.explicitType);
            if (typeDef == null) {
                this.collection.setTypeName(this.explicitType);
                this.collection.setTypeParameters(this.explicitTypeParameters);
            } else {
                this.collection.setTypeName(typeDef.getTypeClass());
                this.collection.setTypeParameters(typeDef.getParameters());
            }
        }
        this.defineFetchingStrategy();
        this.collection.setBatchSize(this.batchSize);
        this.collection.setMutable(!this.property.isAnnotationPresent(Immutable.class));
        boolean isMappedBy = !BinderHelper.isEmptyAnnotationValue(this.mappedBy);
        OptimisticLock lockAnn = (OptimisticLock)this.property.getAnnotation(OptimisticLock.class);
        boolean includeInOptimisticLockChecks = lockAnn != null ? !lockAnn.excluded() : !isMappedBy;
        this.collection.setOptimisticLocked(includeInOptimisticLockChecks);
        Persister persisterAnn = (Persister)this.property.getAnnotation(Persister.class);
        if (persisterAnn != null) {
            this.collection.setCollectionPersisterClass(persisterAnn.impl());
        }
        this.applySortingAndOrdering(this.collection);
        if (StringHelper.isNotEmpty(this.cacheConcurrencyStrategy)) {
            this.collection.setCacheConcurrencyStrategy(this.cacheConcurrencyStrategy);
            this.collection.setCacheRegionName(this.cacheRegionName);
        }
        SQLInsert sqlInsert = (SQLInsert)this.property.getAnnotation(SQLInsert.class);
        SQLUpdate sqlUpdate = (SQLUpdate)this.property.getAnnotation(SQLUpdate.class);
        SQLDelete sqlDelete = (SQLDelete)this.property.getAnnotation(SQLDelete.class);
        SQLDeleteAll sqlDeleteAll = (SQLDeleteAll)this.property.getAnnotation(SQLDeleteAll.class);
        Loader loader = (Loader)this.property.getAnnotation(Loader.class);
        if (sqlInsert != null) {
            this.collection.setCustomSQLInsert(sqlInsert.sql().trim(), sqlInsert.callable(), ExecuteUpdateResultCheckStyle.fromExternalName(sqlInsert.check().toString().toLowerCase()));
        }
        if (sqlUpdate != null) {
            this.collection.setCustomSQLUpdate(sqlUpdate.sql(), sqlUpdate.callable(), ExecuteUpdateResultCheckStyle.fromExternalName(sqlUpdate.check().toString().toLowerCase()));
        }
        if (sqlDelete != null) {
            this.collection.setCustomSQLDelete(sqlDelete.sql(), sqlDelete.callable(), ExecuteUpdateResultCheckStyle.fromExternalName(sqlDelete.check().toString().toLowerCase()));
        }
        if (sqlDeleteAll != null) {
            this.collection.setCustomSQLDeleteAll(sqlDeleteAll.sql(), sqlDeleteAll.callable(), ExecuteUpdateResultCheckStyle.fromExternalName(sqlDeleteAll.check().toString().toLowerCase()));
        }
        if (loader != null) {
            this.collection.setLoaderName(loader.namedQuery());
        }
        if (isMappedBy && (this.property.isAnnotationPresent(JoinColumn.class) || this.property.isAnnotationPresent(JoinColumns.class) || this.propertyHolder.getJoinTable(this.property) != null)) {
            String message = "Associations marked as mappedBy must not define database mappings like @JoinTable or @JoinColumn: ";
            message = message + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName);
            throw new AnnotationException(message);
        }
        this.collection.setInverse(isMappedBy);
        if (!this.oneToMany && isMappedBy) {
            this.mappings.addMappedBy(this.getCollectionType().getName(), this.mappedBy, this.propertyName);
        }
        XClass collectionType = this.getCollectionType();
        if (this.inheritanceStatePerClass == null) {
            throw new AssertionFailure("inheritanceStatePerClass not set");
        }
        SecondPass sp = this.getSecondPass(this.fkJoinColumns, this.joinColumns, this.inverseJoinColumns, this.elementColumns, this.mapKeyColumns, this.mapKeyManyToManyColumns, this.isEmbedded, this.property, collectionType, this.ignoreNotFound, this.oneToMany, this.tableBinder, this.mappings);
        if (collectionType.isAnnotationPresent(Embeddable.class) || this.property.isAnnotationPresent(ElementCollection.class)) {
            this.mappings.addSecondPass(sp, !isMappedBy);
        } else {
            this.mappings.addSecondPass(sp, !isMappedBy);
        }
        this.mappings.addCollection(this.collection);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(this.propertyName);
        binder.setValue(this.collection);
        binder.setCascade(this.cascadeStrategy);
        if (this.cascadeStrategy != null && this.cascadeStrategy.indexOf("delete-orphan") >= 0) {
            this.collection.setOrphanDelete(true);
        }
        binder.setAccessType(this.accessType);
        binder.setProperty(this.property);
        binder.setInsertable(this.insertable);
        binder.setUpdatable(this.updatable);
        Property prop = binder.makeProperty();
        if (!this.declaringClassSet) {
            throw new AssertionFailure("DeclaringClass is not set in CollectionBinder while binding");
        }
        this.propertyHolder.addProperty(prop, this.declaringClass);
    }

    private void applySortingAndOrdering(org.hibernate.mapping.Collection collection) {
        boolean isSorted = this.isSortedCollection;
        boolean hadOrderBy = false;
        boolean hadExplicitSort = false;
        Class comparatorClass = null;
        if (this.jpaOrderBy == null && this.sqlOrderBy == null) {
            if (this.deprecatedSort != null) {
                LOG.debug("Encountered deprecated @Sort annotation; use @SortNatural or @SortComparator instead.");
                if (this.naturalSort != null || this.comparatorSort != null) {
                    throw this.buildIllegalSortCombination();
                }
                boolean bl = hadExplicitSort = this.deprecatedSort.type() != SortType.UNSORTED;
                if (this.deprecatedSort.type() == SortType.NATURAL) {
                    isSorted = true;
                } else if (this.deprecatedSort.type() == SortType.COMPARATOR) {
                    isSorted = true;
                    comparatorClass = this.deprecatedSort.comparator();
                }
            } else if (this.naturalSort != null) {
                if (this.comparatorSort != null) {
                    throw this.buildIllegalSortCombination();
                }
                hadExplicitSort = true;
            } else if (this.comparatorSort != null) {
                hadExplicitSort = true;
                comparatorClass = this.comparatorSort.value();
            }
        } else {
            if (this.jpaOrderBy != null && this.sqlOrderBy != null) {
                throw new AnnotationException(String.format("Illegal combination of @%s and @%s on %s", OrderBy.class.getName(), org.hibernate.annotations.OrderBy.class.getName(), this.safeCollectionRole()));
            }
            hadOrderBy = true;
            hadExplicitSort = false;
            if (this.sqlOrderBy != null) {
                collection.setOrderBy(this.sqlOrderBy.clause());
            }
        }
        if (this.isSortedCollection && !hadExplicitSort && !hadOrderBy) {
            throw new AnnotationException("A sorted collection must define and ordering or sorting : " + this.safeCollectionRole());
        }
        collection.setSorted(this.isSortedCollection || hadExplicitSort);
        if (comparatorClass != null) {
            try {
                collection.setComparator(comparatorClass.newInstance());
            }
            catch (Exception e) {
                throw new AnnotationException(String.format("Could not instantiate comparator class [%s] for %s", comparatorClass.getName(), this.safeCollectionRole()));
            }
        }
    }

    private AnnotationException buildIllegalSortCombination() {
        return new AnnotationException(String.format("Illegal combination of annotations on %s.  Only one of @%s, @%s and @%s can be used", this.safeCollectionRole(), Sort.class.getName(), SortNatural.class.getName(), SortComparator.class.getName()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void defineFetchingStrategy() {
        FetchType fetchType;
        LazyCollection lazy = (LazyCollection)this.property.getAnnotation(LazyCollection.class);
        Fetch fetch = (Fetch)this.property.getAnnotation(Fetch.class);
        OneToMany oneToMany = (OneToMany)this.property.getAnnotation(OneToMany.class);
        ManyToMany manyToMany = (ManyToMany)this.property.getAnnotation(ManyToMany.class);
        ElementCollection elementCollection = (ElementCollection)this.property.getAnnotation(ElementCollection.class);
        ManyToAny manyToAny = (ManyToAny)this.property.getAnnotation(ManyToAny.class);
        if (oneToMany != null) {
            fetchType = oneToMany.fetch();
        } else if (manyToMany != null) {
            fetchType = manyToMany.fetch();
        } else if (elementCollection != null) {
            fetchType = elementCollection.fetch();
        } else {
            if (manyToAny == null) throw new AssertionFailure("Define fetch strategy on a property not annotated with @ManyToOne nor @OneToMany nor @CollectionOfElements");
            fetchType = FetchType.LAZY;
        }
        if (lazy != null) {
            this.collection.setLazy(lazy.value() != LazyCollectionOption.FALSE);
            this.collection.setExtraLazy(lazy.value() == LazyCollectionOption.EXTRA);
        } else {
            this.collection.setLazy(fetchType == FetchType.LAZY);
            this.collection.setExtraLazy(false);
        }
        if (fetch != null) {
            if (fetch.value() == org.hibernate.annotations.FetchMode.JOIN) {
                this.collection.setFetchMode(FetchMode.JOIN);
                this.collection.setLazy(false);
                return;
            } else if (fetch.value() == org.hibernate.annotations.FetchMode.SELECT) {
                this.collection.setFetchMode(FetchMode.SELECT);
                return;
            } else {
                if (fetch.value() != org.hibernate.annotations.FetchMode.SUBSELECT) throw new AssertionFailure("Unknown FetchMode: " + (Object)((Object)fetch.value()));
                this.collection.setFetchMode(FetchMode.SELECT);
                this.collection.setSubselectLoadable(true);
                this.collection.getOwner().setSubselectLoadableCollections(true);
            }
            return;
        } else {
            this.collection.setFetchMode(AnnotationBinder.getFetchMode(fetchType));
        }
    }

    private XClass getCollectionType() {
        if (AnnotationBinder.isDefault(this.targetEntity, this.mappings)) {
            if (this.collectionType != null) {
                return this.collectionType;
            }
            String errorMsg = "Collection has neither generic type or OneToMany.targetEntity() defined: " + this.safeCollectionRole();
            throw new AnnotationException(errorMsg);
        }
        return this.targetEntity;
    }

    public SecondPass getSecondPass(final Ejb3JoinColumn[] fkJoinColumns, final Ejb3JoinColumn[] keyColumns, final Ejb3JoinColumn[] inverseColumns, final Ejb3Column[] elementColumns, Ejb3Column[] mapKeyColumns, Ejb3JoinColumn[] mapKeyManyToManyColumns, final boolean isEmbedded, final XProperty property, final XClass collType, final boolean ignoreNotFound, final boolean unique, final TableBinder assocTableBinder, final Mappings mappings) {
        return new CollectionSecondPass(mappings, this.collection){

            @Override
            public void secondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
                CollectionBinder.this.bindStarToManySecondPass(persistentClasses, collType, fkJoinColumns, keyColumns, inverseColumns, elementColumns, isEmbedded, property, unique, assocTableBinder, ignoreNotFound, mappings);
            }
        };
    }

    protected boolean bindStarToManySecondPass(Map persistentClasses, XClass collType, Ejb3JoinColumn[] fkJoinColumns, Ejb3JoinColumn[] keyColumns, Ejb3JoinColumn[] inverseColumns, Ejb3Column[] elementColumns, boolean isEmbedded, XProperty property, boolean unique, TableBinder associationTableBinder, boolean ignoreNotFound, Mappings mappings) {
        PersistentClass persistentClass = (PersistentClass)persistentClasses.get(collType.getName());
        boolean reversePropertyInJoin = false;
        if (persistentClass != null && StringHelper.isNotEmpty(this.mappedBy)) {
            try {
                reversePropertyInJoin = 0 != persistentClass.getJoinNumber(persistentClass.getRecursiveProperty(this.mappedBy));
            }
            catch (MappingException e) {
                StringBuilder error = new StringBuilder(80);
                error.append("mappedBy reference an unknown target entity property: ").append(collType).append(".").append(this.mappedBy).append(" in ").append(this.collection.getOwnerEntityName()).append(".").append(property.getName());
                throw new AnnotationException(error.toString());
            }
        }
        if (persistentClass != null && !reversePropertyInJoin && this.oneToMany && !this.isExplicitAssociationTable && (this.joinColumns[0].isImplicit() && !BinderHelper.isEmptyAnnotationValue(this.mappedBy) || !fkJoinColumns[0].isImplicit())) {
            this.bindOneToManySecondPass(this.getCollection(), persistentClasses, fkJoinColumns, collType, this.cascadeDeleteEnabled, ignoreNotFound, mappings, this.inheritanceStatePerClass);
            return true;
        }
        this.bindManyToManySecondPass(this.collection, persistentClasses, keyColumns, inverseColumns, elementColumns, isEmbedded, collType, ignoreNotFound, unique, this.cascadeDeleteEnabled, associationTableBinder, property, this.propertyHolder, mappings);
        return false;
    }

    protected void bindOneToManySecondPass(org.hibernate.mapping.Collection collection, Map persistentClasses, Ejb3JoinColumn[] fkJoinColumns, XClass collectionType, boolean cascadeDeleteEnabled, boolean ignoreNotFound, Mappings mappings, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        String orderByFragment;
        boolean debugEnabled = LOG.isDebugEnabled();
        if (debugEnabled) {
            LOG.debugf("Binding a OneToMany: %s.%s through a foreign key", this.propertyHolder.getEntityName(), this.propertyName);
        }
        org.hibernate.mapping.OneToMany oneToMany = new org.hibernate.mapping.OneToMany(mappings, collection.getOwner());
        collection.setElement(oneToMany);
        oneToMany.setReferencedEntityName(collectionType.getName());
        oneToMany.setIgnoreNotFound(ignoreNotFound);
        String assocClass = oneToMany.getReferencedEntityName();
        PersistentClass associatedClass = (PersistentClass)persistentClasses.get(assocClass);
        if (this.jpaOrderBy != null && StringHelper.isNotEmpty(orderByFragment = CollectionBinder.buildOrderByClauseFromHql(this.jpaOrderBy.value(), associatedClass, collection.getRole()))) {
            collection.setOrderBy(orderByFragment);
        }
        if (mappings == null) {
            throw new AssertionFailure("CollectionSecondPass for oneToMany should not be called with null mappings");
        }
        Map<String, Join> joins = mappings.getJoins(assocClass);
        if (associatedClass == null) {
            throw new MappingException("Association references unmapped class: " + assocClass);
        }
        oneToMany.setAssociatedClass(associatedClass);
        for (Ejb3JoinColumn column : fkJoinColumns) {
            column.setPersistentClass(associatedClass, joins, inheritanceStatePerClass);
            column.setJoins(joins);
            collection.setCollectionTable(column.getTable());
        }
        if (debugEnabled) {
            LOG.debugf("Mapping collection: %s -> %s", collection.getRole(), collection.getCollectionTable().getName());
        }
        this.bindFilters(false);
        CollectionBinder.bindCollectionSecondPass(collection, null, fkJoinColumns, cascadeDeleteEnabled, this.property, mappings);
        if (!collection.isInverse() && !collection.getKey().isNullable()) {
            String entityName = oneToMany.getReferencedEntityName();
            PersistentClass referenced = mappings.getClass(entityName);
            Backref prop = new Backref();
            prop.setName('_' + fkJoinColumns[0].getPropertyName() + '_' + fkJoinColumns[0].getLogicalColumnName() + "Backref");
            prop.setUpdateable(false);
            prop.setSelectable(false);
            prop.setCollectionRole(collection.getRole());
            prop.setEntityName(collection.getOwner().getEntityName());
            prop.setValue(collection.getKey());
            referenced.addProperty(prop);
        }
    }

    private void bindFilters(boolean hasAssociationTable) {
        WhereJoinTable whereJoinTable;
        String whereJoinTableClause;
        Where where;
        String whereClause;
        FilterJoinTables filterJoinTables;
        FilterJoinTable simpleFilterJoinTable;
        Filters filters;
        Filter simpleFilter = (Filter)this.property.getAnnotation(Filter.class);
        if (simpleFilter != null) {
            if (hasAssociationTable) {
                this.collection.addManyToManyFilter(simpleFilter.name(), this.getCondition(simpleFilter), simpleFilter.deduceAliasInjectionPoints(), BinderHelper.toAliasTableMap(simpleFilter.aliases()), BinderHelper.toAliasEntityMap(simpleFilter.aliases()));
            } else {
                this.collection.addFilter(simpleFilter.name(), this.getCondition(simpleFilter), simpleFilter.deduceAliasInjectionPoints(), BinderHelper.toAliasTableMap(simpleFilter.aliases()), BinderHelper.toAliasEntityMap(simpleFilter.aliases()));
            }
        }
        if ((filters = (Filters)this.property.getAnnotation(Filters.class)) != null) {
            for (Filter filter : filters.value()) {
                if (hasAssociationTable) {
                    this.collection.addManyToManyFilter(filter.name(), this.getCondition(filter), filter.deduceAliasInjectionPoints(), BinderHelper.toAliasTableMap(filter.aliases()), BinderHelper.toAliasEntityMap(filter.aliases()));
                    continue;
                }
                this.collection.addFilter(filter.name(), this.getCondition(filter), filter.deduceAliasInjectionPoints(), BinderHelper.toAliasTableMap(filter.aliases()), BinderHelper.toAliasEntityMap(filter.aliases()));
            }
        }
        if ((simpleFilterJoinTable = (FilterJoinTable)this.property.getAnnotation(FilterJoinTable.class)) != null) {
            if (hasAssociationTable) {
                this.collection.addFilter(simpleFilterJoinTable.name(), simpleFilterJoinTable.condition(), simpleFilterJoinTable.deduceAliasInjectionPoints(), BinderHelper.toAliasTableMap(simpleFilterJoinTable.aliases()), BinderHelper.toAliasEntityMap(simpleFilterJoinTable.aliases()));
            } else {
                throw new AnnotationException("Illegal use of @FilterJoinTable on an association without join table:" + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName));
            }
        }
        if ((filterJoinTables = (FilterJoinTables)this.property.getAnnotation(FilterJoinTables.class)) != null) {
            for (FilterJoinTable filter : filterJoinTables.value()) {
                if (!hasAssociationTable) {
                    throw new AnnotationException("Illegal use of @FilterJoinTable on an association without join table:" + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName));
                }
                this.collection.addFilter(filter.name(), filter.condition(), filter.deduceAliasInjectionPoints(), BinderHelper.toAliasTableMap(filter.aliases()), BinderHelper.toAliasEntityMap(filter.aliases()));
            }
        }
        String string = whereClause = (where = (Where)this.property.getAnnotation(Where.class)) == null ? null : where.clause();
        if (StringHelper.isNotEmpty(whereClause)) {
            if (hasAssociationTable) {
                this.collection.setManyToManyWhere(whereClause);
            } else {
                this.collection.setWhere(whereClause);
            }
        }
        String string2 = whereJoinTableClause = (whereJoinTable = (WhereJoinTable)this.property.getAnnotation(WhereJoinTable.class)) == null ? null : whereJoinTable.clause();
        if (StringHelper.isNotEmpty(whereJoinTableClause)) {
            if (hasAssociationTable) {
                this.collection.setWhere(whereJoinTableClause);
            } else {
                throw new AnnotationException("Illegal use of @WhereJoinTable on an association without join table:" + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName));
            }
        }
    }

    private String getCondition(FilterJoinTable filter) {
        String name = filter.name();
        String cond = filter.condition();
        return this.getCondition(cond, name);
    }

    private String getCondition(Filter filter) {
        String name = filter.name();
        String cond = filter.condition();
        return this.getCondition(cond, name);
    }

    private String getCondition(String cond, String name) {
        if (BinderHelper.isEmptyAnnotationValue(cond) && StringHelper.isEmpty(cond = this.mappings.getFilterDefinition(name).getDefaultFilterCondition())) {
            throw new AnnotationException("no filter condition found for filter " + name + " in " + StringHelper.qualify(this.propertyHolder.getPath(), this.propertyName));
        }
        return cond;
    }

    public void setCache(Cache cacheAnn) {
        if (cacheAnn != null) {
            this.cacheRegionName = BinderHelper.isEmptyAnnotationValue(cacheAnn.region()) ? null : cacheAnn.region();
            this.cacheConcurrencyStrategy = EntityBinder.getCacheConcurrencyStrategy(cacheAnn.usage());
        } else {
            this.cacheConcurrencyStrategy = null;
            this.cacheRegionName = null;
        }
    }

    public void setOneToMany(boolean oneToMany) {
        this.oneToMany = oneToMany;
    }

    public void setIndexColumn(IndexColumn indexColumn) {
        this.indexColumn = indexColumn;
    }

    public void setMapKey(MapKey key) {
        if (key != null) {
            this.mapKeyPropertyName = key.name();
        }
    }

    private static String buildOrderByClauseFromHql(String orderByFragment, PersistentClass associatedClass, String role) {
        if (orderByFragment != null) {
            if (orderByFragment.length() == 0) {
                return "id asc";
            }
            if ("desc".equals(orderByFragment)) {
                return "id desc";
            }
        }
        return orderByFragment;
    }

    private static String adjustUserSuppliedValueCollectionOrderingFragment(String orderByFragment) {
        if (orderByFragment != null) {
            if (orderByFragment.length() == 0) {
                return "$element$ asc";
            }
            if ("desc".equals(orderByFragment)) {
                return "$element$ desc";
            }
        }
        return orderByFragment;
    }

    private static SimpleValue buildCollectionKey(org.hibernate.mapping.Collection collValue, Ejb3JoinColumn[] joinColumns, boolean cascadeDeleteEnabled, XProperty property, Mappings mappings) {
        String fkName;
        String propRef;
        String entityName;
        String propRef2;
        if (joinColumns.length > 0 && StringHelper.isNotEmpty(joinColumns[0].getMappedBy()) && (propRef2 = mappings.getPropertyReferencedAssociation(entityName = joinColumns[0].getManyToManyOwnerSideEntityName() != null ? "inverse__" + joinColumns[0].getManyToManyOwnerSideEntityName() : joinColumns[0].getPropertyHolder().getEntityName(), joinColumns[0].getMappedBy())) != null) {
            collValue.setReferencedPropertyName(propRef2);
            mappings.addPropertyReference(collValue.getOwnerEntityName(), propRef2);
        }
        KeyValue keyVal = (propRef = collValue.getReferencedPropertyName()) == null ? collValue.getOwner().getIdentifier() : (KeyValue)collValue.getOwner().getReferencedProperty(propRef).getValue();
        DependantValue key = new DependantValue(mappings, collValue.getCollectionTable(), keyVal);
        key.setTypeName(null);
        Ejb3Column.checkPropertyConsistency(joinColumns, collValue.getOwnerEntityName());
        key.setNullable(joinColumns.length == 0 || joinColumns[0].isNullable());
        key.setUpdateable(joinColumns.length == 0 || joinColumns[0].isUpdatable());
        key.setCascadeDeleteEnabled(cascadeDeleteEnabled);
        collValue.setKey(key);
        ForeignKey fk = property != null ? (ForeignKey)property.getAnnotation(ForeignKey.class) : null;
        String string = fkName = fk != null ? fk.name() : "";
        if (!BinderHelper.isEmptyAnnotationValue(fkName)) {
            key.setForeignKeyName(fkName);
        }
        return key;
    }

    protected void bindManyToManySecondPass(org.hibernate.mapping.Collection collValue, Map persistentClasses, Ejb3JoinColumn[] joinColumns, Ejb3JoinColumn[] inverseJoinColumns, Ejb3Column[] elementColumns, boolean isEmbedded, XClass collType, boolean ignoreNotFound, boolean unique, boolean cascadeDeleteEnabled, TableBinder associationTableBinder, XProperty property, PropertyHolder parentPropertyHolder, Mappings mappings) throws MappingException {
        boolean mappedBy;
        String path;
        if (property == null) {
            throw new IllegalArgumentException("null was passed for argument property");
        }
        PersistentClass collectionEntity = (PersistentClass)persistentClasses.get(collType.getName());
        String hqlOrderBy = this.extractHqlOrderBy(this.jpaOrderBy);
        boolean isCollectionOfEntities = collectionEntity != null;
        ManyToAny anyAnn = (ManyToAny)property.getAnnotation(ManyToAny.class);
        if (LOG.isDebugEnabled()) {
            path = collValue.getOwnerEntityName() + "." + joinColumns[0].getPropertyName();
            if (isCollectionOfEntities && unique) {
                LOG.debugf("Binding a OneToMany: %s through an association table", path);
            } else if (isCollectionOfEntities) {
                LOG.debugf("Binding as ManyToMany: %s", path);
            } else if (anyAnn != null) {
                LOG.debugf("Binding a ManyToAny: %s", path);
            } else {
                LOG.debugf("Binding a collection of element: %s", path);
            }
        }
        if (!isCollectionOfEntities) {
            if (property.isAnnotationPresent(ManyToMany.class) || property.isAnnotationPresent(OneToMany.class)) {
                path = collValue.getOwnerEntityName() + "." + joinColumns[0].getPropertyName();
                throw new AnnotationException("Use of @OneToMany or @ManyToMany targeting an unmapped class: " + path + "[" + collType + "]");
            }
            if (anyAnn != null) {
                if (parentPropertyHolder.getJoinTable(property) == null) {
                    path = collValue.getOwnerEntityName() + "." + joinColumns[0].getPropertyName();
                    throw new AnnotationException("@JoinTable is mandatory when @ManyToAny is used: " + path);
                }
            } else {
                JoinTable joinTableAnn = parentPropertyHolder.getJoinTable(property);
                if (joinTableAnn != null && joinTableAnn.inverseJoinColumns().length > 0) {
                    String path2 = collValue.getOwnerEntityName() + "." + joinColumns[0].getPropertyName();
                    throw new AnnotationException("Use of @JoinTable.inverseJoinColumns targeting an unmapped class: " + path2 + "[" + collType + "]");
                }
            }
        }
        boolean bl = mappedBy = !BinderHelper.isEmptyAnnotationValue(joinColumns[0].getMappedBy());
        if (mappedBy) {
            Property otherSideProperty;
            if (!isCollectionOfEntities) {
                StringBuilder error = new StringBuilder(80).append("Collection of elements must not have mappedBy or association reference an unmapped entity: ").append(collValue.getOwnerEntityName()).append(".").append(joinColumns[0].getPropertyName());
                throw new AnnotationException(error.toString());
            }
            try {
                otherSideProperty = collectionEntity.getRecursiveProperty(joinColumns[0].getMappedBy());
            }
            catch (MappingException e) {
                StringBuilder error = new StringBuilder(80);
                error.append("mappedBy reference an unknown target entity property: ").append(collType).append(".").append(joinColumns[0].getMappedBy()).append(" in ").append(collValue.getOwnerEntityName()).append(".").append(joinColumns[0].getPropertyName());
                throw new AnnotationException(error.toString());
            }
            Table table = otherSideProperty.getValue() instanceof org.hibernate.mapping.Collection ? ((org.hibernate.mapping.Collection)otherSideProperty.getValue()).getCollectionTable() : otherSideProperty.getValue().getTable();
            collValue.setCollectionTable(table);
            String entityName = collectionEntity.getEntityName();
            for (Ejb3JoinColumn column : joinColumns) {
                column.setManyToManyOwnerSideEntityName(entityName);
            }
        } else {
            for (Ejb3JoinColumn column : joinColumns) {
                String mappedByProperty = mappings.getFromMappedBy(collValue.getOwnerEntityName(), column.getPropertyName());
                Table ownerTable = collValue.getOwner().getTable();
                column.setMappedBy(collValue.getOwner().getEntityName(), mappings.getLogicalTableName(ownerTable), mappedByProperty);
            }
            if (StringHelper.isEmpty(associationTableBinder.getName())) {
                associationTableBinder.setDefaultName(collValue.getOwner().getEntityName(), mappings.getLogicalTableName(collValue.getOwner().getTable()), collectionEntity != null ? collectionEntity.getEntityName() : null, collectionEntity != null ? mappings.getLogicalTableName(collectionEntity.getTable()) : null, joinColumns[0].getPropertyName());
            }
            associationTableBinder.setJPA2ElementCollection(!isCollectionOfEntities && property.isAnnotationPresent(ElementCollection.class));
            collValue.setCollectionTable(associationTableBinder.bind());
        }
        this.bindFilters(isCollectionOfEntities);
        CollectionBinder.bindCollectionSecondPass(collValue, collectionEntity, joinColumns, cascadeDeleteEnabled, property, mappings);
        ManyToOne element = null;
        if (isCollectionOfEntities) {
            ForeignKey fk;
            String fkName;
            element = new ManyToOne(mappings, collValue.getCollectionTable());
            collValue.setElement(element);
            element.setReferencedEntityName(collType.getName());
            element.setFetchMode(FetchMode.JOIN);
            element.setLazy(false);
            element.setIgnoreNotFound(ignoreNotFound);
            if (hqlOrderBy != null) {
                collValue.setManyToManyOrdering(CollectionBinder.buildOrderByClauseFromHql(hqlOrderBy, collectionEntity, collValue.getRole()));
            }
            String string = fkName = (fk = (ForeignKey)property.getAnnotation(ForeignKey.class)) != null ? fk.inverseName() : "";
            if (!BinderHelper.isEmptyAnnotationValue(fkName)) {
                element.setForeignKeyName(fkName);
            }
        } else if (anyAnn != null) {
            PropertyInferredData inferredData = new PropertyInferredData(null, property, "unsupported", mappings.getReflectionManager());
            for (Ejb3JoinColumn column : inverseJoinColumns) {
                column.setTable(collValue.getCollectionTable());
            }
            Any any = BinderHelper.buildAnyValue(anyAnn.metaDef(), inverseJoinColumns, anyAnn.metaColumn(), inferredData, cascadeDeleteEnabled, Nullability.NO_CONSTRAINT, this.propertyHolder, new EntityBinder(), true, mappings);
            collValue.setElement(any);
        } else {
            XClass elementClass;
            AnnotatedClassType classType;
            CollectionPropertyHolder holder = null;
            if (BinderHelper.PRIMITIVE_NAMES.contains(collType.getName())) {
                classType = AnnotatedClassType.NONE;
                elementClass = null;
                holder = PropertyHolderBuilder.buildPropertyHolder(collValue, collValue.getRole(), null, property, parentPropertyHolder, mappings);
            } else {
                boolean attributeOverride;
                elementClass = collType;
                classType = mappings.getClassType(elementClass);
                holder = PropertyHolderBuilder.buildPropertyHolder(collValue, collValue.getRole(), elementClass, property, parentPropertyHolder, mappings);
                parentPropertyHolder.startingProperty(property);
                boolean bl2 = attributeOverride = property.isAnnotationPresent(AttributeOverride.class) || property.isAnnotationPresent(AttributeOverrides.class);
                if (isEmbedded || attributeOverride) {
                    classType = AnnotatedClassType.EMBEDDABLE;
                }
            }
            if (AnnotatedClassType.EMBEDDABLE.equals((Object)classType)) {
                boolean isPropertyAnnotated;
                EntityBinder entityBinder = new EntityBinder();
                PersistentClass owner = collValue.getOwner();
                if (owner.getIdentifierProperty() != null) {
                    isPropertyAnnotated = owner.getIdentifierProperty().getPropertyAccessorName().equals("property");
                } else if (owner.getIdentifierMapper() != null && owner.getIdentifierMapper().getPropertySpan() > 0) {
                    Property prop = (Property)owner.getIdentifierMapper().getPropertyIterator().next();
                    isPropertyAnnotated = prop.getPropertyAccessorName().equals("property");
                } else {
                    throw new AssertionFailure("Unable to guess collection property accessor name");
                }
                PropertyPreloadedData inferredData = this.isMap() ? (this.isHibernateExtensionMapping() ? new PropertyPreloadedData(AccessType.PROPERTY, "element", elementClass) : new PropertyPreloadedData(AccessType.PROPERTY, "value", elementClass)) : (this.isHibernateExtensionMapping() ? new PropertyPreloadedData(AccessType.PROPERTY, "element", elementClass) : new PropertyPreloadedData(AccessType.PROPERTY, "collection&&element", elementClass));
                boolean isNullable = true;
                Component component = AnnotationBinder.fillComponent(holder, inferredData, isPropertyAnnotated ? AccessType.PROPERTY : AccessType.FIELD, isNullable, entityBinder, false, false, true, mappings, this.inheritanceStatePerClass);
                collValue.setElement(component);
                if (StringHelper.isNotEmpty(hqlOrderBy)) {
                    String path3 = collValue.getOwnerEntityName() + "." + joinColumns[0].getPropertyName();
                    String orderBy = CollectionBinder.adjustUserSuppliedValueCollectionOrderingFragment(hqlOrderBy);
                    if (orderBy != null) {
                        collValue.setOrderBy(orderBy);
                    }
                }
            } else {
                holder.prepare(property);
                SimpleValueBinder elementBinder = new SimpleValueBinder();
                elementBinder.setMappings(mappings);
                elementBinder.setReturnedClassName(collType.getName());
                if (elementColumns == null || elementColumns.length == 0) {
                    elementColumns = new Ejb3Column[1];
                    Ejb3Column column = new Ejb3Column();
                    column.setImplicit(false);
                    column.setNullable(true);
                    column.setLength(255);
                    column.setLogicalColumnName("elt");
                    column.setJoins(new HashMap<String, Join>());
                    column.setMappings(mappings);
                    column.bind();
                    elementColumns[0] = column;
                }
                for (Ejb3Column column : elementColumns) {
                    column.setTable(collValue.getCollectionTable());
                }
                elementBinder.setColumns(elementColumns);
                elementBinder.setType(property, elementClass, collValue.getOwnerEntityName(), holder.resolveElementAttributeConverterDefinition(elementClass));
                elementBinder.setPersistentClassName(this.propertyHolder.getEntityName());
                elementBinder.setAccessType(this.accessType);
                collValue.setElement(elementBinder.make());
                String orderBy = CollectionBinder.adjustUserSuppliedValueCollectionOrderingFragment(hqlOrderBy);
                if (orderBy != null) {
                    collValue.setOrderBy(orderBy);
                }
            }
        }
        CollectionBinder.checkFilterConditions(collValue);
        if (isCollectionOfEntities) {
            CollectionBinder.bindManytoManyInverseFk(collectionEntity, inverseJoinColumns, element, unique, mappings);
        }
    }

    private String extractHqlOrderBy(OrderBy jpaOrderBy) {
        if (jpaOrderBy != null) {
            return jpaOrderBy.value();
        }
        return null;
    }

    private static void checkFilterConditions(org.hibernate.mapping.Collection collValue) {
        if ((collValue.getFilters().size() != 0 || StringHelper.isNotEmpty(collValue.getWhere())) && collValue.getFetchMode() == FetchMode.JOIN && !(collValue.getElement() instanceof SimpleValue) && collValue.getElement().getFetchMode() != FetchMode.JOIN) {
            throw new MappingException("@ManyToMany or @CollectionOfElements defining filter or where without join fetching not valid within collection using join fetching[" + collValue.getRole() + "]");
        }
    }

    private static void bindCollectionSecondPass(org.hibernate.mapping.Collection collValue, PersistentClass collectionEntity, Ejb3JoinColumn[] joinColumns, boolean cascadeDeleteEnabled, XProperty property, Mappings mappings) {
        try {
            BinderHelper.createSyntheticPropertyReference(joinColumns, collValue.getOwner(), collectionEntity, collValue, false, mappings);
        }
        catch (AnnotationException ex) {
            throw new AnnotationException("Unable to map collection " + collectionEntity.getClassName() + "." + property.getName(), ex);
        }
        SimpleValue key = CollectionBinder.buildCollectionKey(collValue, joinColumns, cascadeDeleteEnabled, property, mappings);
        if (property.isAnnotationPresent(ElementCollection.class) && joinColumns.length > 0) {
            joinColumns[0].setJPA2ElementCollection(true);
        }
        TableBinder.bindFk(collValue.getOwner(), collectionEntity, joinColumns, key, false, mappings);
    }

    public void setCascadeDeleteEnabled(boolean onDeleteCascade) {
        this.cascadeDeleteEnabled = onDeleteCascade;
    }

    private String safeCollectionRole() {
        if (this.propertyHolder != null) {
            return this.propertyHolder.getEntityName() + "." + this.propertyName;
        }
        return "";
    }

    public static void bindManytoManyInverseFk(PersistentClass referencedEntity, Ejb3JoinColumn[] columns, SimpleValue value, boolean unique, Mappings mappings) {
        String mappedBy = columns[0].getMappedBy();
        if (StringHelper.isNotEmpty(mappedBy)) {
            Iterator<Selectable> mappedByColumns;
            Property property = referencedEntity.getRecursiveProperty(mappedBy);
            if (property.getValue() instanceof org.hibernate.mapping.Collection) {
                mappedByColumns = ((org.hibernate.mapping.Collection)property.getValue()).getKey().getColumnIterator();
            } else {
                Iterator joinsIt = referencedEntity.getJoinIterator();
                Value key = null;
                while (joinsIt.hasNext()) {
                    Join join = (Join)joinsIt.next();
                    if (!join.containsProperty(property)) continue;
                    key = join.getKey();
                    break;
                }
                if (key == null) {
                    key = property.getPersistentClass().getIdentifier();
                }
                mappedByColumns = key.getColumnIterator();
            }
            while (mappedByColumns.hasNext()) {
                Column column = (Column)mappedByColumns.next();
                columns[0].linkValueUsingAColumnCopy(column, value);
            }
            String referencedPropertyName = mappings.getPropertyReferencedAssociation("inverse__" + referencedEntity.getEntityName(), mappedBy);
            if (referencedPropertyName != null) {
                ((ManyToOne)value).setReferencedPropertyName(referencedPropertyName);
                mappings.addUniquePropertyReference(referencedEntity.getEntityName(), referencedPropertyName);
            }
            ((ManyToOne)value).setReferenceToPrimaryKey(referencedPropertyName == null);
            value.createForeignKey();
        } else {
            BinderHelper.createSyntheticPropertyReference(columns, referencedEntity, null, value, true, mappings);
            TableBinder.bindFk(referencedEntity, null, columns, value, unique, mappings);
        }
    }

    public void setFkJoinColumns(Ejb3JoinColumn[] ejb3JoinColumns) {
        this.fkJoinColumns = ejb3JoinColumns;
    }

    public void setExplicitAssociationTable(boolean explicitAssocTable) {
        this.isExplicitAssociationTable = explicitAssocTable;
    }

    public void setElementColumns(Ejb3Column[] elementColumns) {
        this.elementColumns = elementColumns;
    }

    public void setEmbedded(boolean annotationPresent) {
        this.isEmbedded = annotationPresent;
    }

    public void setProperty(XProperty property) {
        this.property = property;
    }

    public void setIgnoreNotFound(boolean ignoreNotFound) {
        this.ignoreNotFound = ignoreNotFound;
    }

    public void setMapKeyColumns(Ejb3Column[] mapKeyColumns) {
        this.mapKeyColumns = mapKeyColumns;
    }

    public void setMapKeyManyToManyColumns(Ejb3JoinColumn[] mapJoinColumns) {
        this.mapKeyManyToManyColumns = mapJoinColumns;
    }

    public void setLocalGenerators(HashMap<String, IdGenerator> localGenerators) {
        this.localGenerators = localGenerators;
    }
}

