/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.monitor;

import com.cloudera.api.swagger.EventsResourceApi;
import com.cloudera.api.swagger.RolesResourceApi;
import com.cloudera.api.swagger.ServicesResourceApi;
import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiEvent;
import com.cloudera.api.swagger.model.ApiEventAttribute;
import com.cloudera.api.swagger.model.ApiEventCategory;
import com.cloudera.api.swagger.model.ApiEventQueryResult;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiRoleList;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.knox.gateway.GatewayServer;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.topology.TopologyService;
import org.apache.knox.gateway.topology.ClusterConfigurationMonitorService;
import org.apache.knox.gateway.topology.discovery.ClusterConfigurationMonitor;
import org.apache.knox.gateway.topology.discovery.ServiceDiscoveryConfig;
import org.apache.knox.gateway.topology.discovery.cm.ClouderaManagerServiceDiscoveryMessages;
import org.apache.knox.gateway.topology.discovery.cm.DiscoveryApiClient;
import org.apache.knox.gateway.topology.discovery.cm.monitor.ClusterConfigurationCache;
import org.apache.knox.gateway.topology.discovery.cm.monitor.ServiceConfigurationModel;
import org.apache.knox.gateway.topology.simple.SimpleDescriptor;
import org.apache.knox.gateway.topology.simple.SimpleDescriptorFactory;

public class PollingConfigurationAnalyzer
implements Runnable {
    private static final String COMMAND = "COMMAND";
    private static final String COMMAND_STATUS = "COMMAND_STATUS";
    private static final String STARTED_STATUS = "STARTED";
    private static final String SUCCEEDED_STATUS = "SUCCEEDED";
    private static final String RESTART_COMMAND = "Restart";
    private static final String START_COMMAND = "Start";
    private static final String EVENTS_QUERY_FORMAT = "category==" + ApiEventCategory.AUDIT_EVENT.getValue() + ";attributes.cluster==\"%s\"%s";
    private static final String EVENTS_QUERY_TIMESTAMP_FORMAT = ";timeOccurred=gt=%s";
    private static final long DEFAULT_EVENT_QUERY_DEFAULT_TIMESTAMP_OFFSET = 3600000L;
    private static final int DEFAULT_POLLING_INTERVAL = 60;
    private static final ClouderaManagerServiceDiscoveryMessages log = (ClouderaManagerServiceDiscoveryMessages)MessagesFactory.get(ClouderaManagerServiceDiscoveryMessages.class);
    private static final String FQCN_DELIM = "::";
    private ClusterConfigurationCache configCache;
    private ClusterConfigurationMonitor.ConfigurationChangeListener changeListener;
    private AliasService aliasService;
    private KeystoreService keystoreService;
    private TopologyService topologyService;
    private ClusterConfigurationMonitorService ccms;
    private int interval;
    private final Map<String, DiscoveryApiClient> clients = new ConcurrentHashMap<String, DiscoveryApiClient>();
    private Map<String, String> eventQueryTimestamps = new ConcurrentHashMap<String, String>();
    private long eventQueryDefaultTimestampOffset = 3600000L;
    private boolean isActive;

    PollingConfigurationAnalyzer(ClusterConfigurationCache configCache, AliasService aliasService, KeystoreService keystoreService, ClusterConfigurationMonitor.ConfigurationChangeListener changeListener) {
        this(configCache, aliasService, keystoreService, changeListener, 60);
    }

    PollingConfigurationAnalyzer(ClusterConfigurationCache configCache, AliasService aliasService, KeystoreService keystoreService, ClusterConfigurationMonitor.ConfigurationChangeListener changeListener, int interval) {
        this.configCache = configCache;
        this.aliasService = aliasService;
        this.keystoreService = keystoreService;
        this.changeListener = changeListener;
        this.interval = interval;
    }

    void setInterval(int interval) {
        this.interval = interval;
    }

    void stop() {
        this.isActive = false;
    }

    private void waitFor(long seconds) {
        try {
            Thread.sleep(seconds * 1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void run() {
        log.startedClouderaManagerConfigMonitor(this.interval);
        this.isActive = true;
        while (this.isActive) {
            ArrayList<String> clustersToStopMonitoring = new ArrayList<String>();
            for (Map.Entry<String, List<String>> entry : this.configCache.getClusterNames().entrySet()) {
                String address = entry.getKey();
                for (String clusterName : entry.getValue()) {
                    log.checkingClusterConfiguration(clusterName, address);
                    if (!this.clusterReferencesExist(address, clusterName)) {
                        clustersToStopMonitoring.add(address + FQCN_DELIM + clusterName);
                        continue;
                    }
                    List<StartEvent> relevantEvents = this.getRelevantEvents(address, clusterName);
                    if (relevantEvents.isEmpty()) continue;
                    boolean configHasChanged = false;
                    Map<String, ServiceConfigurationModel> serviceConfigurations = this.configCache.getClusterServiceConfigurations(address, clusterName);
                    ArrayList<String> handledServiceTypes = new ArrayList<String>();
                    for (StartEvent re : relevantEvents) {
                        String serviceType = re.getServiceType();
                        if (!handledServiceTypes.contains(serviceType)) {
                            ServiceConfigurationModel serviceConfig = serviceConfigurations.get(re.getServiceType());
                            if (serviceConfig != null) {
                                ServiceConfigurationModel currentConfig = this.getCurrentServiceConfiguration(address, clusterName, re.getService());
                                if (currentConfig != null) {
                                    log.analyzingCurrentServiceConfiguration(re.getService());
                                    try {
                                        configHasChanged = this.hasConfigurationChanged(serviceConfig, currentConfig);
                                    }
                                    catch (Exception e) {
                                        log.errorAnalyzingCurrentServiceConfiguration(re.getService(), e);
                                    }
                                }
                            } else {
                                log.serviceEnabled(re.getService());
                                configHasChanged = true;
                            }
                            handledServiceTypes.add(serviceType);
                        }
                        if (!configHasChanged) continue;
                        break;
                    }
                    if (!configHasChanged) continue;
                    this.notifyChangeListener(address, clusterName);
                }
            }
            for (String fqcn : clustersToStopMonitoring) {
                String[] parts = fqcn.split(FQCN_DELIM);
                this.stopMonitoring(parts[0], parts[1]);
            }
            clustersToStopMonitoring.clear();
            this.waitFor(this.interval);
        }
        log.stoppedClouderaManagerConfigMonitor();
    }

    private TopologyService getTopologyService() {
        GatewayServices gws;
        if (this.topologyService == null && (gws = GatewayServer.getGatewayServices()) != null) {
            this.topologyService = (TopologyService)gws.getService(ServiceType.TOPOLOGY_SERVICE);
        }
        return this.topologyService;
    }

    private ClusterConfigurationMonitorService getConfigMonitorService() {
        GatewayServices gws;
        if (this.ccms == null && (gws = GatewayServer.getGatewayServices()) != null) {
            this.ccms = (ClusterConfigurationMonitorService)gws.getService(ServiceType.CLUSTER_CONFIGURATION_MONITOR_SERVICE);
        }
        return this.ccms;
    }

    private boolean clusterReferencesExist(String source, String clusterName) {
        boolean remainingClusterRefs = false;
        if (source != null && clusterName != null) {
            TopologyService ts = this.getTopologyService();
            if (ts != null) {
                for (File f : ts.getDescriptors()) {
                    try {
                        SimpleDescriptor sd = SimpleDescriptorFactory.parse((String)f.toPath().toAbsolutePath().toString());
                        if (!source.equals(sd.getDiscoveryAddress()) || !clusterName.equals(sd.getCluster())) continue;
                        remainingClusterRefs = true;
                        break;
                    }
                    catch (IOException iOException) {
                    }
                }
            } else {
                remainingClusterRefs = true;
            }
        }
        return remainingClusterRefs;
    }

    private void stopMonitoring(String source, String clusterName) {
        ClusterConfigurationMonitorService ms = this.getConfigMonitorService();
        if (ms != null) {
            log.stoppingConfigMonitoring(source, clusterName);
            ms.clearCache(source, clusterName);
        }
    }

    private void notifyChangeListener(String source, String clusterName) {
        if (this.changeListener != null) {
            this.changeListener.onConfigurationChange(source, clusterName);
        }
    }

    void setEventQueryTimestamp(String address, String cluster, Instant timestamp) {
        this.eventQueryTimestamps.put(address + ":" + cluster, timestamp.toString());
    }

    private String getEventQueryTimestamp(String address, String cluster) {
        return this.eventQueryTimestamps.get(address + ":" + cluster);
    }

    private DiscoveryApiClient getApiClient(ServiceDiscoveryConfig discoveryConfig) {
        return this.clients.computeIfAbsent(discoveryConfig.getAddress(), c -> new DiscoveryApiClient(discoveryConfig, this.aliasService, this.keystoreService));
    }

    private List<StartEvent> getRelevantEvents(String address, String clusterName) {
        ArrayList<StartEvent> relevantEvents = new ArrayList<StartEvent>();
        String lastTimestamp = this.getEventQueryTimestamp(address, clusterName);
        if (lastTimestamp == null) {
            lastTimestamp = Instant.now().minus(this.eventQueryDefaultTimestampOffset, ChronoUnit.MILLIS).toString();
        }
        log.queryingRestartEventsFromCluster(clusterName, address, lastTimestamp);
        this.setEventQueryTimestamp(address, clusterName, Instant.now());
        List<ApiEvent> events = this.queryEvents(this.getApiClient(this.configCache.getDiscoveryConfig(address, clusterName)), clusterName, lastTimestamp);
        for (ApiEvent event : events) {
            if (!this.isRelevantEvent(event)) continue;
            relevantEvents.add(new StartEvent(event));
        }
        return relevantEvents;
    }

    private boolean isRelevantEvent(ApiEvent event) {
        String status;
        Map<String, Object> attributeMap = this.getAttributeMap(event.getAttributes());
        String command = attributeMap.containsKey(COMMAND) ? (String)((List)attributeMap.get(COMMAND)).get(0) : "";
        String string = status = attributeMap.containsKey(COMMAND_STATUS) ? (String)((List)attributeMap.get(COMMAND_STATUS)).get(0) : "";
        return !(!START_COMMAND.equals(command) && !RESTART_COMMAND.equals(command) || !SUCCEEDED_STATUS.equals(status) && !STARTED_STATUS.equals(status));
    }

    private Map<String, Object> getAttributeMap(List<ApiEventAttribute> attributes) {
        return attributes == null ? Collections.emptyMap() : attributes.stream().collect(Collectors.toMap(ApiEventAttribute::getName, ApiEventAttribute::getValues));
    }

    protected List<ApiEvent> queryEvents(ApiClient client, String clusterName, String since) {
        ArrayList<ApiEvent> events = new ArrayList<ApiEvent>();
        String timeFilter = since != null ? String.format(Locale.ROOT, EVENTS_QUERY_TIMESTAMP_FORMAT, since) : "";
        String queryString = String.format(Locale.ROOT, EVENTS_QUERY_FORMAT, clusterName, timeFilter);
        try {
            ApiEventQueryResult eventsResult = new EventsResourceApi(client).readEvents(Integer.valueOf(20), queryString, Integer.valueOf(0));
            events.addAll(eventsResult.getItems());
        }
        catch (ApiException e) {
            log.clouderaManagerEventsAPIError(e);
        }
        return events;
    }

    protected ServiceConfigurationModel getCurrentServiceConfiguration(String address, String clusterName, String service) {
        ServiceConfigurationModel currentConfig = null;
        log.gettingCurrentClusterConfiguration(service, clusterName, address);
        DiscoveryApiClient apiClient = this.getApiClient(this.configCache.getDiscoveryConfig(address, clusterName));
        ServicesResourceApi api = new ServicesResourceApi((ApiClient)apiClient);
        try {
            ApiServiceConfig svcConfig = api.readServiceConfig(clusterName, service, "full");
            HashMap<ApiRole, ApiConfigList> roleConfigs = new HashMap<ApiRole, ApiConfigList>();
            RolesResourceApi rolesApi = new RolesResourceApi((ApiClient)apiClient);
            ApiRoleList roles = rolesApi.readRoles(clusterName, service, "", "full");
            for (ApiRole role : roles.getItems()) {
                ApiConfigList config = rolesApi.readRoleConfig(clusterName, role.getName(), service, "full");
                roleConfigs.put(role, config);
            }
            currentConfig = new ServiceConfigurationModel(svcConfig, roleConfigs);
        }
        catch (ApiException e) {
            log.clouderaManagerConfigurationAPIError(e);
        }
        return currentConfig;
    }

    private boolean hasConfigurationChanged(ServiceConfigurationModel previous, ServiceConfigurationModel current) {
        boolean hasChanged = false;
        Map<String, String> previousProps = previous.getServiceProps();
        Map<String, String> currentProps = current.getServiceProps();
        for (String name : previousProps.keySet()) {
            String currValue;
            String prevValue = previousProps.get(name);
            if (prevValue.equals(currValue = currentProps.get(name))) continue;
            log.serviceConfigurationPropertyHasChanged(name, prevValue, currValue);
            hasChanged = true;
            break;
        }
        if (!hasChanged) {
            Set<String> previousRoleTypes = previous.getRoleTypes();
            Set<String> currentRoleTypes = current.getRoleTypes();
            block1: for (String roleType : previousRoleTypes) {
                if (!currentRoleTypes.contains(roleType)) {
                    log.roleTypeRemoved(roleType);
                    hasChanged = true;
                    break;
                }
                previousProps = previous.getRoleProps(roleType);
                currentProps = current.getRoleProps(roleType);
                for (String name : previousProps.keySet()) {
                    String prevValue = previousProps.get(name);
                    String currValue = currentProps.get(name);
                    if (currValue == null) {
                        if (prevValue == null || "null".equals(prevValue)) continue;
                        log.roleConfigurationPropertyHasChanged(name, prevValue, "null");
                        hasChanged = true;
                        continue block1;
                    }
                    if (currValue.equals(prevValue)) continue;
                    log.roleConfigurationPropertyHasChanged(name, prevValue, currValue);
                    hasChanged = true;
                    continue block1;
                }
            }
        }
        return hasChanged;
    }

    static final class StartEvent {
        private static final String ATTR_CLUSTER = "CLUSTER";
        private static final String ATTR_SERVICE_TYPE = "SERVICE_TYPE";
        private static final String ATTR_SERVICE = "SERVICE";
        private static List<String> attrsOfInterest = new ArrayList<String>();
        private ApiEvent auditEvent;
        private String clusterName;
        private String serviceType;
        private String service;

        StartEvent(ApiEvent auditEvent) {
            if (ApiEventCategory.AUDIT_EVENT != auditEvent.getCategory()) {
                throw new IllegalArgumentException("Invalid event category " + auditEvent.getCategory().getValue());
            }
            this.auditEvent = auditEvent;
            for (ApiEventAttribute attribute : auditEvent.getAttributes()) {
                if (!attrsOfInterest.contains(attribute.getName())) continue;
                this.setPropertyFromAttribute(attribute);
            }
        }

        String getTimestamp() {
            return this.auditEvent.getTimeOccurred();
        }

        String getClusterName() {
            return this.clusterName;
        }

        String getServiceType() {
            return this.serviceType;
        }

        String getService() {
            return this.service;
        }

        private void setPropertyFromAttribute(ApiEventAttribute attribute) {
            switch (attribute.getName()) {
                case "CLUSTER": {
                    this.clusterName = (String)attribute.getValues().get(0);
                    break;
                }
                case "SERVICE_TYPE": {
                    this.serviceType = (String)attribute.getValues().get(0);
                    break;
                }
                case "SERVICE": {
                    this.service = (String)attribute.getValues().get(0);
                    break;
                }
            }
        }

        static {
            attrsOfInterest.add(ATTR_CLUSTER);
            attrsOfInterest.add(ATTR_SERVICE_TYPE);
            attrsOfInterest.add(ATTR_SERVICE);
        }
    }
}

