/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.util.List;
import org.apache.directory.mavibot.btree.AbstractDeleteResult;
import org.apache.directory.mavibot.btree.BorrowedFromSiblingResult;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.Tuple;

abstract class AbstractBorrowedFromSiblingResult<K, V>
extends AbstractDeleteResult<K, V>
implements BorrowedFromSiblingResult<K, V> {
    private Page<K, V> modifiedSibling;
    protected SiblingPosition position;

    AbstractBorrowedFromSiblingResult(Page<K, V> modifiedPage, Page<K, V> modifiedSibling, Tuple<K, V> removedElement, SiblingPosition position) {
        super(modifiedPage, removedElement);
        this.modifiedSibling = modifiedSibling;
        this.position = position;
    }

    AbstractBorrowedFromSiblingResult(List<Page<K, V>> copiedPages, Page<K, V> modifiedPage, Page<K, V> modifiedSibling, Tuple<K, V> removedElement, SiblingPosition position) {
        super(copiedPages, modifiedPage, removedElement);
        this.modifiedSibling = modifiedSibling;
        this.position = position;
    }

    @Override
    public Page<K, V> getModifiedSibling() {
        return this.modifiedSibling;
    }

    @Override
    public boolean isFromLeft() {
        return this.position == SiblingPosition.LEFT;
    }

    @Override
    public boolean isFromRight() {
        return this.position == SiblingPosition.RIGHT;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n    removed element : ").append(this.getRemovedElement());
        sb.append("\n    modifiedPage : ").append(this.getModifiedPage());
        sb.append("\n    modifiedSibling : ").append(this.getModifiedSibling());
        return sb.toString();
    }

    protected static enum SiblingPosition {
        LEFT,
        RIGHT;

    }
}

