/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.libpam.impl;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.Arrays;
import java.util.List;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.impl.BSDCLibrary;
import org.jvnet.libpam.impl.BSDPasswd;
import org.jvnet.libpam.impl.FreeBSDCLibrary;
import org.jvnet.libpam.impl.FreeBSDPasswd;
import org.jvnet.libpam.impl.LinuxCLibrary;
import org.jvnet.libpam.impl.LinuxPasswd;
import org.jvnet.libpam.impl.SolarisCLibrary;
import org.jvnet.libpam.impl.SolarisPasswd;

public interface CLibrary
extends Library {
    public static final CLibrary libc = Instance.access$000();

    public Pointer calloc(int var1, int var2);

    public Pointer strdup(String var1);

    public passwd getpwnam(String var1);

    public int getpwnam_r(String var1, Pointer var2, Pointer var3, int var4, PointerByReference var5);

    public int getgrouplist(String var1, int var2, Memory var3, IntByReference var4);

    public int _getgroupsbymember(String var1, Memory var2, int var3, int var4);

    public group getgrgid(int var1);

    public group getgrnam(String var1);

    public static class Instance {
        private static CLibrary init() {
            if (Platform.isMac() || Platform.isOpenBSD()) {
                return (CLibrary)Native.loadLibrary((String)"c", BSDCLibrary.class);
            }
            if (Platform.isFreeBSD()) {
                return (CLibrary)Native.loadLibrary((String)"c", FreeBSDCLibrary.class);
            }
            if (Platform.isSolaris()) {
                return (CLibrary)Native.loadLibrary((String)"c", SolarisCLibrary.class);
            }
            if (Platform.isLinux()) {
                return (CLibrary)Native.loadLibrary((String)"c", LinuxCLibrary.class);
            }
            return (CLibrary)Native.loadLibrary((String)"c", CLibrary.class);
        }

        static /* synthetic */ CLibrary access$000() {
            return Instance.init();
        }
    }

    public static class group
    extends Structure {
        public String gr_name;

        protected List getFieldOrder() {
            return Arrays.asList("gr_name");
        }
    }

    public static class passwd
    extends Structure {
        public String pw_name;
        public String pw_passwd;
        public int pw_uid;
        public int pw_gid;

        public passwd() {
        }

        public passwd(Pointer p) {
            super(p);
        }

        public static passwd loadPasswd(String userName) throws PAMException {
            Memory mem = new Memory(4352L);
            Pointer structBase = mem.share(0L);
            Pointer bufferBase = mem.share(256L);
            PointerByReference pbr = new PointerByReference();
            int result = libc.getpwnam_r(userName, structBase, bufferBase, 4096, pbr);
            Pointer resultPointer = pbr.getValue();
            if (resultPointer == null) {
                if (result == 0) {
                    throw new PAMException("No user information is available");
                }
                throw new PAMException("Failed to retrieve user information (Error: " + result + ")");
            }
            passwd res = libc instanceof BSDCLibrary ? new BSDPasswd((Pointer)mem) : (libc instanceof FreeBSDCLibrary ? new FreeBSDPasswd((Pointer)mem) : (libc instanceof LinuxCLibrary ? new LinuxPasswd((Pointer)mem) : (libc instanceof SolarisCLibrary ? new SolarisPasswd((Pointer)mem) : new passwd((Pointer)mem))));
            res.read();
            return res;
        }

        public String getPwName() {
            return this.pw_name;
        }

        public String getPwPasswd() {
            return this.pw_passwd;
        }

        public int getPwUid() {
            return this.pw_uid;
        }

        public int getPwGid() {
            return this.pw_gid;
        }

        public String getPwGecos() {
            return null;
        }

        public String getPwDir() {
            return null;
        }

        public String getPwShell() {
            return null;
        }

        protected List getFieldOrder() {
            return Arrays.asList("pw_name", "pw_passwd", "pw_uid", "pw_gid");
        }
    }
}

