/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.vault.VaultException;
import org.springframework.vault.authentication.CredentialSupplier;

public class ResourceCredentialSupplier
implements CredentialSupplier {
    private final Resource resource;

    public ResourceCredentialSupplier(String path) {
        this((Resource)new FileSystemResource(path));
    }

    public ResourceCredentialSupplier(File file) {
        this((Resource)new FileSystemResource(file));
    }

    public ResourceCredentialSupplier(Resource resource) {
        Assert.isTrue((boolean)resource.exists(), () -> String.format("Resource %s does not exist", resource));
        this.resource = resource;
    }

    @Override
    public String get() {
        try {
            return new String(ResourceCredentialSupplier.readToken(this.resource), StandardCharsets.US_ASCII);
        }
        catch (IOException e) {
            throw new VaultException(String.format("Credential retrieval from %s failed", this.resource), e);
        }
    }

    private static byte[] readToken(Resource resource) throws IOException {
        Assert.notNull((Object)resource, (String)"Resource must not be null");
        try (InputStream is = resource.getInputStream();){
            byte[] byArray = StreamUtils.copyToByteArray((InputStream)is);
            return byArray;
        }
    }
}

