/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xsom.impl.scd;

import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSDeclaration;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.impl.UName;
import com.sun.xml.xsom.impl.scd.Axis;
import com.sun.xml.xsom.impl.scd.Iterators;
import java.util.Iterator;

public abstract class Step<T extends XSComponent> {
    public final Axis<? extends T> axis;
    int predicate = -1;

    protected Step(Axis<? extends T> axis) {
        this.axis = axis;
    }

    protected abstract Iterator<? extends T> filter(Iterator<? extends T> var1);

    public final Iterator<T> evaluate(Iterator<XSComponent> nodeSet) {
        Iterators.ReadOnly r = new Iterators.Map<T, XSComponent>(nodeSet){

            @Override
            protected Iterator<? extends T> apply(XSComponent contextNode) {
                return Step.this.filter(Step.this.axis.iterator(contextNode));
            }
        };
        r = new Iterators.Unique(r);
        if (this.predicate >= 0) {
            XSComponent item = null;
            for (int i = this.predicate; i > 0; --i) {
                if (!r.hasNext()) {
                    return Iterators.empty();
                }
                item = (XSComponent)r.next();
            }
            return new Iterators.Singleton<Object>(item);
        }
        return r;
    }

    static final class Schema
    extends Filtered<XSSchema> {
        private final String uri;

        public Schema(Axis<XSSchema> axis, String uri) {
            super(axis);
            this.uri = uri;
        }

        @Override
        protected boolean match(XSSchema d) {
            return d.getTargetNamespace().equals(this.uri);
        }
    }

    static final class Facet
    extends Filtered<XSFacet> {
        private final String name;

        public Facet(Axis<XSFacet> axis, String facetName) {
            super(axis);
            this.name = facetName;
        }

        @Override
        protected boolean match(XSFacet f) {
            return f.getName().equals(this.name);
        }
    }

    static final class AnonymousType
    extends Filtered<XSType> {
        public AnonymousType(Axis<? extends XSType> axis) {
            super(axis);
        }

        @Override
        protected boolean match(XSType node) {
            return node.isLocal();
        }
    }

    static final class Named
    extends Filtered<XSDeclaration> {
        private final String nsUri;
        private final String localName;

        public Named(Axis<? extends XSDeclaration> axis, UName n) {
            this(axis, n.getNamespaceURI(), n.getName());
        }

        public Named(Axis<? extends XSDeclaration> axis, String nsUri, String localName) {
            super(axis);
            this.nsUri = nsUri;
            this.localName = localName;
        }

        @Override
        protected boolean match(XSDeclaration d) {
            return d.getName().equals(this.localName) && d.getTargetNamespace().equals(this.nsUri);
        }
    }

    private static abstract class Filtered<T extends XSComponent>
    extends Step<T> {
        protected Filtered(Axis<? extends T> axis) {
            super(axis);
        }

        @Override
        protected Iterator<T> filter(Iterator<? extends T> base) {
            return new Iterators.Filter<T>(base){

                @Override
                protected boolean matches(T d) {
                    return Filtered.this.match(d);
                }
            };
        }

        protected abstract boolean match(T var1);
    }

    static final class Any
    extends Step<XSComponent> {
        public Any(Axis<? extends XSComponent> axis) {
            super(axis);
        }

        @Override
        protected Iterator<? extends XSComponent> filter(Iterator<? extends XSComponent> base) {
            return base;
        }
    }
}

