/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.unboundidds.monitors.ExtendedOperationResultCodeInfo;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.ldap.sdk.unboundidds.monitors.OperationResultCodeInfo;
import com.unboundid.ldap.sdk.unboundidds.monitors.ResultCodeInfo;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ResultCodeMonitorEntry
extends MonitorEntry {
    @NotNull
    static final String RESULT_CODE_MONITOR_OC = "ds-ldap-result-codes-monitor-entry";
    private static final long serialVersionUID = -963682306039266913L;
    @NotNull
    private final ExtendedOperationResultCodeInfo extendedOperationResultCodeInfo;
    @NotNull
    private final OperationResultCodeInfo addOperationResultCodeInfo;
    @NotNull
    private final OperationResultCodeInfo allOperationsResultCodeInfo = new OperationResultCodeInfo(this, null, "all-ops-");
    @NotNull
    private final OperationResultCodeInfo bindOperationResultCodeInfo;
    @NotNull
    private final OperationResultCodeInfo compareOperationResultCodeInfo;
    @NotNull
    private final OperationResultCodeInfo deleteOperationResultCodeInfo;
    @NotNull
    private final OperationResultCodeInfo modifyOperationResultCodeInfo;
    @NotNull
    private final OperationResultCodeInfo modifyDNOperationResultCodeInfo;
    @NotNull
    private final OperationResultCodeInfo searchOperationResultCodeInfo;

    public ResultCodeMonitorEntry(@NotNull Entry entry) {
        super(entry);
        this.addOperationResultCodeInfo = new OperationResultCodeInfo(this, OperationType.ADD, "add-op-");
        this.bindOperationResultCodeInfo = new OperationResultCodeInfo(this, OperationType.BIND, "bind-op-");
        this.compareOperationResultCodeInfo = new OperationResultCodeInfo(this, OperationType.COMPARE, "compare-op-");
        this.deleteOperationResultCodeInfo = new OperationResultCodeInfo(this, OperationType.DELETE, "delete-op-");
        this.extendedOperationResultCodeInfo = new ExtendedOperationResultCodeInfo(this);
        this.modifyOperationResultCodeInfo = new OperationResultCodeInfo(this, OperationType.MODIFY, "modify-op-");
        this.modifyDNOperationResultCodeInfo = new OperationResultCodeInfo(this, OperationType.MODIFY_DN, "modifydn-op-");
        this.searchOperationResultCodeInfo = new OperationResultCodeInfo(this, OperationType.SEARCH, "search-op-");
    }

    @NotNull
    public OperationResultCodeInfo getAllOperationsResultCodeInfo() {
        return this.allOperationsResultCodeInfo;
    }

    @NotNull
    public OperationResultCodeInfo getAddOperationResultCodeInfo() {
        return this.addOperationResultCodeInfo;
    }

    @NotNull
    public OperationResultCodeInfo getBindOperationResultCodeInfo() {
        return this.bindOperationResultCodeInfo;
    }

    @NotNull
    public OperationResultCodeInfo getCompareOperationResultCodeInfo() {
        return this.compareOperationResultCodeInfo;
    }

    @NotNull
    public OperationResultCodeInfo getDeleteOperationResultCodeInfo() {
        return this.deleteOperationResultCodeInfo;
    }

    @NotNull
    public ExtendedOperationResultCodeInfo getExtendedOperationResultCodeInfo() {
        return this.extendedOperationResultCodeInfo;
    }

    @NotNull
    public OperationResultCodeInfo getModifyOperationResultCodeInfo() {
        return this.modifyOperationResultCodeInfo;
    }

    @NotNull
    public OperationResultCodeInfo getModifyDNOperationResultCodeInfo() {
        return this.modifyDNOperationResultCodeInfo;
    }

    @NotNull
    public OperationResultCodeInfo getSearchOperationResultCodeInfo() {
        return this.searchOperationResultCodeInfo;
    }

    @Override
    @NotNull
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_RESULT_CODE_MONITOR_DISPNAME.get();
    }

    @Override
    @NotNull
    public String getMonitorDescription() {
        return MonitorMessages.INFO_RESULT_CODE_MONITOR_DESC.get();
    }

    @Override
    @NotNull
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>(StaticUtils.computeMapCapacity(100));
        ResultCodeMonitorEntry.addAttrs(attrs, this.allOperationsResultCodeInfo, "all-ops-");
        ResultCodeMonitorEntry.addAttrs(attrs, this.addOperationResultCodeInfo, "add-op-");
        ResultCodeMonitorEntry.addAttrs(attrs, this.bindOperationResultCodeInfo, "bind-op-");
        ResultCodeMonitorEntry.addAttrs(attrs, this.compareOperationResultCodeInfo, "compare-op-");
        ResultCodeMonitorEntry.addAttrs(attrs, this.deleteOperationResultCodeInfo, "delete-op-");
        ResultCodeMonitorEntry.addAttrs(attrs, this.extendedOperationResultCodeInfo);
        ResultCodeMonitorEntry.addAttrs(attrs, this.modifyOperationResultCodeInfo, "modify-op-");
        ResultCodeMonitorEntry.addAttrs(attrs, this.modifyDNOperationResultCodeInfo, "modifydn-op-");
        ResultCodeMonitorEntry.addAttrs(attrs, this.searchOperationResultCodeInfo, "search-op-");
        return Collections.unmodifiableMap(attrs);
    }

    private static void addAttrs(@NotNull LinkedHashMap<String, MonitorAttribute> attrs, @NotNull OperationResultCodeInfo resultCodeInfo, @NotNull String attrPrefix) {
        Double failedPercent;
        Long failedCount;
        String opName;
        if (resultCodeInfo.getOperationType() == null) {
            opName = MonitorMessages.INFO_RESULT_CODE_OP_NAME_ALL.get();
        } else {
            switch (resultCodeInfo.getOperationType()) {
                case ADD: {
                    opName = MonitorMessages.INFO_RESULT_CODE_OP_NAME_ADD.get();
                    break;
                }
                case BIND: {
                    opName = MonitorMessages.INFO_RESULT_CODE_OP_NAME_BIND.get();
                    break;
                }
                case COMPARE: {
                    opName = MonitorMessages.INFO_RESULT_CODE_OP_NAME_COMPARE.get();
                    break;
                }
                case DELETE: {
                    opName = MonitorMessages.INFO_RESULT_CODE_OP_NAME_DELETE.get();
                    break;
                }
                case MODIFY: {
                    opName = MonitorMessages.INFO_RESULT_CODE_OP_NAME_MODIFY.get();
                    break;
                }
                case MODIFY_DN: {
                    opName = MonitorMessages.INFO_RESULT_CODE_OP_NAME_MODIFY_DN.get();
                    break;
                }
                case SEARCH: {
                    opName = MonitorMessages.INFO_RESULT_CODE_OP_NAME_SEARCH.get();
                    break;
                }
                default: {
                    opName = "Unknown";
                }
            }
        }
        String lowerOpName = StaticUtils.toLowerCase(opName);
        Long totalCount = resultCodeInfo.getTotalCount();
        if (totalCount != null) {
            ResultCodeMonitorEntry.addMonitorAttribute(attrs, attrPrefix + "total-count", MonitorMessages.INFO_RESULT_CODE_DISPNAME_TOTAL_COUNT.get(opName), MonitorMessages.INFO_RESULT_CODE_DESC_TOTAL_COUNT.get(lowerOpName), totalCount);
        }
        if ((failedCount = resultCodeInfo.getFailedCount()) != null) {
            ResultCodeMonitorEntry.addMonitorAttribute(attrs, attrPrefix + "failed-count", MonitorMessages.INFO_RESULT_CODE_DISPNAME_FAILED_COUNT.get(opName), MonitorMessages.INFO_RESULT_CODE_DESC_FAILED_COUNT.get(lowerOpName), failedCount);
        }
        if ((failedPercent = resultCodeInfo.getFailedPercent()) != null) {
            ResultCodeMonitorEntry.addMonitorAttribute(attrs, attrPrefix + "failed-percent", MonitorMessages.INFO_RESULT_CODE_DISPNAME_FAILED_PERCENT.get(opName), MonitorMessages.INFO_RESULT_CODE_DESC_FAILED_PERCENT.get(lowerOpName), failedPercent);
        }
        for (ResultCodeInfo i : resultCodeInfo.getResultCodeInfoMap().values()) {
            ResultCodeMonitorEntry.addMonitorAttribute(attrs, attrPrefix + i.intValue() + "-name", MonitorMessages.INFO_RESULT_CODE_DISPNAME_RC_NAME.get(opName, i.intValue()), MonitorMessages.INFO_RESULT_CODE_DESC_RC_NAME.get(lowerOpName, i.intValue()), i.getName());
            ResultCodeMonitorEntry.addMonitorAttribute(attrs, attrPrefix + i.intValue() + "-count", MonitorMessages.INFO_RESULT_CODE_DISPNAME_RC_COUNT.get(opName, i.intValue()), MonitorMessages.INFO_RESULT_CODE_DESC_RC_COUNT.get(lowerOpName, i.intValue()), i.getCount());
            ResultCodeMonitorEntry.addMonitorAttribute(attrs, attrPrefix + i.intValue() + "-percent", MonitorMessages.INFO_RESULT_CODE_DISPNAME_RC_PERCENT.get(opName, i.intValue()), MonitorMessages.INFO_RESULT_CODE_DESC_RC_PERCENT.get(lowerOpName, i.intValue()), i.getPercent());
            ResultCodeMonitorEntry.addMonitorAttribute(attrs, attrPrefix + i.intValue() + "-average-response-time-millis", MonitorMessages.INFO_RESULT_CODE_DISPNAME_RC_AVG_RT.get(opName, i.intValue()), MonitorMessages.INFO_RESULT_CODE_DESC_RC_AVG_RT.get(lowerOpName, i.intValue()), i.getAverageResponseTimeMillis());
            ResultCodeMonitorEntry.addMonitorAttribute(attrs, attrPrefix + i.intValue() + "-total-response-time-millis", MonitorMessages.INFO_RESULT_CODE_DISPNAME_RC_TOTAL_RT.get(opName, i.intValue()), MonitorMessages.INFO_RESULT_CODE_DESC_RC_TOTAL_RT.get(lowerOpName, i.intValue()), i.getTotalResponseTimeMillis());
        }
    }

    private static void addAttrs(@NotNull LinkedHashMap<String, MonitorAttribute> attrs, @NotNull ExtendedOperationResultCodeInfo resultCodeInfo) {
        Double failedPercent;
        Long failedCount;
        String opName = MonitorMessages.INFO_RESULT_CODE_OP_NAME_EXTENDED.get();
        String lowerOpName = StaticUtils.toLowerCase(opName);
        Long totalCount = resultCodeInfo.getTotalCount();
        if (totalCount != null) {
            ResultCodeMonitorEntry.addMonitorAttribute(attrs, "extended-op-total-count", MonitorMessages.INFO_RESULT_CODE_DISPNAME_TOTAL_COUNT.get(opName), MonitorMessages.INFO_RESULT_CODE_DESC_TOTAL_COUNT.get(lowerOpName), totalCount);
        }
        if ((failedCount = resultCodeInfo.getFailedCount()) != null) {
            ResultCodeMonitorEntry.addMonitorAttribute(attrs, "extended-op-failed-count", MonitorMessages.INFO_RESULT_CODE_DISPNAME_FAILED_COUNT.get(opName), MonitorMessages.INFO_RESULT_CODE_DESC_FAILED_COUNT.get(lowerOpName), failedCount);
        }
        if ((failedPercent = resultCodeInfo.getFailedPercent()) != null) {
            ResultCodeMonitorEntry.addMonitorAttribute(attrs, "extended-op-failed-percent", MonitorMessages.INFO_RESULT_CODE_DISPNAME_FAILED_PERCENT.get(opName), MonitorMessages.INFO_RESULT_CODE_DESC_FAILED_PERCENT.get(lowerOpName), failedPercent);
        }
        for (String oid : resultCodeInfo.getExtendedRequestNamesByOID().keySet()) {
            Map<Integer, ResultCodeInfo> rcInfoMap;
            Double percent;
            Long failed;
            Long total;
            String prefix = "extended-op-" + oid.replace('.', '-') + '-';
            String name = resultCodeInfo.getExtendedRequestNamesByOID().get(oid);
            if (name != null) {
                ResultCodeMonitorEntry.addMonitorAttribute(attrs, prefix + "name", MonitorMessages.INFO_RESULT_CODE_DISPNAME_EXTOP_NAME.get(oid), MonitorMessages.INFO_RESULT_CODE_DESC_EXTOP_NAME.get(oid), name);
            }
            if ((total = resultCodeInfo.getTotalCountsByOID().get(oid)) != null) {
                ResultCodeMonitorEntry.addMonitorAttribute(attrs, prefix + "total-count", MonitorMessages.INFO_RESULT_CODE_DISPNAME_EXTOP_TOTAL_COUNT.get(oid), MonitorMessages.INFO_RESULT_CODE_DESC_EXTOP_TOTAL_COUNT.get(oid), total);
            }
            if ((failed = resultCodeInfo.getFailedCountsByOID().get(oid)) != null) {
                ResultCodeMonitorEntry.addMonitorAttribute(attrs, prefix + "failed-count", MonitorMessages.INFO_RESULT_CODE_DISPNAME_EXTOP_FAILED_COUNT.get(oid), MonitorMessages.INFO_RESULT_CODE_DESC_EXTOP_FAILED_COUNT.get(oid), failed);
            }
            if ((percent = resultCodeInfo.getFailedPercentsByOID().get(oid)) != null) {
                ResultCodeMonitorEntry.addMonitorAttribute(attrs, prefix + "failed-percent", MonitorMessages.INFO_RESULT_CODE_DISPNAME_EXTOP_FAILED_PERCENT.get(oid), MonitorMessages.INFO_RESULT_CODE_DESC_EXTOP_FAILED_PERCENT.get(oid), percent);
            }
            if ((rcInfoMap = resultCodeInfo.getResultCodeInfoMap().get(oid)) == null) continue;
            for (ResultCodeInfo rcInfo : rcInfoMap.values()) {
                int intValue = rcInfo.intValue();
                String rcPrefix = prefix + intValue + '-';
                ResultCodeMonitorEntry.addMonitorAttribute(attrs, rcPrefix + "name", MonitorMessages.INFO_RESULT_CODE_DISPNAME_EXTOP_RC_NAME.get(oid, intValue), MonitorMessages.INFO_RESULT_CODE_DESC_EXTOP_RC_NAME.get(oid, intValue), rcInfo.getName());
                ResultCodeMonitorEntry.addMonitorAttribute(attrs, rcPrefix + "count", MonitorMessages.INFO_RESULT_CODE_DISPNAME_EXTOP_RC_COUNT.get(oid, intValue), MonitorMessages.INFO_RESULT_CODE_DESC_EXTOP_RC_COUNT.get(oid, intValue), rcInfo.getCount());
                ResultCodeMonitorEntry.addMonitorAttribute(attrs, rcPrefix + "percent", MonitorMessages.INFO_RESULT_CODE_DISPNAME_EXTOP_RC_PERCENT.get(oid, intValue), MonitorMessages.INFO_RESULT_CODE_DESC_EXTOP_RC_PERCENT.get(oid, intValue), rcInfo.getPercent());
                ResultCodeMonitorEntry.addMonitorAttribute(attrs, rcPrefix + "average-response-time-millis", MonitorMessages.INFO_RESULT_CODE_DISPNAME_EXTOP_RC_AVG_RT.get(oid, intValue), MonitorMessages.INFO_RESULT_CODE_DESC_EXTOP_RC_AVG_RT.get(oid, intValue), rcInfo.getAverageResponseTimeMillis());
                ResultCodeMonitorEntry.addMonitorAttribute(attrs, rcPrefix + "total-response-time-millis", MonitorMessages.INFO_RESULT_CODE_DISPNAME_EXTOP_RC_TOTAL_RT.get(oid, intValue), MonitorMessages.INFO_RESULT_CODE_DESC_EXTOP_RC_TOTAL_RT.get(oid, intValue), rcInfo.getTotalResponseTimeMillis());
            }
        }
    }
}

