/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.transformations;

import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.transformations.LDIFChangeRecordTransformation;
import com.unboundid.ldif.LDIFChangeRecord;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ExcludeChangeTypeTransformation
implements LDIFChangeRecordTransformation,
Serializable {
    private static final long serialVersionUID = -6927917616913251572L;
    @NotNull
    private final Set<ChangeType> excludedChangeTypes;

    public ExcludeChangeTypeTransformation(ChangeType ... changeTypes) {
        this(StaticUtils.toList(changeTypes));
    }

    public ExcludeChangeTypeTransformation(@Nullable Collection<ChangeType> changeTypes) {
        if (changeTypes == null) {
            this.excludedChangeTypes = Collections.emptySet();
        } else {
            EnumSet<ChangeType> ctSet = EnumSet.noneOf(ChangeType.class);
            ctSet.addAll(changeTypes);
            this.excludedChangeTypes = Collections.unmodifiableSet(ctSet);
        }
    }

    @Override
    @Nullable
    public LDIFChangeRecord transformChangeRecord(@NotNull LDIFChangeRecord changeRecord) {
        if (this.excludedChangeTypes.contains((Object)changeRecord.getChangeType())) {
            return null;
        }
        return changeRecord;
    }

    @Override
    @Nullable
    public LDIFChangeRecord translate(@NotNull LDIFChangeRecord original, long firstLineNumber) {
        if (this.excludedChangeTypes.contains((Object)original.getChangeType())) {
            return null;
        }
        return original;
    }

    @Override
    @Nullable
    public LDIFChangeRecord translateChangeRecordToWrite(@NotNull LDIFChangeRecord original) {
        if (this.excludedChangeTypes.contains((Object)original.getChangeType())) {
            return null;
        }
        return original;
    }
}

