/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import java.net.IDN;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public enum DefaultHostnameVerifier implements HostnameVerifier
{
    INSTANCE;

    private static final int TYPE_DNS_NAME = 2;
    private static final int TYPE_IP_ADDRESS = 7;
    static Comparator<String> HOSTNAME_PATTERN_COMPARATOR;
    private final Logger logger = Loggers.getLogger(this.getClass());

    @Override
    public boolean verify(String hostname, SSLSession session) {
        String commonName;
        boolean result;
        LdapName DN;
        Collection<List<?>> subjectAltNames;
        X509Certificate serverCert;
        String canonicalHostname;
        if (hostname.startsWith("[") && hostname.endsWith("]")) {
            canonicalHostname = hostname.substring(1, hostname.length() - 1);
        } else {
            try {
                canonicalHostname = IDN.toASCII(hostname);
                this.logger.debug("Canonical host name for {} is {}", new Object[]{hostname, canonicalHostname});
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("Hostname {} is invalid", new Object[]{hostname, e});
                return false;
            }
        }
        try {
            Certificate[] peerCerts = session.getPeerCertificates();
            if (peerCerts == null || peerCerts.length == 0) {
                this.logger.warn("No certificates found for hostname {}", new Object[]{hostname});
                return false;
            }
            if (!(peerCerts[0] instanceof X509Certificate)) {
                this.logger.warn("Unable to obtain X509Certificate for hostname {}. Certificate type was {}", new Object[]{hostname, peerCerts[0].getClass().getName()});
                return false;
            }
            serverCert = (X509Certificate)peerCerts[0];
        }
        catch (SSLPeerUnverifiedException e) {
            this.logger.warn("Unable to parse X509Certificate for hostname {}", new Object[]{hostname, e});
            return false;
        }
        try {
            subjectAltNames = serverCert.getSubjectAlternativeNames();
            if (subjectAltNames == null) {
                subjectAltNames = Collections.emptyList();
            }
        }
        catch (CertificateParsingException e) {
            this.logger.warn("Unable to parse certificates for hostname {}", new Object[]{hostname, e});
            return false;
        }
        boolean anyDnsSan = false;
        for (List<?> sanItem : subjectAltNames) {
            Object sanType;
            if (sanItem.size() != 2 || (sanType = (Integer)sanItem.get(0)) == null || (Integer)sanType != 7 && (Integer)sanType != 2) continue;
            String san = (String)sanItem.get(1);
            if ((Integer)sanType == 7 && san.startsWith("*")) continue;
            anyDnsSan |= (Integer)sanType == 2;
            if (!this.verifyHostName(canonicalHostname, san)) continue;
            this.logger.debug("Server name validation pass for {}, subjectAltName {}", new Object[]{hostname, san});
            return true;
        }
        if (anyDnsSan) {
            this.logger.debug("Server name validation failed: certificate for host {} dNSName entries subjectAltName, but none of them match. Assuming server name validation failed", new Object[]{hostname});
            return false;
        }
        try {
            DN = new LdapName(serverCert.getSubjectX500Principal().getName("RFC2253"));
        }
        catch (InvalidNameException e) {
            this.logger.warn("Server name validation failed: unable to extract common name from X509Certificate for hostname {}", new Object[]{hostname, e});
            return false;
        }
        ArrayList<String> commonNames = new ArrayList<String>(1);
        for (Rdn rdn : DN.getRdns()) {
            if (!"CN".equals(rdn.getType())) continue;
            commonNames.add((String)rdn.getValue());
        }
        if (commonNames.isEmpty()) {
            this.logger.warn("Server name validation failed: certificate for hostname {} has no DNS subjectAltNames, and it CommonName is missing as well", new Object[]{hostname});
            return false;
        }
        if (commonNames.size() > 1) {
            commonNames.sort(HOSTNAME_PATTERN_COMPARATOR);
        }
        if (!(result = this.verifyHostName(canonicalHostname, commonName = (String)commonNames.get(commonNames.size() - 1)))) {
            this.logger.warn("Server name validation failed: hostname {} does not match common name {}", new Object[]{hostname, commonName});
        }
        return result;
    }

    public boolean verifyHostName(@Nullable String hostname, @Nullable String pattern) {
        if (hostname == null || pattern == null) {
            return false;
        }
        int lastStar = pattern.lastIndexOf(42);
        if (lastStar == -1) {
            return hostname.equalsIgnoreCase(pattern);
        }
        if (lastStar > 0) {
            return false;
        }
        if (pattern.indexOf(46) == -1) {
            return false;
        }
        if (hostname.length() < pattern.length() - 1) {
            return false;
        }
        boolean ignoreCase = true;
        int toffset = hostname.length() - pattern.length() + 1;
        if (hostname.lastIndexOf(46, toffset - 1) >= 0) {
            return false;
        }
        return hostname.regionMatches(true, toffset, pattern, 1, pattern.length() - 1);
    }

    static {
        HOSTNAME_PATTERN_COMPARATOR = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int l2;
                int s2;
                int d2;
                int d1 = this.countChars(o1, '.');
                if (d1 != (d2 = this.countChars(o2, '.'))) {
                    return d1 > d2 ? 1 : -1;
                }
                int s1 = this.countChars(o1, '*');
                if (s1 != (s2 = this.countChars(o2, '*'))) {
                    return s1 < s2 ? 1 : -1;
                }
                int l1 = o1.length();
                if (l1 != (l2 = o2.length())) {
                    return l1 > l2 ? 1 : -1;
                }
                return 0;
            }

            private int countChars(String value, char ch) {
                int count = 0;
                int pos = -1;
                while ((pos = value.indexOf(ch, pos + 1)) != -1) {
                    ++count;
                }
                return count;
            }
        };
    }
}

