/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.opensearch.events;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.mail.Flags;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.events.Event;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.Group;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.opensearch.events.OpenSearchListeningMessageSearchIndex;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DisabledListeningMessageSearchIndex
extends ListeningMessageSearchIndex {
    private static final Group GROUP = new OpenSearchListeningMessageSearchIndex.OpenSearchListeningMessageSearchIndexGroup();
    private static final ImmutableList<Class<? extends Event>> INTERESTING_EVENTS = ImmutableList.of(MailboxEvents.Added.class, MailboxEvents.Expunged.class, MailboxEvents.FlagsUpdated.class, MailboxEvents.MailboxDeletion.class);
    private final EventDeadLetters eventDeadLetters;
    private final SessionProvider sessionProvider;
    private final MailboxSessionMapperFactory factory;

    @Inject
    public DisabledListeningMessageSearchIndex(MailboxSessionMapperFactory factory, Set<ListeningMessageSearchIndex.SearchOverride> searchOverrides, EventDeadLetters eventDeadLetters, SessionProvider sessionProvider) {
        super(factory, searchOverrides, sessionProvider);
        this.eventDeadLetters = eventDeadLetters;
        this.sessionProvider = sessionProvider;
        this.factory = factory;
    }

    public void postReindexing() {
    }

    public boolean isHandling(Event event) {
        return INTERESTING_EVENTS.contains((Object)event.getClass());
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public EnumSet<MailboxManager.SearchCapabilities> getSupportedCapabilities(EnumSet<MailboxManager.MessageCapabilities> messageCapabilities) {
        return EnumSet.of(MailboxManager.SearchCapabilities.MultimailboxSearch, new MailboxManager.SearchCapabilities[]{MailboxManager.SearchCapabilities.Text, MailboxManager.SearchCapabilities.FullText, MailboxManager.SearchCapabilities.Attachment, MailboxManager.SearchCapabilities.AttachmentFileName, MailboxManager.SearchCapabilities.PartialEmailMatch});
    }

    public Mono<Void> reactiveEvent(Event event) {
        MailboxSession systemSession = this.sessionProvider.createSystemSession(event.getUsername());
        return this.handleMailboxEvent(event).then(Mono.fromRunnable(() -> this.factory.endProcessingRequest(systemSession)));
    }

    private Mono<Void> handleMailboxEvent(Event event) {
        if (event instanceof MailboxEvents.Added || event instanceof MailboxEvents.Expunged || event instanceof MailboxEvents.FlagsUpdated || event instanceof MailboxEvents.MailboxDeletion) {
            return this.eventDeadLetters.store(GROUP, event).then();
        }
        return Mono.empty();
    }

    protected Flux<MessageUid> doSearch(MailboxSession session, Mailbox mailbox, SearchQuery searchQuery) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"'session' is mandatory");
        return Flux.error((Throwable)new NotImplementedException());
    }

    public Flux<MessageId> search(MailboxSession session, Collection<MailboxId> mailboxIds, SearchQuery searchQuery, long limit) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"'session' is mandatory");
        return Flux.error((Throwable)new NotImplementedException());
    }

    public Mono<Void> add(MailboxSession session, Mailbox mailbox, MailboxMessage message) {
        return Mono.error((Throwable)new NotImplementedException());
    }

    public Mono<Void> delete(MailboxSession session, MailboxId mailboxId, Collection<MessageUid> expungedUids) {
        return Mono.error((Throwable)new NotImplementedException());
    }

    public Mono<Void> deleteAll(MailboxSession session, MailboxId mailboxId) {
        return Mono.error((Throwable)new NotImplementedException());
    }

    public Mono<Void> update(MailboxSession session, MailboxId mailboxId, List<UpdatedFlags> updatedFlagsList) {
        return Mono.error((Throwable)new NotImplementedException());
    }

    public Mono<Flags> retrieveIndexedFlags(Mailbox mailbox, MessageUid uid) {
        return Mono.error((Throwable)new NotImplementedException());
    }
}

