/*
 * Decompiled with CFR 0.152.
 */
package spark.embeddedserver;

public interface VirtualThreadAware {
    default public void useVThread(boolean useVThread) {
    }

    default public boolean useVThread() {
        return false;
    }

    public static class Proxy
    implements VirtualThreadAware {
        protected VirtualThreadAware underlying;

        public Proxy(VirtualThreadAware underlying) {
            this.underlying = underlying;
        }

        @Override
        public void useVThread(boolean useVThread) {
            this.underlying.useVThread(useVThread);
        }

        @Override
        public boolean useVThread() {
            return this.underlying.useVThread();
        }
    }

    public static class Base
    implements VirtualThreadAware {
        protected boolean useVThread = false;

        @Override
        public void useVThread(boolean useVThread) {
            this.useVThread = useVThread;
        }

        @Override
        public boolean useVThread() {
            return this.useVThread;
        }
    }
}

