/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Owner
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Owner> {
    @Nonnull
    private final List<String> backendRoles;
    @Nonnull
    private final List<String> customAttributeNames;
    @Nonnull
    private final String name;
    @Nonnull
    private final List<String> roles;
    @Nullable
    private final String userRequestedTenant;
    public static final JsonpDeserializer<Owner> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Owner::setupOwnerDeserializer);

    private Owner(Builder builder) {
        this.backendRoles = ApiTypeHelper.unmodifiable(builder.backendRoles);
        this.customAttributeNames = ApiTypeHelper.unmodifiable(builder.customAttributeNames);
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.roles = ApiTypeHelper.unmodifiable(builder.roles);
        this.userRequestedTenant = builder.userRequestedTenant;
    }

    public static Owner of(Function<Builder, ObjectBuilder<Owner>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> backendRoles() {
        return this.backendRoles;
    }

    @Nonnull
    public final List<String> customAttributeNames() {
        return this.customAttributeNames;
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    @Nonnull
    public final List<String> roles() {
        return this.roles;
    }

    @Nullable
    public final String userRequestedTenant() {
        return this.userRequestedTenant;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.backendRoles)) {
            generator.writeKey("backend_roles");
            generator.writeStartArray();
            for (String item0 : this.backendRoles) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.customAttributeNames)) {
            generator.writeKey("custom_attribute_names");
            generator.writeStartArray();
            for (String item0 : this.customAttributeNames) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("name");
        generator.write(this.name);
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (String item0 : this.roles) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.userRequestedTenant != null) {
            generator.writeKey("user_requested_tenant");
            generator.write(this.userRequestedTenant);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupOwnerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::backendRoles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "backend_roles");
        op.add(Builder::customAttributeNames, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "custom_attribute_names");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles");
        op.add(Builder::userRequestedTenant, JsonpDeserializer.stringDeserializer(), "user_requested_tenant");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.backendRoles);
        result = 31 * result + Objects.hashCode(this.customAttributeNames);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.roles);
        result = 31 * result + Objects.hashCode(this.userRequestedTenant);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Owner other = (Owner)o;
        return Objects.equals(this.backendRoles, other.backendRoles) && Objects.equals(this.customAttributeNames, other.customAttributeNames) && this.name.equals(other.name) && Objects.equals(this.roles, other.roles) && Objects.equals(this.userRequestedTenant, other.userRequestedTenant);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Owner> {
        @Nullable
        private List<String> backendRoles;
        @Nullable
        private List<String> customAttributeNames;
        private String name;
        @Nullable
        private List<String> roles;
        @Nullable
        private String userRequestedTenant;

        public Builder() {
        }

        private Builder(Owner o) {
            this.backendRoles = Builder._listCopy(o.backendRoles);
            this.customAttributeNames = Builder._listCopy(o.customAttributeNames);
            this.name = o.name;
            this.roles = Builder._listCopy(o.roles);
            this.userRequestedTenant = o.userRequestedTenant;
        }

        private Builder(Builder o) {
            this.backendRoles = Builder._listCopy(o.backendRoles);
            this.customAttributeNames = Builder._listCopy(o.customAttributeNames);
            this.name = o.name;
            this.roles = Builder._listCopy(o.roles);
            this.userRequestedTenant = o.userRequestedTenant;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder backendRoles(List<String> list) {
            this.backendRoles = Builder._listAddAll(this.backendRoles, list);
            return this;
        }

        @Nonnull
        public final Builder backendRoles(String value, String ... values) {
            this.backendRoles = Builder._listAdd(this.backendRoles, value, values);
            return this;
        }

        @Nonnull
        public final Builder customAttributeNames(List<String> list) {
            this.customAttributeNames = Builder._listAddAll(this.customAttributeNames, list);
            return this;
        }

        @Nonnull
        public final Builder customAttributeNames(String value, String ... values) {
            this.customAttributeNames = Builder._listAdd(this.customAttributeNames, value, values);
            return this;
        }

        @Nonnull
        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder roles(List<String> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        @Nonnull
        public final Builder roles(String value, String ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        @Nonnull
        public final Builder userRequestedTenant(@Nullable String value) {
            this.userRequestedTenant = value;
            return this;
        }

        @Override
        @Nonnull
        public Owner build() {
            this._checkSingleUse();
            return new Owner(this);
        }
    }
}

