/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mime4j;

import com.google.common.io.CountingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.james.jmap.mime4j.FakeBinaryBody;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.SingleBody;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.io.InputStreams;
import org.apache.james.mime4j.message.BasicBodyFactory;
import org.apache.james.mime4j.message.BodyFactory;
import org.apache.james.mime4j.util.ByteArrayOutputStreamRecycler;
import org.apache.james.mime4j.util.ContentUtil;

public class AvoidBinaryBodyBufferingBodyFactory
implements BodyFactory {
    public static final BasicBodyFactory INSTANCE = new BasicBodyFactory();
    private final Charset defaultCharset;

    public AvoidBinaryBodyBufferingBodyFactory() {
        this(true);
    }

    public AvoidBinaryBodyBufferingBodyFactory(Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public AvoidBinaryBodyBufferingBodyFactory(boolean lenient) {
        this(lenient ? Charset.defaultCharset() : null);
    }

    protected Charset resolveCharset(String mimeCharset) throws UnsupportedEncodingException {
        block3: {
            if (mimeCharset != null) {
                try {
                    return Charset.forName(mimeCharset);
                }
                catch (IllegalCharsetNameException | UnsupportedCharsetException ex) {
                    if (this.defaultCharset != null) break block3;
                    throw new UnsupportedEncodingException(mimeCharset);
                }
            }
        }
        return this.defaultCharset;
    }

    public TextBody textBody(String text, String mimeCharset) throws UnsupportedEncodingException {
        if (text == null) {
            throw new IllegalArgumentException("Text may not be null");
        }
        return new StringBody1(text, this.resolveCharset(mimeCharset));
    }

    public TextBody textBody(byte[] content, Charset charset) {
        if (content == null) {
            throw new IllegalArgumentException("Content may not be null");
        }
        return new StringBody2(content, charset);
    }

    public TextBody textBody(InputStream content, String mimeCharset) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException("Input stream may not be null");
        }
        return new StringBody3(ContentUtil.bufferEfficient((InputStream)content), this.resolveCharset(mimeCharset));
    }

    public TextBody textBody(String text, Charset charset) {
        if (text == null) {
            throw new IllegalArgumentException("Text may not be null");
        }
        return new StringBody1(text, charset);
    }

    public TextBody textBody(String text) {
        return this.textBody(text, Charsets.DEFAULT_CHARSET);
    }

    public BinaryBody binaryBody(InputStream is) throws IOException {
        CountingOutputStream out = new CountingOutputStream(OutputStream.nullOutputStream());
        is.transferTo((OutputStream)out);
        return new FakeBinaryBody(out.getCount());
    }

    static class StringBody1
    extends TextBody {
        private final String content;
        private final Charset charset;

        StringBody1(String content, Charset charset) {
            this.content = content;
            this.charset = charset;
        }

        public String getMimeCharset() {
            return this.charset != null ? this.charset.name() : null;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public Reader getReader() throws IOException {
            return new StringReader(this.content);
        }

        public InputStream getInputStream() throws IOException {
            return InputStreams.create((CharSequence)this.content, (Charset)(this.charset != null ? this.charset : Charsets.DEFAULT_CHARSET));
        }

        public SingleBody copy() {
            return new StringBody1(this.content, this.charset);
        }
    }

    static class StringBody2
    extends TextBody {
        private final byte[] content;
        private final Charset charset;

        StringBody2(byte[] content, Charset charset) {
            this.content = content;
            this.charset = charset;
        }

        public String getMimeCharset() {
            return this.charset != null ? this.charset.name() : null;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public Reader getReader() throws IOException {
            return new InputStreamReader(InputStreams.create((byte[])this.content), this.charset);
        }

        public InputStream getInputStream() throws IOException {
            return InputStreams.create((byte[])this.content);
        }

        public void writeTo(OutputStream out) throws IOException {
            out.write(this.content);
        }

        public long size() {
            return this.content.length;
        }

        public SingleBody copy() {
            return new StringBody2(this.content, this.charset);
        }
    }

    static class StringBody3
    extends TextBody {
        private final ByteArrayOutputStreamRecycler.Wrapper content;
        private final Charset charset;

        StringBody3(ByteArrayOutputStreamRecycler.Wrapper content, Charset charset) {
            this.content = content;
            this.charset = charset;
        }

        public String getMimeCharset() {
            return this.charset != null ? this.charset.name() : null;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public Reader getReader() throws IOException {
            return new InputStreamReader(this.content.getValue().toInputStream(), this.charset);
        }

        public InputStream getInputStream() throws IOException {
            return this.content.getValue().toInputStream();
        }

        public long size() {
            return this.content.getValue().size();
        }

        public void writeTo(OutputStream out) throws IOException {
            this.content.getValue().writeTo(out);
        }

        public void dispose() {
            this.content.release();
        }

        public SingleBody copy() {
            return new StringBody3(this.content, this.charset);
        }
    }
}

