/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.opensearch;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.james.backends.opensearch.AliasName;
import org.apache.james.backends.opensearch.ReactorOpenSearchClient;
import org.apache.james.backends.opensearch.ReadAliasName;
import org.apache.james.backends.opensearch.search.ScrolledSearch;
import org.apache.james.core.Username;
import org.apache.james.quota.search.QuotaQuery;
import org.apache.james.quota.search.QuotaSearcher;
import org.apache.james.quota.search.opensearch.QuotaQueryConverter;
import org.opensearch.client.opensearch._types.FieldSort;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.search.Hit;
import reactor.core.publisher.Flux;

public class OpenSearchQuotaSearcher
implements QuotaSearcher {
    private static final Time TIMEOUT = (Time)new Time.Builder().time("1m").build();
    private final ReactorOpenSearchClient client;
    private final AliasName readAlias;
    private final QuotaQueryConverter quotaQueryConverter;

    public OpenSearchQuotaSearcher(ReactorOpenSearchClient client, ReadAliasName readAlias) {
        this.client = client;
        this.readAlias = readAlias;
        this.quotaQueryConverter = new QuotaQueryConverter();
    }

    public List<Username> search(QuotaQuery query) {
        try {
            return (List)this.searchHits(query).map(Hit::id).map(Username::of).collect(ImmutableList.toImmutableList()).block();
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception while executing " + String.valueOf(query), e);
        }
    }

    private Flux<Hit<ObjectNode>> searchHits(QuotaQuery query) throws IOException {
        if (query.getLimit().isLimited()) {
            return this.executeSingleSearch(query);
        }
        return this.executeScrolledSearch(query);
    }

    private Flux<Hit<ObjectNode>> executeSingleSearch(QuotaQuery query) throws IOException {
        SearchRequest.Builder searchRequest = this.searchRequestBuilder(query).index(this.readAlias.getValue(), new String[0]).from(Integer.valueOf(query.getOffset().getValue()));
        query.getLimit().getValue().ifPresent(arg_0 -> ((SearchRequest.Builder)searchRequest).size(arg_0));
        return this.client.search(searchRequest.build()).flatMapIterable(searchResponse -> ImmutableList.copyOf((Collection)searchResponse.hits().hits()));
    }

    private Flux<Hit<ObjectNode>> executeScrolledSearch(QuotaQuery query) {
        return new ScrolledSearch(this.client, this.searchRequestBuilder(query).index(this.readAlias.getValue(), new String[0]).scroll(TIMEOUT).build()).searchHits().skip((long)query.getOffset().getValue());
    }

    private SearchRequest.Builder searchRequestBuilder(QuotaQuery query) {
        return new SearchRequest.Builder().query(this.quotaQueryConverter.from(query)).sort((SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().field("user").order(SortOrder.Asc).build()).build(), new SortOptions[0]);
    }
}

