/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Constructable;
import org.jgroups.util.Bits;
import org.jgroups.util.SizeStreamable;
import org.jgroups.util.Util;

public class ViewId
implements Comparable<ViewId>,
SizeStreamable,
Constructable<ViewId> {
    protected Address creator;
    protected long id;

    public ViewId() {
    }

    public ViewId(Address creator) {
        this.creator = creator;
        if (this.creator == null) {
            throw new IllegalArgumentException("creator cannot be null");
        }
    }

    public ViewId(Address creator, long id) {
        this(creator);
        this.id = id;
    }

    @Override
    public Supplier<? extends ViewId> create() {
        return ViewId::new;
    }

    public Address getCreator() {
        return this.creator;
    }

    public long getId() {
        return this.id;
    }

    public String toString() {
        return "[" + this.creator + "|" + this.id + "]";
    }

    public ViewId copy() {
        return new ViewId(this.creator, this.id);
    }

    @Override
    public int compareTo(ViewId other) {
        return this.id > other.id ? 1 : (this.id < other.id ? -1 : this.creator.compareTo(other.creator));
    }

    public int compareToIDs(ViewId other) {
        return Long.compare(this.id, other.id);
    }

    public boolean equals(Object other) {
        return other instanceof ViewId && (this == other || this.compareTo((ViewId)other) == 0);
    }

    public int hashCode() {
        return (int)((long)this.creator.hashCode() + this.id);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        Util.writeAddress(this.creator, out);
        Bits.writeLongCompressed(this.id, out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        this.creator = Util.readAddress(in);
        this.id = Bits.readLongCompressed(in);
    }

    @Override
    public int serializedSize() {
        return Bits.size(this.id) + Util.size(this.creator);
    }
}

