/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import java.util.UUID;
import java.util.function.Function;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.events.Event;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventSerializer;
import org.apache.james.events.Group;
import org.apache.james.events.PostgresEventDeadLettersDataDefinition;
import org.jooq.Condition;
import org.jooq.Record;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresEventDeadLetters
implements EventDeadLetters {
    private final PostgresExecutor postgresExecutor;
    private final EventSerializer eventSerializer;

    @Inject
    public PostgresEventDeadLetters(PostgresExecutor postgresExecutor, EventSerializer eventSerializer) {
        this.postgresExecutor = postgresExecutor;
        this.eventSerializer = eventSerializer;
    }

    public Mono<EventDeadLetters.InsertionId> store(Group registeredGroup, Event failDeliveredEvent) {
        Preconditions.checkArgument((registeredGroup != null ? 1 : 0) != 0, (Object)"registeredGroup cannot be null");
        Preconditions.checkArgument((failDeliveredEvent != null ? 1 : 0) != 0, (Object)"failDeliveredEvent cannot be null");
        EventDeadLetters.InsertionId insertionId = EventDeadLetters.InsertionId.random();
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresEventDeadLettersDataDefinition.PostgresEventDeadLettersTable.TABLE_NAME).set(PostgresEventDeadLettersDataDefinition.PostgresEventDeadLettersTable.INSERTION_ID, (Object)insertionId.getId()).set(PostgresEventDeadLettersDataDefinition.PostgresEventDeadLettersTable.GROUP, (Object)registeredGroup.asString()).set(PostgresEventDeadLettersDataDefinition.PostgresEventDeadLettersTable.EVENT, (Object)this.eventSerializer.toJson(failDeliveredEvent)))).thenReturn((Object)insertionId);
    }

    public Mono<Void> remove(Group registeredGroup, EventDeadLetters.InsertionId failDeliveredInsertionId) {
        Preconditions.checkArgument((registeredGroup != null ? 1 : 0) != 0, (Object)"registeredGroup cannot be null");
        Preconditions.checkArgument((failDeliveredInsertionId != null ? 1 : 0) != 0, (Object)"failDeliveredInsertionId cannot be null");
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresEventDeadLettersDataDefinition.PostgresEventDeadLettersTable.TABLE_NAME).where(PostgresEventDeadLettersDataDefinition.PostgresEventDeadLettersTable.INSERTION_ID.eq((Object)failDeliveredInsertionId.getId()))));
    }

    public Mono<Void> remove(Group registeredGroup) {
        Preconditions.checkArgument((registeredGroup != null ? 1 : 0) != 0, (Object)"registeredGroup cannot be null");
        return this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresEventDeadLettersDataDefinition.PostgresEventDeadLettersTable.TABLE_NAME).where(PostgresEventDeadLettersDataDefinition.PostgresEventDeadLettersTable.GROUP.eq((Object)registeredGroup.asString()))));
    }

    public Mono<Event> failedEvent(Group registeredGroup, EventDeadLetters.InsertionId failDeliveredInsertionId) {
        Preconditions.checkArgument((registeredGroup != null ? 1 : 0) != 0, (Object)"registeredGroup cannot be null");
        Preconditions.checkArgument((failDeliveredInsertionId != null ? 1 : 0) != 0, (Object)"failDeliveredInsertionId cannot be null");
        return this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.select(PostgresEventDeadLettersDataDefinition.PostgresEventDeadLettersTable.EVENT).from(PostgresEventDeadLettersDataDefinition.PostgresEventDeadLettersTable.TABLE_NAME).where(PostgresEventDeadLettersDataDefinition.PostgresEventDeadLettersTable.INSERTION_ID.eq((Object)failDeliveredInsertionId.getId())))).map(this::deserializeEvent);
    }

    private Event deserializeEvent(Record record) {
        return this.eventSerializer.asEvent((String)record.get(PostgresEventDeadLettersDataDefinition.PostgresEventDeadLettersTable.EVENT));
    }

    public Flux<EventDeadLetters.InsertionId> failedIds(Group registeredGroup) {
        Preconditions.checkArgument((registeredGroup != null ? 1 : 0) != 0, (Object)"registeredGroup cannot be null");
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.select(PostgresEventDeadLettersDataDefinition.PostgresEventDeadLettersTable.INSERTION_ID).from(PostgresEventDeadLettersDataDefinition.PostgresEventDeadLettersTable.TABLE_NAME).where(PostgresEventDeadLettersDataDefinition.PostgresEventDeadLettersTable.GROUP.eq((Object)registeredGroup.asString())))).map(record -> EventDeadLetters.InsertionId.of((UUID)((UUID)record.get(PostgresEventDeadLettersDataDefinition.PostgresEventDeadLettersTable.INSERTION_ID))));
    }

    public Flux<Group> groupsWithFailedEvents() {
        return this.postgresExecutor.executeRows(dslContext -> Flux.from((Publisher)dslContext.selectDistinct(PostgresEventDeadLettersDataDefinition.PostgresEventDeadLettersTable.GROUP).from(PostgresEventDeadLettersDataDefinition.PostgresEventDeadLettersTable.TABLE_NAME))).map((Function)Throwing.function(record -> Group.deserialize((String)((String)record.get(PostgresEventDeadLettersDataDefinition.PostgresEventDeadLettersTable.GROUP)))));
    }

    public Mono<Boolean> containEvents() {
        return this.postgresExecutor.executeExists(dslContext -> dslContext.selectOne().from(PostgresEventDeadLettersDataDefinition.PostgresEventDeadLettersTable.TABLE_NAME).where(new Condition[0]));
    }
}

