/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.RecentLoginHistory;
import com.unboundid.ldap.sdk.unboundidds.controls.RecentLoginHistoryAttempt;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetRecentLoginHistoryResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String GET_RECENT_LOGIN_HISTORY_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.62";
    @NotNull
    private static final String JSON_FIELD_FAILED_ATTEMPTS = "failed-attempts";
    @NotNull
    private static final String JSON_FIELD_SUCCESSFUL_ATTEMPTS = "successful-attempts";
    private static final long serialVersionUID = -4604204310334007290L;
    @NotNull
    private final RecentLoginHistory recentLoginHistory;

    GetRecentLoginHistoryResponseControl() {
        this.recentLoginHistory = null;
    }

    public GetRecentLoginHistoryResponseControl(@NotNull RecentLoginHistory recentLoginHistory) {
        super(GET_RECENT_LOGIN_HISTORY_RESPONSE_OID, false, new ASN1OctetString(recentLoginHistory.asJSONObject().toString()));
        this.recentLoginHistory = recentLoginHistory;
    }

    public GetRecentLoginHistoryResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        JSONObject jsonObject;
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_RECENT_LOGIN_HISTORY_RESPONSE_NO_VALUE.get());
        }
        try {
            jsonObject = new JSONObject(value.stringValue());
        }
        catch (JSONException e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_RECENT_LOGIN_HISTORY_RESPONSE_VALUE_NOT_JSON.get(e.getMessage()), e);
        }
        try {
            this.recentLoginHistory = new RecentLoginHistory(jsonObject);
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_RECENT_LOGIN_HISTORY_RESPONSE_CANNOT_PARSE_VALUE.get(e.getMessage()), e);
        }
    }

    @Override
    @NotNull
    public GetRecentLoginHistoryResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new GetRecentLoginHistoryResponseControl(oid, isCritical, value);
    }

    @NotNull
    public RecentLoginHistory getRecentLoginHistory() {
        return this.recentLoginHistory;
    }

    @Nullable
    public static GetRecentLoginHistoryResponseControl get(@NotNull BindResult bindResult) throws LDAPException {
        Control c = bindResult.getResponseControl(GET_RECENT_LOGIN_HISTORY_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof GetRecentLoginHistoryResponseControl) {
            return (GetRecentLoginHistoryResponseControl)c;
        }
        return new GetRecentLoginHistoryResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_GET_RECENT_LOGIN_HISTORY_RESPONSE.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        if (!this.recentLoginHistory.getSuccessfulAttempts().isEmpty()) {
            ArrayList<JSONObject> successfulAttemptObjects = new ArrayList<JSONObject>(this.recentLoginHistory.getSuccessfulAttempts().size());
            for (RecentLoginHistoryAttempt attempt : this.recentLoginHistory.getSuccessfulAttempts()) {
                successfulAttemptObjects.add(attempt.asJSONObject());
            }
            valueFields.put(JSON_FIELD_SUCCESSFUL_ATTEMPTS, new JSONArray(successfulAttemptObjects));
        }
        if (!this.recentLoginHistory.getFailedAttempts().isEmpty()) {
            ArrayList<JSONObject> failedAttemptObjects = new ArrayList<JSONObject>(this.recentLoginHistory.getFailedAttempts().size());
            for (RecentLoginHistoryAttempt attempt : this.recentLoginHistory.getFailedAttempts()) {
                failedAttemptObjects.add(attempt.asJSONObject());
            }
            valueFields.put(JSON_FIELD_FAILED_ATTEMPTS, new JSONArray(failedAttemptObjects));
        }
        return new JSONObject(new JSONField("oid", GET_RECENT_LOGIN_HISTORY_RESPONSE_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_GET_RECENT_LOGIN_HISTORY_RESPONSE.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    @NotNull
    public static GetRecentLoginHistoryResponseControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        ArrayList<RecentLoginHistoryAttempt> failedAttempts;
        ArrayList<RecentLoginHistoryAttempt> successfulAttempts;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new GetRecentLoginHistoryResponseControl(jsonControl.getOID(), jsonControl.getCriticality(), rawValue);
        }
        JSONObject valueObject = jsonControl.getValueObject();
        List<JSONValue> successObjects = valueObject.getFieldAsArray(JSON_FIELD_SUCCESSFUL_ATTEMPTS);
        if (successObjects == null) {
            successfulAttempts = null;
        } else {
            successfulAttempts = new ArrayList<RecentLoginHistoryAttempt>(successObjects.size());
            for (JSONValue successValue : successObjects) {
                if (successValue instanceof JSONObject) {
                    try {
                        successfulAttempts.add(new RecentLoginHistoryAttempt((JSONObject)successValue));
                        continue;
                    }
                    catch (LDAPException e) {
                        Debug.debugException(e);
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_RECENT_LOGIN_HISTORY_RESPONSE_JSON_MALFORMED_ATTEMPT.get(controlObject.toSingleLineString(), JSON_FIELD_SUCCESSFUL_ATTEMPTS, e.getMessage()), e);
                    }
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_RECENT_LOGIN_HISTORY_RESPONSE_JSON_ATTEMPT_NOT_OBJECT.get(controlObject.toSingleLineString(), JSON_FIELD_SUCCESSFUL_ATTEMPTS));
            }
        }
        List<JSONValue> failureObjects = valueObject.getFieldAsArray(JSON_FIELD_FAILED_ATTEMPTS);
        if (failureObjects == null) {
            failedAttempts = null;
        } else {
            failedAttempts = new ArrayList<RecentLoginHistoryAttempt>(failureObjects.size());
            for (JSONValue failureValue : failureObjects) {
                if (failureValue instanceof JSONObject) {
                    try {
                        failedAttempts.add(new RecentLoginHistoryAttempt((JSONObject)failureValue));
                        continue;
                    }
                    catch (LDAPException e) {
                        Debug.debugException(e);
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_RECENT_LOGIN_HISTORY_RESPONSE_JSON_MALFORMED_ATTEMPT.get(controlObject.toSingleLineString(), JSON_FIELD_FAILED_ATTEMPTS, e.getMessage()), e);
                    }
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_RECENT_LOGIN_HISTORY_RESPONSE_JSON_ATTEMPT_NOT_OBJECT.get(controlObject.toSingleLineString(), JSON_FIELD_FAILED_ATTEMPTS));
            }
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_SUCCESSFUL_ATTEMPTS, JSON_FIELD_FAILED_ATTEMPTS)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_RECENT_LOGIN_HISTORY_RESPONSE_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new GetRecentLoginHistoryResponseControl(new RecentLoginHistory(successfulAttempts, failedAttempts));
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("GetRecentLoginHistoryResponseControl(recentLoginHistory=");
        buffer.append(this.recentLoginHistory.toString());
        buffer.append(')');
    }
}

