/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener.interceptor;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedAddRequest;
import com.unboundid.ldap.listener.interceptor.InMemoryInterceptedAddResult;
import com.unboundid.ldap.listener.interceptor.InterceptedOperation;
import com.unboundid.ldap.protocol.AddRequestProtocolOp;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ReadOnlyAddRequest;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
final class InterceptedAddOperation
extends InterceptedOperation
implements InMemoryInterceptedAddRequest,
InMemoryInterceptedAddResult {
    @NotNull
    private AddRequest addRequest;
    @Nullable
    private LDAPResult addResult;

    InterceptedAddOperation(@NotNull LDAPListenerClientConnection clientConnection, int messageID, @NotNull AddRequestProtocolOp requestOp, Control ... requestControls) {
        super(clientConnection, messageID);
        this.addRequest = requestOp.toAddRequest(requestControls);
        this.addResult = null;
    }

    @Override
    @NotNull
    public ReadOnlyAddRequest getRequest() {
        return this.addRequest;
    }

    @Override
    public void setRequest(@NotNull AddRequest addRequest) {
        this.addRequest = addRequest;
    }

    @Override
    @Nullable
    public LDAPResult getResult() {
        return this.addResult;
    }

    @Override
    public void setResult(@NotNull LDAPResult addResult) {
        this.addResult = addResult;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("InterceptedAddOperation(");
        this.appendCommonToString(buffer);
        buffer.append(", request=");
        buffer.append(this.addRequest);
        buffer.append(", result=");
        buffer.append(this.addResult);
        buffer.append(')');
    }
}

