/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.migration;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Optional;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.backends.cassandra.migration.CassandraSchemaTransitions;
import org.apache.james.backends.cassandra.migration.MigrationTask;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionDAO;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionManager;
import org.apache.james.backends.cassandra.versions.SchemaTransition;
import org.apache.james.backends.cassandra.versions.SchemaVersion;
import org.apache.james.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraMigrationService {
    public static final String LATEST_VERSION = "latestVersion";
    private final CassandraSchemaVersionDAO schemaVersionDAO;
    private final CassandraSchemaTransitions transitions;
    private final MigrationTask.Factory taskFactory;
    private final SchemaVersion latestVersion;
    private final Logger logger = LoggerFactory.getLogger(CassandraMigrationService.class);

    @Inject
    public CassandraMigrationService(CassandraSchemaVersionDAO schemaVersionDAO, CassandraSchemaTransitions transitions, MigrationTask.Factory factory, @Named(value="latestVersion") SchemaVersion latestVersion) {
        this.schemaVersionDAO = schemaVersionDAO;
        this.transitions = transitions;
        this.taskFactory = factory;
        this.latestVersion = latestVersion;
    }

    public Optional<SchemaVersion> getCurrentVersion() {
        return (Optional)this.schemaVersionDAO.getCurrentSchemaVersion().block();
    }

    public Optional<SchemaVersion> getLatestVersion() {
        return Optional.of(this.latestVersion);
    }

    public Task upgradeToVersion(SchemaVersion target) {
        this.checkTarget(target);
        return this.taskFactory.create(target);
    }

    private void checkTarget(SchemaVersion target) {
        this.getCurrentVersion().orElse(CassandraSchemaVersionManager.DEFAULT_VERSION).listTransitionsForTarget(target).forEach(this::checkMigration);
    }

    private void checkMigration(SchemaTransition transition) {
        this.transitions.findMigration(transition).orElseThrow(() -> {
            String message = String.format("Can not migrate from %s to %s. No migration class registered.", transition.fromAsString(), transition.toAsString());
            this.logger.error(message);
            return new NotImplementedException(message);
        });
    }

    public Task upgradeToLastVersion() {
        return this.upgradeToVersion(this.latestVersion);
    }
}

