/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.adapter.mailbox;

import jakarta.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.Authorizator;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;

public class UserRepositoryAuthorizator
implements Authorizator {
    private final UsersRepository repos;

    @Inject
    public UserRepositoryAuthorizator(UsersRepository repos) {
        this.repos = repos;
    }

    public Authorizator.AuthorizationState canLoginAsOtherUser(Username userId, Username otherUserId) throws MailboxException {
        try {
            if (!this.repos.isAdministrator(userId)) {
                return Authorizator.AuthorizationState.FORBIDDEN;
            }
            if (!this.repos.contains(otherUserId)) {
                return Authorizator.AuthorizationState.UNKNOWN_USER;
            }
            return Authorizator.AuthorizationState.ALLOWED;
        }
        catch (UsersRepositoryException e) {
            throw new MailboxException("Unable to access usersRepository", (Throwable)e);
        }
    }
}

