/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imapserver.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.compression.ZlibEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedNioFile;
import io.netty.handler.stream.ChunkedStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapResponseWriter;
import org.apache.james.imap.message.Literal;
import org.apache.james.imapserver.netty.ImapChannelUpstreamHandler;
import org.apache.james.util.MDCStructuredLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelImapResponseWriter
implements ImapResponseWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelImapResponseWriter.class);
    private final Channel channel;
    private final boolean zeroCopy;
    private FlushCallback flushCallback;
    private ImapSession imapSession = null;

    public ChannelImapResponseWriter(Channel channel, ImapSession imapSession) {
        this(channel);
        this.imapSession = imapSession;
    }

    public ChannelImapResponseWriter(Channel channel) {
        this(channel, true);
    }

    public ChannelImapResponseWriter(Channel channel, boolean zeroCopy) {
        this.channel = channel;
        this.zeroCopy = zeroCopy;
        this.flushCallback = () -> {};
    }

    public void setFlushCallback(FlushCallback flushCallback) {
        this.flushCallback = flushCallback;
    }

    public void write(byte[] buffer) {
        if (LOGGER.isTraceEnabled() && this.imapSession != null) {
            new MDCStructuredLogger(LOGGER).field("username", ImapChannelUpstreamHandler.retrieveUsername(this.imapSession)).log(logger -> logger.trace("Writing IMAP response: {}", (Object)new String(buffer)));
        }
        if (this.channel.isActive()) {
            this.channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])buffer));
        }
    }

    public void write(Literal literal) throws IOException {
        this.flushCallback.run();
        if (this.channel.isActive()) {
            if (literal.asBytesSequence().isPresent()) {
                this.channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[][])((byte[][])literal.asBytesSequence().get())));
                return;
            }
            InputStream in = literal.getInputStream();
            if (in instanceof FileInputStream) {
                FileChannel fc = ((FileInputStream)in).getChannel();
                ChannelPipeline cp = this.channel.pipeline();
                if (this.zeroCopy && cp.get(SslHandler.class) == null && cp.get(ZlibEncoder.class) == null) {
                    this.channel.writeAndFlush((Object)new DefaultFileRegion(fc, fc.position(), literal.size()));
                } else {
                    this.channel.writeAndFlush((Object)new ChunkedNioFile(fc, 8192));
                }
            } else {
                this.channel.writeAndFlush((Object)new ChunkedStream(in));
            }
        }
    }

    public void flush() throws IOException {
        this.flushCallback.run();
        this.channel.flush();
    }

    @FunctionalInterface
    static interface FlushCallback {
        public void run() throws IOException;
    }
}

