/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class SimpleStringOperatorNode
extends UnaryOperatorNode {
    SimpleStringOperatorNode(ValueNode valueNode, String string, ContextManager contextManager) throws StandardException {
        super(valueNode, string, string, contextManager);
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        this.bindOperand(fromList, subqueryList, list);
        TypeId typeId = this.operand.getTypeId();
        switch (typeId.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            case 1111: 
            case 2000: {
                throw StandardException.newException((String)"42X25", (Object[])new Object[]{this.methodName, typeId.getSQLTypeName()});
            }
            default: {
                DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, true, this.operand.getTypeCompiler().getCastToCharWidth(this.operand.getTypeServices()));
                this.operand = new CastNode(this.operand, dataTypeDescriptor, this.getContextManager());
                this.operand.setCollationUsingCompilationSchema();
                ((CastNode)this.operand).bindCastNodeOnly();
                typeId = this.operand.getTypeId();
            }
        }
        this.setType(new DataTypeDescriptor(typeId, this.operand.getTypeServices().isNullable(), this.operand.getTypeCompiler().getCastToCharWidth(this.operand.getTypeServices())));
        this.setCollationInfo(this.operand.getTypeServices());
        return this;
    }

    @Override
    void bindParameter() throws StandardException {
        this.operand.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(12));
        this.operand.setCollationUsingCompilationSchema();
    }

    @Override
    String getReceiverInterfaceName() {
        return "org.apache.derby.iapi.types.StringDataValue";
    }
}

