/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.authentication;

import com.google.common.base.Splitter;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.apache.james.webadmin.authentication.AuthenticationFilter;
import spark.Request;
import spark.Response;
import spark.Spark;

public class PasswordFilter
implements AuthenticationFilter {
    public static final String PASSWORD = "Password";
    public static final String OPTIONS = "OPTIONS";
    private final List<String> passwords;

    @Inject
    public PasswordFilter(String passwordString) {
        this.passwords = Splitter.on((char)',').splitToList((CharSequence)passwordString);
    }

    public void handle(Request request, Response response) throws Exception {
        if (!request.requestMethod().equals(OPTIONS)) {
            Optional<String> password = Optional.ofNullable(request.headers(PASSWORD));
            if (!password.isPresent()) {
                Spark.halt((int)401, (String)"No Password header.");
            }
            if (!this.passwords.contains(password.get())) {
                Spark.halt((int)401, (String)"Wrong Password header.");
            }
        }
    }
}

