/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.SingleBody;
import org.apache.james.mime4j.message.BodyFactory;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.DefaultMessageImplFactory;
import org.apache.james.mime4j.message.HeaderImpl;
import org.apache.james.mime4j.message.MessageImpl;
import org.apache.james.mime4j.message.MessageImplFactory;
import org.apache.james.mime4j.message.MultipartImpl;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.util.ByteArrayBuffer;
import org.apache.james.mime4j.util.ByteSequence;

public class ParserStreamContentHandler
implements ContentHandler {
    private final Entity entity;
    private final MessageImplFactory messageImplFactory;
    private final BodyFactory bodyFactory;
    private final Stack<Object> stack;

    public ParserStreamContentHandler(Entity entity, BodyFactory bodyFactory) {
        this.entity = entity;
        this.messageImplFactory = new DefaultMessageImplFactory();
        this.bodyFactory = bodyFactory;
        this.stack = new Stack();
    }

    public ParserStreamContentHandler(Entity entity, MessageImplFactory messageImplFactory, BodyFactory bodyFactory) {
        this.entity = entity;
        this.messageImplFactory = messageImplFactory;
        this.bodyFactory = bodyFactory;
        this.stack = new Stack();
    }

    private void expect(Class<?> c) {
        if (!c.isInstance(this.stack.peek())) {
            throw new IllegalStateException("Internal stack error: Expected '" + c.getName() + "' found '" + this.stack.peek().getClass().getName() + "'");
        }
    }

    @Override
    public void startMessage() throws MimeException {
        if (this.stack.isEmpty()) {
            this.stack.push(this.entity);
        } else {
            this.expect(Entity.class);
            MessageImpl m4 = this.messageImplFactory.messageImpl();
            ((Entity)this.stack.peek()).setBody(m4);
            this.stack.push(m4);
        }
    }

    @Override
    public void endMessage() throws MimeException {
        this.expect(Message.class);
        this.stack.pop();
    }

    @Override
    public void startHeader() throws MimeException {
        this.stack.push(new HeaderImpl());
    }

    @Override
    public void field(Field field2) throws MimeException {
        this.expect(Header.class);
        ((Header)this.stack.peek()).addField(field2);
    }

    @Override
    public void endHeader() throws MimeException {
        this.expect(Header.class);
        Header h2 = (Header)this.stack.pop();
        this.expect(Entity.class);
        ((Entity)this.stack.peek()).setHeader(h2);
    }

    @Override
    public void startMultipart(BodyDescriptor bd) throws MimeException {
        this.expect(Entity.class);
        Entity e = (Entity)this.stack.peek();
        String subType = bd.getSubType();
        MultipartImpl multiPart = new MultipartImpl(subType);
        e.setBody(multiPart);
        this.stack.push(multiPart);
    }

    @Override
    public void body(BodyDescriptor bd, InputStream is) throws MimeException, IOException {
        this.expect(Entity.class);
        SingleBody body = bd.getMimeType().startsWith("text/") ? this.bodyFactory.textBody(is, bd.getCharset()) : this.bodyFactory.binaryBody(is);
        Entity entity = (Entity)this.stack.peek();
        entity.setBody(body);
    }

    @Override
    public void endMultipart() throws MimeException {
        this.stack.pop();
    }

    @Override
    public void startBodyPart() throws MimeException {
        this.expect(Multipart.class);
        BodyPart bodyPart = new BodyPart();
        ((Multipart)this.stack.peek()).addBodyPart(bodyPart);
        this.stack.push(bodyPart);
    }

    @Override
    public void endBodyPart() throws MimeException {
        this.expect(BodyPart.class);
        this.stack.pop();
    }

    @Override
    public void epilogue(InputStream is) throws MimeException, IOException {
        this.expect(MultipartImpl.class);
        ByteSequence bytes = ParserStreamContentHandler.loadStream(is);
        ((MultipartImpl)this.stack.peek()).setEpilogueRaw(bytes);
    }

    @Override
    public void preamble(InputStream is) throws MimeException, IOException {
        this.expect(MultipartImpl.class);
        ByteSequence bytes = ParserStreamContentHandler.loadStream(is);
        ((MultipartImpl)this.stack.peek()).setPreambleRaw(bytes);
    }

    @Override
    public void raw(InputStream is) throws MimeException, IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    private static ByteSequence loadStream(InputStream in) throws IOException {
        int b;
        ByteArrayBuffer bab = new ByteArrayBuffer(64);
        while ((b = in.read()) != -1) {
            bab.append(b);
        }
        return bab;
    }
}

