/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import serp.bytecode.Annotated;
import serp.bytecode.BCField;
import serp.bytecode.BCMethod;
import serp.bytecode.Code;
import serp.bytecode.InnerClasses;
import serp.bytecode.Project;
import serp.bytecode.SourceFile;
import serp.bytecode.State;
import serp.bytecode.lowlevel.ClassEntry;
import serp.bytecode.lowlevel.ConstantPool;
import serp.bytecode.visitor.BCVisitor;
import serp.bytecode.visitor.VisitAcceptor;
import serp.util.Numbers;
import serp.util.Strings;

public class BCClass
extends Annotated
implements VisitAcceptor {
    private Project _project = null;
    private State _state = null;
    private ClassLoader _loader = null;

    BCClass(Project project) {
        this._project = project;
    }

    void setState(State state) {
        this._state = state;
    }

    void invalidate() {
        this._project = null;
        this._state = State.INVALID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(File classFile, ClassLoader loader) throws IOException {
        FileInputStream in = new FileInputStream(classFile);
        try {
            this.read(in, loader);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    void read(InputStream instream, ClassLoader loader) throws IOException {
        DataInputStream in = new DataInputStream(instream);
        this._state.setMagic(in.readInt());
        this._state.setMinorVersion(in.readUnsignedShort());
        this._state.setMajorVersion(in.readUnsignedShort());
        this._state.getPool().read(in);
        this._state.setAccessFlags(in.readUnsignedShort());
        this._state.setIndex(in.readUnsignedShort());
        this._state.setSuperclassIndex(in.readUnsignedShort());
        List interfaces = this._state.getInterfacesHolder();
        interfaces.clear();
        int interfaceCount = in.readUnsignedShort();
        for (int i = 0; i < interfaceCount; ++i) {
            interfaces.add(Numbers.valueOf(in.readUnsignedShort()));
        }
        List fields = this._state.getFieldsHolder();
        fields.clear();
        int fieldCount = in.readUnsignedShort();
        for (int i = 0; i < fieldCount; ++i) {
            BCField field = new BCField(this);
            fields.add(field);
            field.read(in);
        }
        List methods = this._state.getMethodsHolder();
        methods.clear();
        int methodCount = in.readUnsignedShort();
        for (int i = 0; i < methodCount; ++i) {
            BCMethod method = new BCMethod(this);
            methods.add(method);
            method.read(in);
        }
        this.readAttributes(in);
        this._loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(Class type) throws IOException {
        int dotIndex = type.getName().lastIndexOf(46) + 1;
        String className = type.getName().substring(dotIndex);
        InputStream in = type.getResourceAsStream(className + ".class");
        try {
            this.read(in, type.getClassLoader());
        }
        finally {
            in.close();
        }
    }

    void read(BCClass orig) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(orig.toByteArray());
            this.read(in, orig.getClassLoader());
            in.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        String name = this.getName();
        int dotIndex = name.lastIndexOf(46) + 1;
        name = name.substring(dotIndex);
        Class type = this.getType();
        FileOutputStream out = new FileOutputStream(URLDecoder.decode(type.getResource(name + ".class").getFile()));
        try {
            this.write(out);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File classFile) throws IOException {
        FileOutputStream out = new FileOutputStream(classFile);
        try {
            this.write(out);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    public void write(OutputStream outstream) throws IOException {
        DataOutputStream out = new DataOutputStream(outstream);
        out.writeInt(this._state.getMagic());
        out.writeShort(this._state.getMinorVersion());
        out.writeShort(this._state.getMajorVersion());
        this._state.getPool().write(out);
        out.writeShort(this._state.getAccessFlags());
        out.writeShort(this._state.getIndex());
        out.writeShort(this._state.getSuperclassIndex());
        List interfaces = this._state.getInterfacesHolder();
        out.writeShort(interfaces.size());
        Iterator itr = interfaces.iterator();
        while (itr.hasNext()) {
            out.writeShort(((Number)itr.next()).intValue());
        }
        List fields = this._state.getFieldsHolder();
        out.writeShort(fields.size());
        Iterator itr2 = fields.iterator();
        while (itr2.hasNext()) {
            ((BCField)itr2.next()).write(out);
        }
        List methods = this._state.getMethodsHolder();
        out.writeShort(methods.size());
        Iterator itr3 = methods.iterator();
        while (itr3.hasNext()) {
            ((BCMethod)itr3.next()).write(out);
        }
        this.writeAttributes(out);
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.write(out);
            out.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.toString());
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ioe) {}
        }
    }

    public int getMagic() {
        return this._state.getMagic();
    }

    public void setMagic(int magic) {
        this._state.setMagic(magic);
    }

    public int getMajorVersion() {
        return this._state.getMajorVersion();
    }

    public void setMajorVersion(int majorVersion) {
        this._state.setMajorVersion(majorVersion);
    }

    public int getMinorVersion() {
        return this._state.getMinorVersion();
    }

    public void setMinorVersion(int minorVersion) {
        this._state.setMinorVersion(minorVersion);
    }

    public int getAccessFlags() {
        return this._state.getAccessFlags();
    }

    public void setAccessFlags(int access) {
        this._state.setAccessFlags(access);
    }

    public boolean isPublic() {
        return (this.getAccessFlags() & 1) > 0;
    }

    public void makePublic() {
        this.setAccessFlags(this.getAccessFlags() | 1);
    }

    public boolean isPackage() {
        return !this.isPublic();
    }

    public void makePackage() {
        this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFFE);
    }

    public boolean isFinal() {
        return (this.getAccessFlags() & 0x10) > 0;
    }

    public void setFinal(boolean on) {
        if (on) {
            this.setAccessFlags(this.getAccessFlags() | 0x10);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFEF);
        }
    }

    public boolean isInterface() {
        return (this.getAccessFlags() & 0x200) > 0;
    }

    public void setInterface(boolean on) {
        if (on) {
            this.setAccessFlags(this.getAccessFlags() | 0x200);
            this.setAbstract(true);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFFDFF);
        }
    }

    public boolean isAbstract() {
        return (this.getAccessFlags() & 0x400) > 0;
    }

    public void setAbstract(boolean on) {
        if (on) {
            this.setAccessFlags(this.getAccessFlags() | 0x400);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFFBFF);
        }
    }

    public boolean isSynthetic() {
        return (this.getAccessFlags() & 0x1000) > 0;
    }

    public void setSynthetic(boolean on) {
        if (on) {
            this.setAccessFlags(this.getAccessFlags() | 0x1000);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFEFFF);
        }
    }

    public boolean isAnnotation() {
        return (this.getAccessFlags() & 0x2000) > 0;
    }

    public void setAnnotation(boolean on) {
        if (on) {
            this.setAccessFlags(this.getAccessFlags() | 0x2000);
            this.setAccessFlags(this.getAccessFlags() | 0x200);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFDFFF);
        }
    }

    public boolean isEnum() {
        return (this.getAccessFlags() & 0x4000) > 0;
    }

    public void setEnum(boolean on) {
        if (on) {
            this.setAccessFlags(this.getAccessFlags() | 0x4000);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFBFFF);
        }
    }

    public boolean isPrimitive() {
        return this._state.isPrimitive();
    }

    public boolean isArray() {
        return this._state.isArray();
    }

    public int getIndex() {
        return this._state.getIndex();
    }

    public void setIndex(int index) {
        String oldName = this.getName();
        String newName = ((ClassEntry)this.getPool().getEntry(index)).getNameEntry().getValue();
        this.beforeRename(oldName, newName);
        this._state.setIndex(index);
    }

    public String getName() {
        return this._state.getName();
    }

    public String getClassName() {
        String name = this._project.getNameCache().getExternalForm(this.getName(), true);
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public String getPackageName() {
        String name = this._project.getNameCache().getExternalForm(this.getName(), true);
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return name.substring(0, index);
    }

    public void setName(String name) {
        name = this._project.getNameCache().getExternalForm(name, false);
        String oldName = this.getName();
        int index = this.getIndex();
        if (index == 0) {
            index = this.getPool().findClassEntry(name, true);
        }
        ClassEntry entry = (ClassEntry)this.getPool().getEntry(index);
        this.beforeRename(oldName, name);
        int nameIndex = this.getPool().findUTF8Entry(this._project.getNameCache().getInternalForm(name, false), true);
        entry.setNameIndex(nameIndex);
        this._state.setIndex(index);
    }

    public Class getType() {
        return Strings.toClass(this.getName(), this.getClassLoader());
    }

    public String getComponentName() {
        return this._state.getComponentName();
    }

    public Class getComponentType() {
        String componentName = this.getComponentName();
        if (componentName == null) {
            return null;
        }
        return Strings.toClass(componentName, this.getClassLoader());
    }

    public BCClass getComponentBC() {
        String componentName = this.getComponentName();
        if (componentName == null) {
            return null;
        }
        return this.getProject().loadClass(componentName, this.getClassLoader());
    }

    public int getSuperclassIndex() {
        return this._state.getSuperclassIndex();
    }

    public void setSuperclassIndex(int index) {
        this._state.setSuperclassIndex(index);
    }

    public String getSuperclassName() {
        return this._state.getSuperclassName();
    }

    public Class getSuperclassType() {
        String name = this.getSuperclassName();
        if (name == null) {
            return null;
        }
        return Strings.toClass(name, this.getClassLoader());
    }

    public BCClass getSuperclassBC() {
        String name = this.getSuperclassName();
        if (name == null) {
            return null;
        }
        return this.getProject().loadClass(name, this.getClassLoader());
    }

    public void setSuperclass(String name) {
        if (name == null) {
            this.setSuperclassIndex(0);
        } else {
            this.setSuperclassIndex(this.getPool().findClassEntry(this._project.getNameCache().getInternalForm(name, false), true));
        }
    }

    public void setSuperclass(Class type) {
        if (type == null) {
            this.setSuperclass((String)null);
        } else {
            this.setSuperclass(type.getName());
        }
    }

    public void setSuperclass(BCClass type) {
        if (type == null) {
            this.setSuperclass((String)null);
        } else {
            this.setSuperclass(type.getName());
        }
    }

    public int[] getDeclaredInterfaceIndexes() {
        List interfaces = this._state.getInterfacesHolder();
        int[] indexes = new int[interfaces.size()];
        for (int i = 0; i < interfaces.size(); ++i) {
            indexes[i] = ((Number)interfaces.get(i)).intValue();
        }
        return indexes;
    }

    public void setDeclaredInterfaceIndexes(int[] interfaceIndexes) {
        List stateIndexes = this._state.getInterfacesHolder();
        stateIndexes.clear();
        for (int i = 0; i < interfaceIndexes.length; ++i) {
            Integer idx = Numbers.valueOf(interfaceIndexes[i]);
            if (stateIndexes.contains(idx)) continue;
            stateIndexes.add(idx);
        }
    }

    public String[] getDeclaredInterfaceNames() {
        int[] indexes = this.getDeclaredInterfaceIndexes();
        String[] names = new String[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            ClassEntry entry = (ClassEntry)this.getPool().getEntry(indexes[i]);
            names[i] = this._project.getNameCache().getExternalForm(entry.getNameEntry().getValue(), false);
        }
        return names;
    }

    public Class[] getDeclaredInterfaceTypes() {
        String[] names = this.getDeclaredInterfaceNames();
        Class[] types = new Class[names.length];
        for (int i = 0; i < names.length; ++i) {
            types[i] = Strings.toClass(names[i], this.getClassLoader());
        }
        return types;
    }

    public BCClass[] getDeclaredInterfaceBCs() {
        String[] names = this.getDeclaredInterfaceNames();
        BCClass[] types = new BCClass[names.length];
        for (int i = 0; i < names.length; ++i) {
            types[i] = this.getProject().loadClass(names[i], this.getClassLoader());
        }
        return types;
    }

    public void setDeclaredInterfaces(String[] interfaces) {
        this.clearDeclaredInterfaces();
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                this.declareInterface(interfaces[i]);
            }
        }
    }

    public void setDeclaredInterfaces(Class[] interfaces) {
        String[] names = null;
        if (interfaces != null) {
            names = new String[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                names[i] = interfaces[i].getName();
            }
        }
        this.setDeclaredInterfaces(names);
    }

    public void setDeclaredInterfaces(BCClass[] interfaces) {
        String[] names = null;
        if (interfaces != null) {
            names = new String[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                names[i] = interfaces[i].getName();
            }
        }
        this.setDeclaredInterfaces(names);
    }

    public String[] getInterfaceNames() {
        LinkedList<String> allNames = new LinkedList<String>();
        for (BCClass type = this; type != null; type = type.getSuperclassBC()) {
            String[] names = type.getDeclaredInterfaceNames();
            for (int i = 0; i < names.length; ++i) {
                allNames.add(names[i]);
            }
        }
        return allNames.toArray(new String[allNames.size()]);
    }

    public Class[] getInterfaceTypes() {
        LinkedList<Class> allTypes = new LinkedList<Class>();
        for (BCClass type = this; type != null; type = type.getSuperclassBC()) {
            Class[] types = type.getDeclaredInterfaceTypes();
            for (int i = 0; i < types.length; ++i) {
                allTypes.add(types[i]);
            }
        }
        return allTypes.toArray(new Class[allTypes.size()]);
    }

    public BCClass[] getInterfaceBCs() {
        LinkedList<BCClass> allTypes = new LinkedList<BCClass>();
        for (BCClass type = this; type != null; type = type.getSuperclassBC()) {
            BCClass[] types = type.getDeclaredInterfaceBCs();
            for (int i = 0; i < types.length; ++i) {
                allTypes.add(types[i]);
            }
        }
        return allTypes.toArray(new BCClass[allTypes.size()]);
    }

    public void clearDeclaredInterfaces() {
        this._state.getInterfacesHolder().clear();
    }

    public boolean removeDeclaredInterface(String name) {
        String[] names = this.getDeclaredInterfaceNames();
        Iterator itr = this._state.getInterfacesHolder().iterator();
        for (int i = 0; i < names.length; ++i) {
            itr.next();
            if (!names[i].equals(name)) continue;
            itr.remove();
            return true;
        }
        return false;
    }

    public boolean removeDeclaredInterface(Class type) {
        if (type == null) {
            return false;
        }
        return this.removeDeclaredInterface(type.getName());
    }

    public boolean removeDeclaredInterface(BCClass type) {
        if (type == null) {
            return false;
        }
        return this.removeDeclaredInterface(type.getName());
    }

    public void moveDeclaredInterface(int fromIdx, int toIdx) {
        if (fromIdx == toIdx) {
            return;
        }
        List interfaces = this._state.getInterfacesHolder();
        Object o = interfaces.remove(fromIdx);
        interfaces.add(toIdx, o);
    }

    public void declareInterface(String name) {
        Integer index = Numbers.valueOf(this.getPool().findClassEntry(this._project.getNameCache().getInternalForm(name, false), true));
        List interfaces = this._state.getInterfacesHolder();
        if (!interfaces.contains(index)) {
            interfaces.add(index);
        }
    }

    public void declareInterface(Class type) {
        this.declareInterface(type.getName());
    }

    public void declareInterface(BCClass type) {
        this.declareInterface(type.getName());
    }

    public boolean isInstanceOf(String name) {
        name = this._project.getNameCache().getExternalForm(name, false);
        String[] interfaces = this.getInterfaceNames();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].equals(name)) continue;
            return true;
        }
        for (BCClass type = this; type != null; type = type.getSuperclassBC()) {
            if (!type.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isInstanceOf(Class type) {
        if (type == null) {
            return false;
        }
        return this.isInstanceOf(type.getName());
    }

    public boolean isInstanceOf(BCClass type) {
        if (type == null) {
            return false;
        }
        return this.isInstanceOf(type.getName());
    }

    public BCField[] getDeclaredFields() {
        List fields = this._state.getFieldsHolder();
        return fields.toArray(new BCField[fields.size()]);
    }

    public BCField getDeclaredField(String name) {
        BCField[] fields = this.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals(name)) continue;
            return fields[i];
        }
        return null;
    }

    public BCField[] getFields() {
        LinkedList<BCField> allFields = new LinkedList<BCField>();
        for (BCClass type = this; type != null; type = type.getSuperclassBC()) {
            BCField[] fields = type.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                allFields.add(fields[i]);
            }
        }
        return allFields.toArray(new BCField[allFields.size()]);
    }

    public BCField[] getFields(String name) {
        LinkedList<BCField> matches = new LinkedList<BCField>();
        BCField[] fields = this.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals(name)) continue;
            matches.add(fields[i]);
        }
        return matches.toArray(new BCField[matches.size()]);
    }

    public void setDeclaredFields(BCField[] fields) {
        this.clearDeclaredFields();
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                this.declareField(fields[i]);
            }
        }
    }

    public BCField declareField(BCField field) {
        BCField newField = this.declareField(field.getName(), field.getTypeName());
        newField.setAccessFlags(field.getAccessFlags());
        newField.setAttributes(field.getAttributes());
        return newField;
    }

    public BCField declareField(String name, String type) {
        BCField field = new BCField(this);
        this._state.getFieldsHolder().add(field);
        field.initialize(name, this._project.getNameCache().getInternalForm(type, true));
        return field;
    }

    public BCField declareField(String name, Class type) {
        String typeName = type == null ? null : type.getName();
        return this.declareField(name, typeName);
    }

    public BCField declareField(String name, BCClass type) {
        String typeName = type == null ? null : type.getName();
        return this.declareField(name, typeName);
    }

    public void clearDeclaredFields() {
        List fields = this._state.getFieldsHolder();
        Iterator itr = fields.iterator();
        while (itr.hasNext()) {
            BCField field = (BCField)itr.next();
            itr.remove();
            field.invalidate();
        }
    }

    public boolean removeDeclaredField(String name) {
        List fields = this._state.getFieldsHolder();
        Iterator itr = fields.iterator();
        while (itr.hasNext()) {
            BCField field = (BCField)itr.next();
            if (!field.getName().equals(name)) continue;
            itr.remove();
            field.invalidate();
            return true;
        }
        return false;
    }

    public boolean removeDeclaredField(BCField field) {
        if (field == null) {
            return false;
        }
        return this.removeDeclaredField(field.getName());
    }

    public void moveDeclaredField(int fromIdx, int toIdx) {
        if (fromIdx == toIdx) {
            return;
        }
        List fields = this._state.getFieldsHolder();
        Object o = fields.remove(fromIdx);
        fields.add(toIdx, o);
    }

    public BCMethod[] getDeclaredMethods() {
        List methods = this._state.getMethodsHolder();
        return methods.toArray(new BCMethod[methods.size()]);
    }

    public BCMethod getDeclaredMethod(String name) {
        BCMethod[] methods = this.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            return methods[i];
        }
        return null;
    }

    public BCMethod[] getDeclaredMethods(String name) {
        LinkedList<BCMethod> matches = new LinkedList<BCMethod>();
        BCMethod[] methods = this.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            matches.add(methods[i]);
        }
        return matches.toArray(new BCMethod[matches.size()]);
    }

    public BCMethod getDeclaredMethod(String name, String[] paramTypes) {
        if (paramTypes == null) {
            paramTypes = new String[]{};
        }
        BCMethod[] methods = this.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name) || !this.paramsMatch(methods[i], paramTypes)) continue;
            return methods[i];
        }
        return null;
    }

    private boolean paramsMatch(BCMethod meth, String[] params) {
        String[] mparams = meth.getParamNames();
        if (mparams.length != params.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            if (mparams[i].equals(this._project.getNameCache().getExternalForm(params[i], false))) continue;
            return false;
        }
        return true;
    }

    public BCMethod getDeclaredMethod(String name, Class[] paramTypes) {
        if (paramTypes == null) {
            return this.getDeclaredMethod(name, (String[])null);
        }
        String[] paramNames = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramNames[i] = paramTypes[i].getName();
        }
        return this.getDeclaredMethod(name, paramNames);
    }

    public BCMethod getDeclaredMethod(String name, BCClass[] paramTypes) {
        if (paramTypes == null) {
            return this.getDeclaredMethod(name, (String[])null);
        }
        String[] paramNames = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramNames[i] = paramTypes[i].getName();
        }
        return this.getDeclaredMethod(name, paramNames);
    }

    public BCMethod[] getDeclaredMethods(String name, String[] paramTypes) {
        if (paramTypes == null) {
            paramTypes = new String[]{};
        }
        BCMethod[] methods = this.getDeclaredMethods();
        ArrayList<BCMethod> matches = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name) || !this.paramsMatch(methods[i], paramTypes)) continue;
            if (matches == null) {
                matches = new ArrayList<BCMethod>(3);
            }
            matches.add(methods[i]);
        }
        if (matches == null) {
            return new BCMethod[0];
        }
        return matches.toArray(new BCMethod[matches.size()]);
    }

    public BCMethod[] getDeclaredMethods(String name, Class[] paramTypes) {
        if (paramTypes == null) {
            return this.getDeclaredMethods(name, (String[])null);
        }
        String[] paramNames = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramNames[i] = paramTypes[i].getName();
        }
        return this.getDeclaredMethods(name, paramNames);
    }

    public BCMethod[] getDeclaredMethods(String name, BCClass[] paramTypes) {
        if (paramTypes == null) {
            return this.getDeclaredMethods(name, (String[])null);
        }
        String[] paramNames = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramNames[i] = paramTypes[i].getName();
        }
        return this.getDeclaredMethods(name, paramNames);
    }

    public BCMethod getDeclaredMethod(String name, String returnType, String[] paramTypes) {
        if (paramTypes == null) {
            paramTypes = new String[]{};
        }
        BCMethod[] methods = this.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name) || !methods[i].getReturnName().equals(this._project.getNameCache().getExternalForm(returnType, false)) || !this.paramsMatch(methods[i], paramTypes)) continue;
            return methods[i];
        }
        return null;
    }

    public BCMethod getDeclaredMethod(String name, Class returnType, Class[] paramTypes) {
        if (paramTypes == null) {
            return this.getDeclaredMethod(name, returnType.getName(), (String[])null);
        }
        String[] paramNames = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramNames[i] = paramTypes[i].getName();
        }
        return this.getDeclaredMethod(name, returnType.getName(), paramNames);
    }

    public BCMethod getDeclaredMethod(String name, BCClass returnType, BCClass[] paramTypes) {
        if (paramTypes == null) {
            return this.getDeclaredMethod(name, returnType.getName(), (String[])null);
        }
        String[] paramNames = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramNames[i] = paramTypes[i].getName();
        }
        return this.getDeclaredMethod(name, returnType.getName(), paramNames);
    }

    public BCMethod[] getMethods() {
        LinkedList<BCMethod> allMethods = new LinkedList<BCMethod>();
        for (BCClass type = this; type != null; type = type.getSuperclassBC()) {
            BCMethod[] methods = type.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                allMethods.add(methods[i]);
            }
        }
        return allMethods.toArray(new BCMethod[allMethods.size()]);
    }

    public BCMethod[] getMethods(String name) {
        LinkedList<BCMethod> matches = new LinkedList<BCMethod>();
        BCMethod[] methods = this.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            matches.add(methods[i]);
        }
        return matches.toArray(new BCMethod[matches.size()]);
    }

    public BCMethod[] getMethods(String name, String[] paramTypes) {
        if (paramTypes == null) {
            paramTypes = new String[]{};
        }
        BCMethod[] methods = this.getMethods();
        LinkedList<BCMethod> matches = new LinkedList<BCMethod>();
        for (int i = 0; i < methods.length; ++i) {
            String[] curParams;
            if (!methods[i].getName().equals(name) || (curParams = methods[i].getParamNames()).length != paramTypes.length) continue;
            boolean match = true;
            for (int j = 0; j < paramTypes.length; ++j) {
                if (curParams[j].equals(this._project.getNameCache().getExternalForm(paramTypes[j], false))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            matches.add(methods[i]);
        }
        return matches.toArray(new BCMethod[matches.size()]);
    }

    public BCMethod[] getMethods(String name, Class[] paramTypes) {
        if (paramTypes == null) {
            return this.getMethods(name, (String[])null);
        }
        String[] paramNames = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramNames[i] = paramTypes[i].getName();
        }
        return this.getMethods(name, paramNames);
    }

    public BCMethod[] getMethods(String name, BCClass[] paramTypes) {
        if (paramTypes == null) {
            return this.getMethods(name, (String[])null);
        }
        String[] paramNames = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramNames[i] = paramTypes[i].getName();
        }
        return this.getMethods(name, paramNames);
    }

    public void setDeclaredMethods(BCMethod[] methods) {
        this.clearDeclaredMethods();
        if (methods != null) {
            for (int i = 0; i < methods.length; ++i) {
                this.declareMethod(methods[i]);
            }
        }
    }

    public BCMethod declareMethod(BCMethod method) {
        BCMethod newMethod = this.declareMethod(method.getName(), method.getReturnName(), method.getParamNames());
        newMethod.setAccessFlags(method.getAccessFlags());
        newMethod.setAttributes(method.getAttributes());
        return newMethod;
    }

    public BCMethod declareMethod(String name, String returnType, String[] paramTypes) {
        BCMethod method = new BCMethod(this);
        this._state.getMethodsHolder().add(method);
        method.initialize(name, this._project.getNameCache().getDescriptor(returnType, paramTypes));
        return method;
    }

    public BCMethod declareMethod(String name, Class returnType, Class[] paramTypes) {
        String[] paramNames = null;
        if (paramTypes != null) {
            paramNames = new String[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                paramNames[i] = paramTypes[i].getName();
            }
        }
        String returnName = returnType == null ? null : returnType.getName();
        return this.declareMethod(name, returnName, paramNames);
    }

    public BCMethod declareMethod(String name, BCClass returnType, BCClass[] paramTypes) {
        String[] paramNames = null;
        if (paramTypes != null) {
            paramNames = new String[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                paramNames[i] = paramTypes[i].getName();
            }
        }
        String returnName = returnType == null ? null : returnType.getName();
        return this.declareMethod(name, returnName, paramNames);
    }

    public void clearDeclaredMethods() {
        List methods = this._state.getMethodsHolder();
        Iterator itr = methods.iterator();
        while (itr.hasNext()) {
            BCMethod method = (BCMethod)itr.next();
            itr.remove();
            method.invalidate();
        }
    }

    public boolean removeDeclaredMethod(String name) {
        List methods = this._state.getMethodsHolder();
        Iterator itr = methods.iterator();
        while (itr.hasNext()) {
            BCMethod method = (BCMethod)itr.next();
            if (!method.getName().equals(name)) continue;
            itr.remove();
            method.invalidate();
            return true;
        }
        return false;
    }

    public boolean removeDeclaredMethod(BCMethod method) {
        if (method == null) {
            return false;
        }
        return this.removeDeclaredMethod(method.getName(), method.getParamNames());
    }

    public boolean removeDeclaredMethod(String name, String[] paramTypes) {
        if (paramTypes == null) {
            paramTypes = new String[]{};
        }
        List methods = this._state.getMethodsHolder();
        Iterator itr = methods.iterator();
        while (itr.hasNext()) {
            String[] curParams;
            BCMethod method = (BCMethod)itr.next();
            if (!method.getName().equals(name) || (curParams = method.getParamNames()).length != paramTypes.length) continue;
            boolean match = true;
            for (int j = 0; j < paramTypes.length; ++j) {
                if (curParams[j].equals(this._project.getNameCache().getExternalForm(paramTypes[j], false))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            itr.remove();
            method.invalidate();
            return true;
        }
        return false;
    }

    public boolean removeDeclaredMethod(String name, Class[] paramTypes) {
        if (paramTypes == null) {
            return this.removeDeclaredMethod(name, (String[])null);
        }
        String[] paramNames = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramNames[i] = paramTypes[i].getName();
        }
        return this.removeDeclaredMethod(name, paramNames);
    }

    public boolean removeDeclaredMethod(String name, BCClass[] paramTypes) {
        if (paramTypes == null) {
            return this.removeDeclaredMethod(name, (String[])null);
        }
        String[] paramNames = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramNames[i] = paramTypes[i].getName();
        }
        return this.removeDeclaredMethod(name, paramNames);
    }

    public void moveDeclaredMethod(int fromIdx, int toIdx) {
        if (fromIdx == toIdx) {
            return;
        }
        List methods = this._state.getMethodsHolder();
        Object o = methods.remove(fromIdx);
        methods.add(toIdx, o);
    }

    public BCMethod addDefaultConstructor() {
        BCMethod method = this.getDeclaredMethod("<init>", (String[])null);
        if (method != null) {
            return method;
        }
        method = this.declareMethod("<init>", Void.TYPE, null);
        Code code = method.getCode(true);
        code.setMaxStack(1);
        code.setMaxLocals(1);
        code.xload().setThis();
        code.invokespecial().setMethod(this.getSuperclassName(), "<init>", "void", null);
        code.vreturn();
        return method;
    }

    public SourceFile getSourceFile(boolean add) {
        SourceFile source = (SourceFile)this.getAttribute("SourceFile");
        if (!add || source != null) {
            return source;
        }
        return (SourceFile)this.addAttribute("SourceFile");
    }

    public boolean removeSourceFile() {
        return this.removeAttribute("SourceFile");
    }

    public InnerClasses getInnerClasses(boolean add) {
        InnerClasses inner = (InnerClasses)this.getAttribute("InnerClasses");
        if (!add || inner != null) {
            return inner;
        }
        return (InnerClasses)this.addAttribute("InnerClasses");
    }

    public boolean removeInnerClasses() {
        return this.removeAttribute("InnerClasses");
    }

    public boolean isDeprecated() {
        return this.getAttribute("Deprecated") != null;
    }

    public void setDeprecated(boolean on) {
        if (!on) {
            this.removeAttribute("Deprecated");
        } else if (!this.isDeprecated()) {
            this.addAttribute("Deprecated");
        }
    }

    @Override
    public void acceptVisit(BCVisitor visit) {
        visit.enterBCClass(this);
        ConstantPool pool = null;
        try {
            pool = this._state.getPool();
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        if (pool != null) {
            pool.acceptVisit(visit);
        }
        BCField[] fields = this.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            visit.enterBCMember(fields[i]);
            fields[i].acceptVisit(visit);
            visit.exitBCMember(fields[i]);
        }
        BCMethod[] methods = this.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            visit.enterBCMember(methods[i]);
            methods[i].acceptVisit(visit);
            visit.exitBCMember(methods[i]);
        }
        this.visitAttributes(visit);
        visit.exitBCClass(this);
    }

    @Override
    public Project getProject() {
        return this._project;
    }

    @Override
    public ConstantPool getPool() {
        return this._state.getPool();
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this._loader != null) {
            return this._loader;
        }
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public boolean isValid() {
        return this._project != null;
    }

    @Override
    Collection getAttributesHolder() {
        return this._state.getAttributesHolder();
    }

    @Override
    BCClass getBCClass() {
        return this;
    }

    private void beforeRename(String oldName, String newName) {
        if (this._project != null && oldName != null) {
            this._project.renameClass(oldName, newName, this);
        }
    }
}

