/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.james.mailbox.model.Content;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public final class ByteContent
implements Content {
    private final byte[] contents;
    private final long size;

    public ByteContent(byte[] contents) {
        this.contents = contents;
        this.size = contents.length;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.contents);
    }

    @Override
    public Publisher<ByteBuffer> reactiveBytes() {
        return Flux.just((Object)this.contents).map(ByteBuffer::wrap);
    }
}

