/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.jpa;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mailrepository.jpa.JPAMailRepository;
import org.apache.james.server.core.MimeMessageSource;

public class MimeMessageJPASource
implements MimeMessageSource {
    private final JPAMailRepository jpaMailRepository;
    private final String key;
    private final byte[] body;

    public MimeMessageJPASource(JPAMailRepository jpaMailRepository, String key, byte[] body) {
        this.jpaMailRepository = jpaMailRepository;
        this.key = key;
        this.body = body;
    }

    public String getSourceId() {
        return this.jpaMailRepository.getRepositoryName() + "/" + this.key;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.body);
    }

    public long getMessageSize() throws IOException {
        return this.body.length;
    }
}

