/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

@ChannelHandler.Sharable
public class ConnectionPerIpLimitUpstreamHandler
extends ChannelInboundHandlerAdapter {
    private final ConcurrentMap<String, AtomicInteger> connections = new ConcurrentHashMap<String, AtomicInteger>();
    private final int maxConnectionsPerIp;

    public static Optional<ConnectionPerIpLimitUpstreamHandler> forCount(int connPerIP) {
        if (connPerIP > 0) {
            return Optional.of(new ConnectionPerIpLimitUpstreamHandler(connPerIP));
        }
        return Optional.empty();
    }

    private ConnectionPerIpLimitUpstreamHandler(int maxConnectionsPerIp) {
        Preconditions.checkArgument((maxConnectionsPerIp > 0 ? 1 : 0) != 0);
        this.maxConnectionsPerIp = maxConnectionsPerIp;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        String remoteIp = remoteAddress.getAddress().getHostAddress();
        AtomicInteger atomicCount = (AtomicInteger)this.connections.get(remoteIp);
        if (atomicCount == null) {
            atomicCount = new AtomicInteger(1);
            AtomicInteger oldAtomicCount = this.connections.putIfAbsent(remoteIp, atomicCount);
            if (oldAtomicCount != null) {
                oldAtomicCount.incrementAndGet();
            }
        } else {
            Integer count = atomicCount.incrementAndGet();
            if (count > this.maxConnectionsPerIp) {
                ctx.channel().close();
            }
        }
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        InetSocketAddress remoteAddress;
        String remoteIp;
        AtomicInteger atomicCount;
        if (this.maxConnectionsPerIp > 0 && (atomicCount = (AtomicInteger)this.connections.get(remoteIp = (remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress()).getAddress().getHostAddress())) != null) {
            atomicCount.decrementAndGet();
        }
        super.channelInactive(ctx);
    }
}

