/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.UUID;

public class TaskId {
    private final UUID value;

    public static TaskId generateTaskId() {
        return TaskId.fromUUID(UUID.randomUUID());
    }

    public static TaskId fromUUID(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid, (Object)"'uuid' should not be null");
        return new TaskId(uuid);
    }

    public static TaskId fromString(String uuid) {
        Preconditions.checkNotNull((Object)uuid, (Object)"'uuid' should not be null");
        return TaskId.fromUUID(UUID.fromString(uuid));
    }

    public TaskId(UUID value) {
        this.value = value;
    }

    public UUID getValue() {
        return this.value;
    }

    public String asString() {
        return this.value.toString();
    }

    public final boolean equals(Object o) {
        if (o instanceof TaskId) {
            TaskId taskId = (TaskId)o;
            return Objects.equals(this.value, taskId.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }
}

