/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.james.json.DTOModule;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.webadmin.service.ClearMailRepositoryTask;

public class ClearMailRepositoryTaskDTO
implements TaskDTO {
    private final String type;
    private final String mailRepositoryPath;

    public static TaskDTOModule<ClearMailRepositoryTask, ClearMailRepositoryTaskDTO> module(ClearMailRepositoryTask.Factory factory) {
        return (TaskDTOModule)DTOModule.forDomainObject(ClearMailRepositoryTask.class).convertToDTO(ClearMailRepositoryTaskDTO.class).toDomainObjectConverter(dto -> dto.fromDTO(factory)).toDTOConverter(ClearMailRepositoryTaskDTO::toDTO).typeName(ClearMailRepositoryTask.TYPE.asString()).withFactory(TaskDTOModule::new);
    }

    public static ClearMailRepositoryTaskDTO toDTO(ClearMailRepositoryTask domainObject, String typeName) {
        try {
            return new ClearMailRepositoryTaskDTO(typeName, domainObject.getMailRepositoryPath().urlEncoded());
        }
        catch (Exception e) {
            throw new ClearMailRepositoryTask.UrlEncodingFailureSerializationException(domainObject.getMailRepositoryPath());
        }
    }

    public ClearMailRepositoryTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="mailRepositoryPath") String mailRepositoryPath) {
        this.type = type;
        this.mailRepositoryPath = mailRepositoryPath;
    }

    public ClearMailRepositoryTask fromDTO(ClearMailRepositoryTask.Factory factory) {
        try {
            return factory.create(MailRepositoryPath.fromEncoded((String)this.mailRepositoryPath));
        }
        catch (Exception e) {
            throw new ClearMailRepositoryTask.InvalidMailRepositoryPathDeserializationException(this.mailRepositoryPath);
        }
    }

    public String getType() {
        return this.type;
    }

    public String getMailRepositoryPath() {
        return this.mailRepositoryPath;
    }
}

