/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.scanning;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.quota.search.Limit;
import org.apache.james.quota.search.QuotaQuery;
import org.apache.james.quota.search.QuotaSearcher;
import org.apache.james.quota.search.scanning.ClauseConverter;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.util.streams.Iterators;

public class ScanningQuotaSearcher
implements QuotaSearcher {
    private final UsersRepository usersRepository;
    private final ClauseConverter clauseConverter;

    @Inject
    public ScanningQuotaSearcher(UsersRepository usersRepository, ClauseConverter clauseConverter) {
        this.usersRepository = usersRepository;
        this.clauseConverter = clauseConverter;
    }

    public List<Username> search(QuotaQuery query) {
        Stream<Username> results = Iterators.toStream(this.listUsers()).filter(this.clauseConverter.andToPredicate(query.getClause())).sorted(Comparator.comparing(Username::asString)).skip(query.getOffset().getValue());
        return (List)this.limit(results, query.getLimit()).collect(ImmutableList.toImmutableList());
    }

    private Stream<Username> limit(Stream<Username> results, Limit limit) {
        return limit.getValue().map(results::limit).orElse(results);
    }

    private Iterator<Username> listUsers() {
        try {
            return this.usersRepository.list();
        }
        catch (UsersRepositoryException e) {
            throw new RuntimeException(e);
        }
    }
}

