/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init.configuration;

import com.datastax.driver.core.ConsistencyLevel;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.function.Function;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;

public class CassandraConsistenciesConfiguration {
    public static final CassandraConsistenciesConfiguration DEFAULT = new CassandraConsistenciesConfiguration(ConsistencyLevel.QUORUM, ConsistencyLevel.SERIAL);
    private final ConsistencyLevel regular;
    private final ConsistencyLevel lightweightTransaction;

    public static ConsistencyLevel fromString(String value) {
        switch (value) {
            case "QUORUM": {
                return ConsistencyLevel.QUORUM;
            }
            case "LOCAL_QUORUM": {
                return ConsistencyLevel.LOCAL_QUORUM;
            }
            case "EACH_QUORUM": {
                return ConsistencyLevel.EACH_QUORUM;
            }
            case "SERIAL": {
                return ConsistencyLevel.SERIAL;
            }
            case "LOCAL_SERIAL": {
                return ConsistencyLevel.LOCAL_SERIAL;
            }
        }
        throw new IllegalArgumentException("'" + value + "' is not a value ConsistencyLevel");
    }

    public static CassandraConsistenciesConfiguration fromConfiguration(CassandraConfiguration configuration) {
        return new CassandraConsistenciesConfiguration(CassandraConsistenciesConfiguration.fromString(configuration.getConsistencyLevelRegular()), CassandraConsistenciesConfiguration.fromString(configuration.getConsistencyLevelLightweightTransaction()));
    }

    private CassandraConsistenciesConfiguration(ConsistencyLevel regular, ConsistencyLevel lightweightTransaction) {
        this.regular = regular;
        this.lightweightTransaction = lightweightTransaction;
    }

    public ConsistencyLevel getRegular() {
        return this.regular;
    }

    public ConsistencyLevel getLightweightTransaction() {
        return this.lightweightTransaction;
    }

    public final boolean equals(Object o) {
        if (o instanceof CassandraConsistenciesConfiguration) {
            CassandraConsistenciesConfiguration that = (CassandraConsistenciesConfiguration)o;
            return Objects.equals(this.regular, that.regular) && Objects.equals(this.lightweightTransaction, that.lightweightTransaction);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.regular, this.lightweightTransaction);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("consistencyLevelRegular", (Object)this.regular).add("consistencyLevelLightweightTransaction", (Object)this.lightweightTransaction).toString();
    }

    public static enum ConsistencyChoice {
        WEAK(CassandraConsistenciesConfiguration::getRegular),
        STRONG(CassandraConsistenciesConfiguration::getLightweightTransaction);

        private final Function<CassandraConsistenciesConfiguration, ConsistencyLevel> choice;

        private ConsistencyChoice(Function<CassandraConsistenciesConfiguration, ConsistencyLevel> choice) {
            this.choice = choice;
        }

        public ConsistencyLevel choose(CassandraConsistenciesConfiguration configuration) {
            return this.choice.apply(configuration);
        }
    }
}

