/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import java.util.List;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.stream.NameValuePair;
import org.apache.james.mime4j.stream.ParserCursor;
import org.apache.james.mime4j.stream.RawBody;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.stream.RawFieldParser;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.ContentUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RawFieldParserTest {
    private RawFieldParser parser;

    @Before
    public void setUp() throws Exception {
        this.parser = new RawFieldParser();
    }

    @Test
    public void testBasicTokenParsing() throws Exception {
        String s = "   raw: \" some stuff \"";
        ByteSequence raw = ContentUtil.encode((CharSequence)s);
        ParserCursor cursor = new ParserCursor(0, s.length());
        this.parser.skipWhiteSpace(raw, cursor);
        junit.framework.Assert.assertFalse((boolean)cursor.atEnd());
        junit.framework.Assert.assertEquals((int)3, (int)cursor.getPos());
        StringBuilder strbuf1 = new StringBuilder();
        this.parser.copyContent(raw, cursor, RawFieldParser.INIT_BITSET((int[])new int[]{58}), strbuf1);
        junit.framework.Assert.assertFalse((boolean)cursor.atEnd());
        junit.framework.Assert.assertEquals((int)6, (int)cursor.getPos());
        junit.framework.Assert.assertEquals((String)"raw", (String)strbuf1.toString());
        junit.framework.Assert.assertEquals((int)58, (int)raw.byteAt(cursor.getPos()));
        cursor.updatePos(cursor.getPos() + 1);
        this.parser.skipWhiteSpace(raw, cursor);
        junit.framework.Assert.assertFalse((boolean)cursor.atEnd());
        junit.framework.Assert.assertEquals((int)8, (int)cursor.getPos());
        StringBuilder strbuf2 = new StringBuilder();
        this.parser.copyQuotedContent(raw, cursor, strbuf2);
        junit.framework.Assert.assertTrue((boolean)cursor.atEnd());
        junit.framework.Assert.assertEquals((String)" some stuff ", (String)strbuf2.toString());
        this.parser.copyQuotedContent(raw, cursor, strbuf2);
        junit.framework.Assert.assertTrue((boolean)cursor.atEnd());
        this.parser.skipWhiteSpace(raw, cursor);
        junit.framework.Assert.assertTrue((boolean)cursor.atEnd());
    }

    @Test
    public void testUtf8StringParsing() throws Exception {
        String s = "gr\u00e5 \"r\u00f8d\"";
        ByteSequence raw = ContentUtil.encode((CharSequence)s);
        ParserCursor cursor = new ParserCursor(0, 2 + s.length());
        StringBuilder strbuf1 = new StringBuilder();
        this.parser.copyContent(raw, cursor, RawFieldParser.INIT_BITSET((int[])new int[]{58}), strbuf1);
        junit.framework.Assert.assertFalse((boolean)cursor.atEnd());
        junit.framework.Assert.assertEquals((String)"gr\u00e5", (String)strbuf1.toString());
        this.parser.skipWhiteSpace(raw, cursor);
        StringBuilder strbuf2 = new StringBuilder();
        this.parser.copyQuotedContent(raw, cursor, strbuf2);
        junit.framework.Assert.assertEquals((String)"r\u00f8d", (String)strbuf2.toString());
    }

    @Test
    public void testTokenParsingWithQuotedPairs() throws Exception {
        String s = "raw: \"\\\"some\\stuff\\\\\"";
        ByteSequence raw = ContentUtil.encode((CharSequence)s);
        ParserCursor cursor = new ParserCursor(0, s.length());
        this.parser.skipWhiteSpace(raw, cursor);
        junit.framework.Assert.assertFalse((boolean)cursor.atEnd());
        junit.framework.Assert.assertEquals((int)0, (int)cursor.getPos());
        StringBuilder strbuf1 = new StringBuilder();
        this.parser.copyContent(raw, cursor, RawFieldParser.INIT_BITSET((int[])new int[]{58}), strbuf1);
        junit.framework.Assert.assertFalse((boolean)cursor.atEnd());
        junit.framework.Assert.assertEquals((String)"raw", (String)strbuf1.toString());
        junit.framework.Assert.assertEquals((int)58, (int)raw.byteAt(cursor.getPos()));
        cursor.updatePos(cursor.getPos() + 1);
        this.parser.skipWhiteSpace(raw, cursor);
        junit.framework.Assert.assertFalse((boolean)cursor.atEnd());
        StringBuilder strbuf2 = new StringBuilder();
        this.parser.copyQuotedContent(raw, cursor, strbuf2);
        junit.framework.Assert.assertTrue((boolean)cursor.atEnd());
        junit.framework.Assert.assertEquals((String)"\"some\\stuff\\", (String)strbuf2.toString());
    }

    @Test
    public void testTokenParsingIncompleteQuote() throws Exception {
        String s = "\"stuff and more stuff  ";
        ByteSequence raw = ContentUtil.encode((CharSequence)s);
        ParserCursor cursor = new ParserCursor(0, s.length());
        StringBuilder strbuf1 = new StringBuilder();
        this.parser.copyQuotedContent(raw, cursor, strbuf1);
        junit.framework.Assert.assertEquals((String)"stuff and more stuff  ", (String)strbuf1.toString());
    }

    @Test
    public void testSkipComments() throws Exception {
        String s = "(some (((maybe))human readable) stuff())";
        ByteSequence raw = ContentUtil.encode((CharSequence)s);
        ParserCursor cursor = new ParserCursor(0, s.length());
        this.parser.skipComment(raw, cursor);
        junit.framework.Assert.assertTrue((boolean)cursor.atEnd());
    }

    @Test
    public void testSkipCommentsWithQuotedPairs() throws Exception {
        String s = "(some (((\\)maybe))human readable\\() stuff())";
        ByteSequence raw = ContentUtil.encode((CharSequence)s);
        ParserCursor cursor = new ParserCursor(0, s.length());
        this.parser.skipComment(raw, cursor);
        junit.framework.Assert.assertTrue((boolean)cursor.atEnd());
    }

    @Test
    public void testTokenParsingTokensWithUnquotedBlanks() throws Exception {
        String s = "  stuff and   \tsome\tmore  stuff  ;";
        ByteSequence raw = ContentUtil.encode((CharSequence)s);
        ParserCursor cursor = new ParserCursor(0, s.length());
        String result = this.parser.parseToken(raw, cursor, RawFieldParser.INIT_BITSET((int[])new int[]{59}));
        junit.framework.Assert.assertEquals((String)"stuff and some more stuff", (String)result);
    }

    @Test
    public void testTokenParsingTokensWithComments() throws Exception {
        String s = " (blah-blah)  stuff(blah-blah) and some mo(blah-blah)re  stuff (blah-blah) ;";
        ByteSequence raw = ContentUtil.encode((CharSequence)s);
        ParserCursor cursor = new ParserCursor(0, s.length());
        String result = this.parser.parseToken(raw, cursor, RawFieldParser.INIT_BITSET((int[])new int[]{59}));
        junit.framework.Assert.assertEquals((String)"stuff and some more stuff", (String)result);
    }

    @Test
    public void testTokenParsingMixedValuesAndQuotedValues() throws Exception {
        String s = "  stuff and    \" some more \"   \"stuff  ;";
        ByteSequence raw = ContentUtil.encode((CharSequence)s);
        ParserCursor cursor = new ParserCursor(0, s.length());
        String result = this.parser.parseValue(raw, cursor, RawFieldParser.INIT_BITSET((int[])new int[]{59}));
        junit.framework.Assert.assertEquals((String)"stuff and  some more  stuff  ;", (String)result);
    }

    @Test
    public void testTokenParsingMixedValuesAndQuotedValues2() throws Exception {
        String s = "stuff\"more\"stuff;";
        ByteSequence raw = ContentUtil.encode((CharSequence)s);
        ParserCursor cursor = new ParserCursor(0, s.length());
        String result = this.parser.parseValue(raw, cursor, RawFieldParser.INIT_BITSET((int[])new int[]{59}));
        junit.framework.Assert.assertEquals((String)"stuffmorestuff", (String)result);
    }

    @Test
    public void testTokenParsingQuotedValuesWithComments() throws Exception {
        String s = " (blah blah)  \"(stuff)(and)(some)(more)(stuff)\" (yada yada) ";
        ByteSequence raw = ContentUtil.encode((CharSequence)s);
        ParserCursor cursor = new ParserCursor(0, s.length());
        String result = this.parser.parseValue(raw, cursor, RawFieldParser.INIT_BITSET((int[])new int[]{59}));
        junit.framework.Assert.assertEquals((String)"(stuff)(and)(some)(more)(stuff)", (String)result);
    }

    @Test
    public void testBasicParsing() throws Exception {
        String s = "raw: stuff;\r\n  more stuff";
        ByteSequence raw = ContentUtil.encode((CharSequence)s);
        RawField field = this.parser.parseField(raw);
        junit.framework.Assert.assertSame((Object)raw, (Object)field.getRaw());
        junit.framework.Assert.assertEquals((String)"raw", (String)field.getName());
        junit.framework.Assert.assertEquals((String)"stuff;  more stuff", (String)field.getBody());
        junit.framework.Assert.assertEquals((String)s, (String)field.toString());
    }

    @Test
    public void testParsingNoBlankAfterColon() throws Exception {
        String s = "raw:stuff";
        ByteSequence raw = ContentUtil.encode((CharSequence)s);
        RawField field = this.parser.parseField(raw);
        junit.framework.Assert.assertSame((Object)raw, (Object)field.getRaw());
        junit.framework.Assert.assertEquals((String)"raw", (String)field.getName());
        junit.framework.Assert.assertEquals((String)"stuff", (String)field.getBody());
        junit.framework.Assert.assertEquals((String)s, (String)field.toString());
    }

    @Test
    public void testParsingObsoleteSyntax() throws Exception {
        String s = "raw  \t  : stuff;\r\n  more stuff";
        ByteSequence raw = ContentUtil.encode((CharSequence)s);
        RawField field = this.parser.parseField(raw);
        junit.framework.Assert.assertSame((Object)raw, (Object)field.getRaw());
        junit.framework.Assert.assertEquals((String)"raw", (String)field.getName());
        junit.framework.Assert.assertEquals((String)"stuff;  more stuff", (String)field.getBody());
        junit.framework.Assert.assertEquals((String)s, (String)field.toString());
    }

    @Test
    public void testParsingInvalidSyntax1() throws Exception {
        String s = "raw    stuff;\r\n  more stuff";
        ByteSequence raw = ContentUtil.encode((CharSequence)s);
        try {
            this.parser.parseField(raw);
            Assert.fail((String)"MimeException should have been thrown");
        }
        catch (MimeException mimeException) {
            // empty catch block
        }
    }

    @Test
    public void testLongString() throws Exception {
        String body = "01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        String s = "raw: " + body;
        ByteSequence raw = ContentUtil.encode((CharSequence)s);
        RawField rawField = this.parser.parseField(raw);
        junit.framework.Assert.assertEquals((String)"raw", (String)rawField.getName());
        junit.framework.Assert.assertEquals((String)body, (String)rawField.getBody());
    }

    @Test
    public void testParsingInvalidSyntax2() throws Exception {
        String s = "raw    \t \t";
        ByteSequence raw = ContentUtil.encode((CharSequence)s);
        try {
            this.parser.parseField(raw);
            Assert.fail((String)"MimeException should have been thrown");
        }
        catch (MimeException mimeException) {
            // empty catch block
        }
    }

    @Test
    public void testNameValueParseBasics() {
        String s = "test";
        ByteSequence buf = ContentUtil.encode((CharSequence)s);
        ParserCursor cursor = new ParserCursor(0, s.length());
        NameValuePair param = this.parser.parseParameter(buf, cursor);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals(null, (Object)param.getValue());
        Assert.assertEquals((long)s.length(), (long)cursor.getPos());
        Assert.assertTrue((boolean)cursor.atEnd());
        s = "test;";
        buf = ContentUtil.encode((CharSequence)s);
        cursor = new ParserCursor(0, s.length());
        param = this.parser.parseParameter(buf, cursor);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals(null, (Object)param.getValue());
        Assert.assertEquals((long)s.length(), (long)cursor.getPos());
        Assert.assertTrue((boolean)cursor.atEnd());
        s = "test=stuff";
        buf = ContentUtil.encode((CharSequence)s);
        cursor = new ParserCursor(0, s.length());
        param = this.parser.parseParameter(buf, cursor);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals((Object)"stuff", (Object)param.getValue());
        Assert.assertEquals((long)s.length(), (long)cursor.getPos());
        Assert.assertTrue((boolean)cursor.atEnd());
        s = "   test  =   stuff ";
        buf = ContentUtil.encode((CharSequence)s);
        cursor = new ParserCursor(0, s.length());
        param = this.parser.parseParameter(buf, cursor);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals((Object)"stuff", (Object)param.getValue());
        Assert.assertEquals((long)s.length(), (long)cursor.getPos());
        Assert.assertTrue((boolean)cursor.atEnd());
        s = "   test  =   stuff ;1234";
        buf = ContentUtil.encode((CharSequence)s);
        cursor = new ParserCursor(0, s.length());
        param = this.parser.parseParameter(buf, cursor);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals((Object)"stuff", (Object)param.getValue());
        Assert.assertEquals((long)(s.length() - 4), (long)cursor.getPos());
        Assert.assertFalse((boolean)cursor.atEnd());
        s = "test  = \"stuff\"";
        buf = ContentUtil.encode((CharSequence)s);
        cursor = new ParserCursor(0, s.length());
        param = this.parser.parseParameter(buf, cursor);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals((Object)"stuff", (Object)param.getValue());
        s = "test  = text(text of some kind)/stuff(stuff of some kind)";
        buf = ContentUtil.encode((CharSequence)s);
        cursor = new ParserCursor(0, s.length());
        param = this.parser.parseParameter(buf, cursor);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals((Object)"text/stuff", (Object)param.getValue());
        s = "test  = \"  stuff\\\"\"";
        buf = ContentUtil.encode((CharSequence)s);
        cursor = new ParserCursor(0, s.length());
        param = this.parser.parseParameter(buf, cursor);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals((Object)"  stuff\"", (Object)param.getValue());
        s = "test  = \"  stuff\\\\\\\"\"";
        buf = ContentUtil.encode((CharSequence)s);
        cursor = new ParserCursor(0, s.length());
        param = this.parser.parseParameter(buf, cursor);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals((Object)"  stuff\\\"", (Object)param.getValue());
        s = "  test";
        buf = ContentUtil.encode((CharSequence)s);
        cursor = new ParserCursor(0, s.length());
        param = this.parser.parseParameter(buf, cursor);
        Assert.assertEquals((Object)"test", (Object)param.getName());
        Assert.assertEquals(null, (Object)param.getValue());
        s = "  ";
        buf = ContentUtil.encode((CharSequence)s);
        cursor = new ParserCursor(0, s.length());
        param = this.parser.parseParameter(buf, cursor);
        Assert.assertEquals((Object)"", (Object)param.getName());
        Assert.assertEquals(null, (Object)param.getValue());
        s = " = stuff ";
        buf = ContentUtil.encode((CharSequence)s);
        cursor = new ParserCursor(0, s.length());
        param = this.parser.parseParameter(buf, cursor);
        Assert.assertEquals((Object)"", (Object)param.getName());
        Assert.assertEquals((Object)"stuff", (Object)param.getValue());
    }

    @Test
    public void testNameValueListParseBasics() {
        ByteSequence buf = ContentUtil.encode((CharSequence)"test; test1 =  stuff   ; test2 =  \"stuff; stuff\"; test3=\"stuff");
        ParserCursor cursor = new ParserCursor(0, buf.length());
        List params = this.parser.parseParameters(buf, cursor);
        Assert.assertEquals((Object)"test", (Object)((NameValuePair)params.get(0)).getName());
        Assert.assertEquals(null, (Object)((NameValuePair)params.get(0)).getValue());
        Assert.assertEquals((Object)"test1", (Object)((NameValuePair)params.get(1)).getName());
        Assert.assertEquals((Object)"stuff", (Object)((NameValuePair)params.get(1)).getValue());
        Assert.assertEquals((Object)"test2", (Object)((NameValuePair)params.get(2)).getName());
        Assert.assertEquals((Object)"stuff; stuff", (Object)((NameValuePair)params.get(2)).getValue());
        Assert.assertEquals((Object)"test3", (Object)((NameValuePair)params.get(3)).getName());
        Assert.assertEquals((Object)"stuff", (Object)((NameValuePair)params.get(3)).getValue());
        Assert.assertEquals((long)buf.length(), (long)cursor.getPos());
        Assert.assertTrue((boolean)cursor.atEnd());
    }

    @Test
    public void testNameValueListParseEmpty() {
        ByteSequence buf = ContentUtil.encode((CharSequence)"    ");
        ParserCursor cursor = new ParserCursor(0, buf.length());
        List params = this.parser.parseParameters(buf, cursor);
        Assert.assertEquals((long)0L, (long)params.size());
    }

    @Test
    public void testNameValueListParseEscaped() {
        ByteSequence buf = ContentUtil.encode((CharSequence)"test1 =  \"\\\"stuff\\\"\"; test2= \"\\\\\"; test3 = \"stuff; stuff\"");
        ParserCursor cursor = new ParserCursor(0, buf.length());
        List params = this.parser.parseParameters(buf, cursor);
        Assert.assertEquals((long)3L, (long)params.size());
        Assert.assertEquals((Object)"test1", (Object)((NameValuePair)params.get(0)).getName());
        Assert.assertEquals((Object)"\"stuff\"", (Object)((NameValuePair)params.get(0)).getValue());
        Assert.assertEquals((Object)"test2", (Object)((NameValuePair)params.get(1)).getName());
        Assert.assertEquals((Object)"\\", (Object)((NameValuePair)params.get(1)).getValue());
        Assert.assertEquals((Object)"test3", (Object)((NameValuePair)params.get(2)).getName());
        Assert.assertEquals((Object)"stuff; stuff", (Object)((NameValuePair)params.get(2)).getValue());
    }

    @Test
    public void testRawBodyParse() {
        ByteSequence buf = ContentUtil.encode((CharSequence)"  text/plain ; charset=ISO-8859-1; boundary=foo; param1=value1; param2=\"value2\"; param3=value3");
        ParserCursor cursor = new ParserCursor(0, buf.length());
        RawBody body = this.parser.parseRawBody(buf, cursor);
        Assert.assertNotNull((Object)body);
        Assert.assertEquals((Object)"text/plain", (Object)body.getValue());
        List params = body.getParams();
        Assert.assertEquals((long)5L, (long)params.size());
        Assert.assertEquals((Object)"charset", (Object)((NameValuePair)params.get(0)).getName());
        Assert.assertEquals((Object)"ISO-8859-1", (Object)((NameValuePair)params.get(0)).getValue());
        Assert.assertEquals((Object)"boundary", (Object)((NameValuePair)params.get(1)).getName());
        Assert.assertEquals((Object)"foo", (Object)((NameValuePair)params.get(1)).getValue());
        Assert.assertEquals((Object)"param1", (Object)((NameValuePair)params.get(2)).getName());
        Assert.assertEquals((Object)"value1", (Object)((NameValuePair)params.get(2)).getValue());
        Assert.assertEquals((Object)"param2", (Object)((NameValuePair)params.get(3)).getName());
        Assert.assertEquals((Object)"value2", (Object)((NameValuePair)params.get(3)).getValue());
        Assert.assertEquals((Object)"param3", (Object)((NameValuePair)params.get(4)).getName());
        Assert.assertEquals((Object)"value3", (Object)((NameValuePair)params.get(4)).getValue());
    }

    @Test
    public void testRawBodyParseWithComments() {
        ByteSequence buf = ContentUtil.encode((CharSequence)"  text/(nothing special)plain ; charset=(latin)ISO-8859-1; boundary=foo(bar);");
        ParserCursor cursor = new ParserCursor(0, buf.length());
        RawBody body = this.parser.parseRawBody(buf, cursor);
        Assert.assertNotNull((Object)body);
        Assert.assertEquals((Object)"text/plain", (Object)body.getValue());
        List params = body.getParams();
        Assert.assertEquals((long)2L, (long)params.size());
        Assert.assertEquals((Object)"charset", (Object)((NameValuePair)params.get(0)).getName());
        Assert.assertEquals((Object)"ISO-8859-1", (Object)((NameValuePair)params.get(0)).getValue());
        Assert.assertEquals((Object)"boundary", (Object)((NameValuePair)params.get(1)).getName());
        Assert.assertEquals((Object)"foo", (Object)((NameValuePair)params.get(1)).getValue());
    }

    @Test
    public void testRawBodyParseEmptyParam() {
        ByteSequence buf = ContentUtil.encode((CharSequence)"multipart/alternative;; boundary=\"boundary\"");
        ParserCursor cursor = new ParserCursor(0, buf.length());
        RawBody body = this.parser.parseRawBody(buf, cursor);
        Assert.assertNotNull((Object)body);
        Assert.assertEquals((Object)"multipart/alternative", (Object)body.getValue());
        List params = body.getParams();
        Assert.assertEquals((long)2L, (long)params.size());
        Assert.assertEquals((Object)"", (Object)((NameValuePair)params.get(0)).getName());
        Assert.assertEquals(null, (Object)((NameValuePair)params.get(0)).getValue());
        Assert.assertEquals((Object)"boundary", (Object)((NameValuePair)params.get(1)).getName());
        Assert.assertEquals((Object)"boundary", (Object)((NameValuePair)params.get(1)).getValue());
    }

    @Test
    public void testRawBodyParseFolded() {
        ByteSequence buf = ContentUtil.encode((CharSequence)"multipart/alternative; boundary=\"simple\r\n boundary\"");
        ParserCursor cursor = new ParserCursor(0, buf.length());
        RawBody body = this.parser.parseRawBody(buf, cursor);
        Assert.assertNotNull((Object)body);
        Assert.assertEquals((Object)"multipart/alternative", (Object)body.getValue());
        List params = body.getParams();
        Assert.assertEquals((long)1L, (long)params.size());
        Assert.assertEquals((Object)"boundary", (Object)((NameValuePair)params.get(0)).getName());
        Assert.assertEquals((Object)"simple boundary", (Object)((NameValuePair)params.get(0)).getValue());
    }

    @Test
    public void testRegressionForContentDispositionParsingASCIIonly() {
        ByteSequence buf = ContentUtil.encode((CharSequence)"name=\"filedata\"; filename=\"Sanity a.doc\"");
        ParserCursor cursor = new ParserCursor(0, buf.length());
        List params = this.parser.parseParameters(buf, cursor);
        Assert.assertEquals((long)2L, (long)params.size());
        Assert.assertEquals((Object)"name", (Object)((NameValuePair)params.get(0)).getName());
        Assert.assertEquals((Object)"filedata", (Object)((NameValuePair)params.get(0)).getValue());
        Assert.assertEquals((Object)"filename", (Object)((NameValuePair)params.get(1)).getName());
        Assert.assertEquals((Object)"Sanity a.doc", (Object)((NameValuePair)params.get(1)).getValue());
    }

    @Test
    public void testRegressionForContentDispositionParsingUTF8() {
        ByteSequence buf = ContentUtil.encode((CharSequence)"name=\"filedata\"; filename=\"Sanity \u00e4.doc\"");
        ParserCursor cursor = new ParserCursor(0, buf.length());
        List params = this.parser.parseParameters(buf, cursor);
        Assert.assertEquals((long)2L, (long)params.size());
        Assert.assertEquals((Object)"name", (Object)((NameValuePair)params.get(0)).getName());
        Assert.assertEquals((Object)"filedata", (Object)((NameValuePair)params.get(0)).getValue());
        Assert.assertEquals((Object)"filename", (Object)((NameValuePair)params.get(1)).getName());
        Assert.assertEquals((Object)"Sanity \u00e4.doc", (Object)((NameValuePair)params.get(1)).getValue());
    }
}

