/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.codec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.james.mime4j.codec.Base64OutputStream;
import org.junit.Assert;
import org.junit.Test;

public class Base64OutputStreamTest {
    @Test
    public void testEncode() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Base64OutputStream encoder = new Base64OutputStream((OutputStream)bos);
        encoder.write(this.fromString("This is the plain text message!"));
        encoder.close();
        Assert.assertEquals((Object)"VGhpcyBpcyB0aGUgcGxhaW4gdGV4dCBtZXNzYWdlIQ==\r\n", (Object)this.toString(bos.toByteArray()));
    }

    @Test
    public void testEncodeUnderlyingStreamStaysOpen() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Base64OutputStream encoder = new Base64OutputStream((OutputStream)bos);
        encoder.write(this.fromString("This is the plain text message!"));
        encoder.close();
        try {
            encoder.write(98);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        bos.write(121);
        bos.write(97);
        bos.write(100);
        bos.write(97);
        Assert.assertEquals((Object)"VGhpcyBpcyB0aGUgcGxhaW4gdGV4dCBtZXNzYWdlIQ==\r\nyada", (Object)this.toString(bos.toByteArray()));
    }

    @Test
    public void testNoLineSeparators() throws IOException {
        Assert.assertEquals((Object)"", (Object)this.encodeNoLs(""));
        Assert.assertEquals((Object)"YQ==", (Object)this.encodeNoLs("a"));
        Assert.assertEquals((Object)"YWI=", (Object)this.encodeNoLs("ab"));
        Assert.assertEquals((Object)"YWJj", (Object)this.encodeNoLs("abc"));
        Assert.assertEquals((Object)"YWJjZA==", (Object)this.encodeNoLs("abcd"));
        Assert.assertEquals((Object)"YWJjZGU=", (Object)this.encodeNoLs("abcde"));
        Assert.assertEquals((Object)"YWJjZGVm", (Object)this.encodeNoLs("abcdef"));
        Assert.assertEquals((Object)"YWJjZGVmZw==", (Object)this.encodeNoLs("abcdefg"));
        Assert.assertEquals((Object)"YWJjZGVmZ2g=", (Object)this.encodeNoLs("abcdefgh"));
        Assert.assertEquals((Object)"YWJjZGVmZ2hp", (Object)this.encodeNoLs("abcdefghi"));
        Assert.assertEquals((Object)"DQoMCQ==", (Object)this.encodeNoLs("\r\n\f\t"));
        Assert.assertEquals((Object)"LT0/VGhhdCdzIGEgdGVzdD89LQ==", (Object)this.encodeNoLs("-=?That's a test?=-"));
    }

    @Test
    public void testLineSeparators() throws IOException {
        Assert.assertEquals((Object)"", (Object)this.encodeLs(""));
        Assert.assertEquals((Object)"YQ==\r\n", (Object)this.encodeLs("a"));
        Assert.assertEquals((Object)"YWJjZA==\r\n", (Object)this.encodeLs("abcd"));
        Assert.assertEquals((Object)"YWJjZGVmZw==\r\n", (Object)this.encodeLs("abcdefg"));
        Assert.assertEquals((Object)"YWJjZGVmZ2g=\r\n", (Object)this.encodeLs("abcdefgh"));
        Assert.assertEquals((Object)"YWJjZGVmZ2hp\r\n", (Object)this.encodeLs("abcdefghi"));
        Assert.assertEquals((Object)"YWJjZGVmZ2hp\r\nag==\r\n", (Object)this.encodeLs("abcdefghij"));
        Assert.assertEquals((Object)"YWJjZGVmZ2hp\r\nams=\r\n", (Object)this.encodeLs("abcdefghijk"));
        Assert.assertEquals((Object)"YWJjZGVmZ2hp\r\namts\r\n", (Object)this.encodeLs("abcdefghijkl"));
    }

    @Test
    public void testWriteInt() throws IOException {
        byte[] bytes = this.fromString("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345");
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        Base64OutputStream out = new Base64OutputStream((OutputStream)b);
        for (byte element : bytes) {
            out.write((int)element);
        }
        out.close();
        String actual = new String(b.toByteArray(), "US-ASCII");
        String expected = "MTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3\r\nODkwMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0\r\nNQ==\r\n";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteOffset() throws IOException {
        byte[] bytes = this.fromString("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345");
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        Base64OutputStream out = new Base64OutputStream((OutputStream)b);
        for (int offset = 0; offset < bytes.length; offset += 2) {
            int len = Math.min(2, bytes.length - offset);
            out.write(bytes, offset, len);
        }
        out.close();
        String actual = new String(b.toByteArray(), "US-ASCII");
        String expected = "MTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3\r\nODkwMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0\r\nNQ==\r\n";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testWriteFlush() throws IOException {
        byte[] bytes = this.fromString("1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345");
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        Base64OutputStream out = new Base64OutputStream((OutputStream)b);
        for (int offset = 0; offset < bytes.length; offset += 7) {
            int len = Math.min(7, bytes.length - offset);
            out.write(bytes, offset, len);
            out.flush();
        }
        out.close();
        String actual = new String(b.toByteArray(), "US-ASCII");
        String expected = "MTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3\r\nODkwMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0\r\nNQ==\r\n";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private String encodeNoLs(String str) throws IOException {
        return this.encode(str, 0, new byte[0]);
    }

    private String encodeLs(String str) throws IOException {
        return this.encode(str, 12, new byte[]{13, 10});
    }

    private String encode(String str, int lineLength, byte[] lineSeparator) throws IOException {
        byte[] bytes = this.fromString(str);
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        Base64OutputStream out = new Base64OutputStream((OutputStream)b, lineLength, lineSeparator);
        out.write(bytes);
        out.close();
        return this.toString(b.toByteArray());
    }

    private byte[] fromString(String s) {
        try {
            return s.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    private String toString(byte[] b) {
        try {
            return new String(b, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }
}

