/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.mail.MessagingException;
import java.util.Collection;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class RecipientCountExceeds
extends GenericMatcher {
    private static final int DEFAULT_RECIPIENT_COUNT = 50;
    private int recipientCount = 50;

    public void init() throws MessagingException {
        int count = Integer.parseInt(this.getMatcherConfig().getCondition());
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Argument must be a strictly positive integer");
        this.recipientCount = count;
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        if (mail.getRecipients().size() > this.recipientCount) {
            return mail.getRecipients();
        }
        return ImmutableList.of();
    }
}

