/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.geo.topic;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.util.Span;
import org.apache.commons.io.IOUtils;

public class NameEntityExtractor {
    ArrayList<String> locationNameEntities = new ArrayList();
    String bestNameEntity = null;
    private HashMap<String, Integer> tf;
    private final NameFinderME nameFinder;

    public NameEntityExtractor(NameFinderME nameFinder) throws IOException {
        this.nameFinder = nameFinder;
        this.tf = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAllNameEntitiesfromInput(InputStream stream) throws IOException {
        String[] tmp;
        Span[] nameE;
        String[] in = IOUtils.toString(stream, StandardCharsets.UTF_8).split(" ");
        NameFinderME nameFinderME = this.nameFinder;
        synchronized (nameFinderME) {
            nameE = this.nameFinder.find(in);
            this.nameFinder.clearAdaptiveData();
        }
        String spanNames = Arrays.toString(Span.spansToStrings((Span[])nameE, (String[])in));
        spanNames = spanNames.substring(1, spanNames.length() - 1);
        for (String name : tmp = spanNames.split(",")) {
            name = name.trim();
            this.locationNameEntities.add(name);
        }
    }

    public void getBestNameEntity() {
        if (this.locationNameEntities.size() == 0) {
            return;
        }
        for (int i = 0; i < this.locationNameEntities.size(); ++i) {
            if (this.tf.containsKey(this.locationNameEntities.get(i))) {
                this.tf.put(this.locationNameEntities.get(i), this.tf.get(this.locationNameEntities.get(i)) + 1);
                continue;
            }
            this.tf.put(this.locationNameEntities.get(i), 1);
        }
        int max = 0;
        ArrayList<Map.Entry<String, Integer>> list = new ArrayList<Map.Entry<String, Integer>>(this.tf.entrySet());
        Collections.shuffle(list);
        Collections.sort(list, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        this.locationNameEntities.clear();
        for (Map.Entry entry : list) {
            this.locationNameEntities.add((String)entry.getKey());
            if ((Integer)entry.getValue() <= max) continue;
            max = (Integer)entry.getValue();
            this.bestNameEntity = (String)entry.getKey();
        }
    }
}

